/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestWrapper;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestSymlinkLocalFS;
import org.apache.hadoop.test.PlatformAssumptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSymlinkLocalFSFileSystem
extends TestSymlinkLocalFS {
    @BeforeAll
    public static void testSetup() throws Exception {
        LocalFileSystem filesystem = FileSystem.getLocal((Configuration)new Configuration());
        wrapper = new FileSystemTestWrapper((FileSystem)filesystem);
    }

    @Override
    @Disabled(value="RawLocalFileSystem#mkdir does not treat existence of directory as an error")
    @Test
    @Timeout(value=10L)
    public void testMkdirExistingLink() throws IOException {
    }

    @Override
    @Disabled(value="FileSystem#create defaults to creating parents, throwing an IOException instead of FileNotFoundException")
    @Test
    @Timeout(value=10L)
    public void testCreateFileViaDanglingLinkParent() throws IOException {
    }

    @Override
    @Disabled(value="RawLocalFileSystem does not throw an exception if the path already exists")
    @Test
    @Timeout(value=10L)
    public void testCreateFileDirExistingLink() throws IOException {
    }

    @Override
    @Disabled(value="ChecksumFileSystem does not support append")
    @Test
    @Timeout(value=10L)
    public void testAccessFileViaInterSymlinkAbsTarget() throws IOException {
    }

    @Override
    public void testRenameFileWithDestParentSymlink() throws IOException {
        PlatformAssumptions.assumeNotWindows();
        super.testRenameFileWithDestParentSymlink();
    }

    @Override
    @Test
    @Timeout(value=10L)
    public void testRenameSymlinkToItself() throws IOException {
        Path file = new Path(this.testBaseDir1(), "file");
        TestSymlinkLocalFSFileSystem.createAndWriteFile(file);
        Path link = new Path(this.testBaseDir1(), "linkToFile1");
        wrapper.createSymlink(file, link, false);
        try {
            wrapper.rename(link, link, new Options.Rename[0]);
            Assertions.fail((String)"Failed to get expected IOException");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)(this.unwrapException(e) instanceof FileAlreadyExistsException));
        }
        try {
            wrapper.rename(link, link, Options.Rename.OVERWRITE);
            Assertions.fail((String)"Failed to get expected IOException");
        }
        catch (IOException e) {
            Assertions.assertTrue((this.unwrapException(e) instanceof FileAlreadyExistsException || this.unwrapException(e) instanceof FileNotFoundException ? 1 : 0) != 0);
        }
    }
}

