/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DF;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemContractBaseTest;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.StatUtils;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRawLocalFileSystemContract
extends FileSystemContractBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestRawLocalFileSystemContract.class);
    private static final Path TEST_BASE_DIR = new Path(GenericTestUtils.getRandomizedTestDir().getAbsolutePath());
    private static final String FS_TYPE_MAC = "osxfs";
    private static final Pattern HAS_DRIVE_LETTER_SPECIFIER = Pattern.compile("^/?[a-zA-Z]:");

    private static boolean looksLikeMac(String filesys) {
        return filesys.toLowerCase().contains(FS_TYPE_MAC.toLowerCase());
    }

    private static boolean looksLikeWindows(String filesys) {
        return HAS_DRIVE_LETTER_SPECIFIER.matcher(filesys).find();
    }

    @BeforeEach
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)conf).getRawFileSystem();
    }

    @Override
    protected boolean renameSupported() {
        return false;
    }

    @Override
    protected boolean rootDirTestEnabled() {
        return false;
    }

    @Override
    public String getDefaultWorkingDirectory() {
        return this.fs.getWorkingDirectory().toUri().getPath();
    }

    @Override
    protected Path getTestBaseDir() {
        return TEST_BASE_DIR;
    }

    @Override
    protected boolean filesystemIsCaseSensitive() {
        String rfsType;
        if (Shell.WINDOWS || Shell.MAC) {
            return false;
        }
        String rfsPathStr = "uninitialized";
        try {
            RawLocalFileSystem rfs = new RawLocalFileSystem();
            Configuration conf = new Configuration();
            rfs.initialize(rfs.getUri(), conf);
            rfsPathStr = Path.getPathWithoutSchemeAndAuthority((Path)rfs.getWorkingDirectory()).toString();
            File rfsPath = new File(rfsPathStr);
            rfsType = new DF(rfsPath, conf).getFilesystem();
            LOG.info("DF.Filesystem is {} for path {}", (Object)rfsType, (Object)rfsPath);
        }
        catch (IOException ex) {
            LOG.error("DF failed on path {}", (Object)rfsPathStr);
            rfsType = Shell.osType.toString();
        }
        return !TestRawLocalFileSystemContract.looksLikeMac(rfsType) && !TestRawLocalFileSystemContract.looksLikeWindows(rfsType);
    }

    @Test
    public void testPermission() throws Exception {
        Assumptions.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded(), (String)"No native library");
        Path testDir = this.getTestBaseDir();
        String testFilename = "teststat2File";
        Path path = new Path(testDir, testFilename);
        RawLocalFileSystem rfs = new RawLocalFileSystem();
        Configuration conf = new Configuration();
        rfs.initialize(rfs.getUri(), conf);
        rfs.createNewFile(path);
        File file = rfs.pathToFile(path);
        long defaultBlockSize = rfs.getDefaultBlockSize(path);
        RawLocalFileSystem.DeprecatedRawLocalFileStatus fsNIO = new RawLocalFileSystem.DeprecatedRawLocalFileStatus(file, defaultBlockSize, (FileSystem)rfs);
        fsNIO.loadPermissionInfoByNativeIO();
        RawLocalFileSystem.DeprecatedRawLocalFileStatus fsnonNIO = new RawLocalFileSystem.DeprecatedRawLocalFileStatus(file, defaultBlockSize, (FileSystem)rfs);
        fsnonNIO.loadPermissionInfoByNonNativeIO();
        Assertions.assertEquals((Object)fsNIO.getOwner(), (Object)fsnonNIO.getOwner());
        Assertions.assertEquals((Object)fsNIO.getGroup(), (Object)fsnonNIO.getGroup());
        Assertions.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
        LOG.info("owner: {}, group: {}, permission: {}, isSticky: {}", new Object[]{fsNIO.getOwner(), fsNIO.getGroup(), fsNIO.getPermission(), fsNIO.getPermission().getStickyBit()});
        StatUtils.setPermissionFromProcess("644", file.getPath());
        fsNIO.loadPermissionInfoByNativeIO();
        fsnonNIO.loadPermissionInfoByNonNativeIO();
        Assertions.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
        Assertions.assertEquals((int)644, (int)fsNIO.getPermission().toOctal());
        Assertions.assertFalse((boolean)fsNIO.getPermission().getStickyBit());
        Assertions.assertFalse((boolean)fsnonNIO.getPermission().getStickyBit());
        if (!Shell.WINDOWS) {
            StatUtils.setPermissionFromProcess("1644", file.getPath());
            fsNIO.loadPermissionInfoByNativeIO();
            fsnonNIO.loadPermissionInfoByNonNativeIO();
            Assertions.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
            Assertions.assertEquals((int)1644, (int)fsNIO.getPermission().toOctal());
            Assertions.assertEquals((Object)true, (Object)fsNIO.getPermission().getStickyBit());
            Assertions.assertEquals((Object)true, (Object)fsnonNIO.getPermission().getStickyBit());
            StatUtils.setPermissionFromProcess("-t", file.getPath());
            fsNIO.loadPermissionInfoByNativeIO();
            fsnonNIO.loadPermissionInfoByNonNativeIO();
            Assertions.assertEquals((Object)fsNIO.getPermission(), (Object)fsnonNIO.getPermission());
            Assertions.assertEquals((int)644, (int)fsNIO.getPermission().toOctal());
            Assertions.assertEquals((Object)false, (Object)fsNIO.getPermission().getStickyBit());
            Assertions.assertEquals((Object)false, (Object)fsnonNIO.getPermission().getStickyBit());
        }
    }
}

