/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestFsShellList {
    private static Configuration conf;
    private static FsShell shell;
    private static LocalFileSystem lfs;
    private static Path testRootDir;

    @BeforeAll
    public static void setup() throws Exception {
        conf = new Configuration();
        shell = new FsShell(conf);
        lfs = FileSystem.getLocal((Configuration)conf);
        lfs.setVerifyChecksum(true);
        lfs.setWriteChecksum(true);
        String root = System.getProperty("test.build.data", "test/build/data");
        testRootDir = lfs.makeQualified(new Path(root, "testFsShellList"));
        Assertions.assertThat((boolean)lfs.mkdirs(testRootDir)).isTrue();
    }

    @AfterAll
    public static void teardown() throws Exception {
        lfs.delete(testRootDir, true);
    }

    private void createFile(Path filePath) throws Exception {
        FSDataOutputStream out = lfs.create(filePath);
        out.writeChars("I am " + filePath);
        out.close();
        Assertions.assertThat((boolean)lfs.exists(lfs.getChecksumFile(filePath))).isTrue();
    }

    @Test
    public void testList() throws Exception {
        this.createFile(new Path(testRootDir, "abc"));
        String[] lsArgv = new String[]{"-ls", testRootDir.toString()};
        Assertions.assertThat((int)shell.run(lsArgv)).isEqualTo(0);
        if (!Path.WINDOWS) {
            this.createFile(new Path(testRootDir, "abc\bd\tef"));
            this.createFile(new Path(testRootDir, "qq\r123"));
        }
        this.createFile(new Path(testRootDir, "ghi"));
        lsArgv = new String[]{"-ls", testRootDir.toString()};
        Assertions.assertThat((int)shell.run(lsArgv)).isEqualTo(0);
        lsArgv = new String[]{"-ls", "-q", testRootDir.toString()};
        Assertions.assertThat((int)shell.run(lsArgv)).isEqualTo(0);
    }

    @Test
    public void testListWithUGI() throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            FsShell fsShell = new FsShell(new Configuration());
            fsShell.getConf().set("hadoop.security.authentication", "DUMMYAUTH");
            String[] lsArgv = new String[]{"-ls", testRootDir.toString()};
            fsShell.run(lsArgv);
        });
    }
}

