/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ServiceConfigurationError;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Progressable;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFileSystemInitialization {
    @Test
    public void testInitializationWithRegisteredStreamFactory() {
        Configuration conf = new Configuration();
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory(conf));
        try {
            FileSystem.getFileSystemClass((String)"file", (Configuration)conf);
        }
        catch (IOException ok) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)false);
        }
    }

    @Test
    public void testMissingLibraries() {
        try {
            Configuration conf = new Configuration();
            Class fs = FileSystem.getFileSystemClass((String)"s3a", (Configuration)conf);
            org.junit.jupiter.api.Assertions.fail((String)("Expected an exception, got a filesystem: " + fs));
        }
        catch (Exception | ServiceConfigurationError throwable) {
            // empty catch block
        }
    }

    @Test
    public void testNewInstanceFailure() throws Throwable {
        LambdaTestUtils.intercept(IOException.class, "initialize()", () -> FileSystem.newInstance((URI)new URI("failing://localhost"), (Configuration)FailingFileSystem.failingConf()));
        ((AbstractIntegerAssert)Assertions.assertThat((int)FailingFileSystem.initCount).describedAs("init count", new Object[0])).isEqualTo(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)FailingFileSystem.closeCount).describedAs("close count", new Object[0])).isEqualTo(1);
    }

    public static class FailingFileSystem
    extends FileSystem {
        public static final String INITIALIZE = "initialize()";
        public static final String CLOSE = "close()";
        private static int initCount;
        private static int closeCount;

        private static Configuration failingConf() {
            Configuration conf = new Configuration(false);
            conf.setClass("fs.failing.impl", FailingFileSystem.class, FileSystem.class);
            return conf;
        }

        public void initialize(URI name, Configuration conf) throws IOException {
            super.initialize(name, conf);
            ++initCount;
            throw new IOException(INITIALIZE);
        }

        public void close() throws IOException {
            ++closeCount;
            throw new IOException(CLOSE);
        }

        public URI getUri() {
            return null;
        }

        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return null;
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return null;
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            return null;
        }

        public boolean rename(Path src, Path dst) throws IOException {
            return false;
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            return false;
        }

        public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
            return new FileStatus[0];
        }

        public void setWorkingDirectory(Path new_dir) {
        }

        public Path getWorkingDirectory() {
            return null;
        }

        public boolean mkdirs(Path f, FsPermission permission) throws IOException {
            return false;
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            return null;
        }
    }
}

