/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestFileContextResolveAfs {
    private static String TEST_ROOT_DIR_LOCAL;
    private FileContext fc;
    private FileSystem localFs;

    @BeforeEach
    public void setup() throws IOException {
        this.fc = FileContext.getFileContext();
    }

    @Test
    @Timeout(value=30L)
    public void testFileContextResolveAfs() throws IOException {
        Configuration conf = new Configuration();
        this.localFs = FileSystem.get((Configuration)conf);
        Path localPath = new Path(TEST_ROOT_DIR_LOCAL + "/TestFileContextResolveAfs1");
        Path linkPath = this.localFs.makeQualified(new Path(TEST_ROOT_DIR_LOCAL, "TestFileContextResolveAfs2"));
        this.localFs.mkdirs(new Path(TEST_ROOT_DIR_LOCAL));
        this.localFs.create(localPath);
        this.fc.createSymlink(localPath, linkPath, true);
        Set afsList = this.fc.resolveAbstractFileSystems(linkPath);
        Assertions.assertEquals((int)1, (int)afsList.size());
        this.localFs.delete(linkPath, true);
        this.localFs.delete(localPath, true);
        this.localFs.close();
    }

    static {
        FileSystem.enableSymlinks();
        TEST_ROOT_DIR_LOCAL = GenericTestUtils.getTestDir().getAbsolutePath();
    }
}

