/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=30L)
public abstract class FileSystemContractBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemContractBaseTest.class);
    protected static final String TEST_UMASK = "062";
    protected FileSystem fs;
    protected byte[] data = this.dataset(this.getBlockSize() * 2, 0, 255);

    protected int getGlobalTimeout() {
        return 30000;
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.fs != null) {
            if (this.rootDirTestEnabled()) {
                this.cleanupDir(this.path("/FileSystemContractBaseTest"));
            }
            this.cleanupDir(this.getTestBaseDir());
        }
    }

    private void cleanupDir(Path p) {
        try {
            LOG.info("Deleting " + p);
            this.fs.delete(p, true);
        }
        catch (IOException e) {
            LOG.error("Error deleting test dir: " + p, (Throwable)e);
        }
    }

    protected Path getTestBaseDir() {
        return new Path(this.fs.getWorkingDirectory(), "FileSystemContractBaseTest");
    }

    protected final Path path(String pathString) {
        Path p = new Path(pathString).makeQualified(this.fs.getUri(), this.getTestBaseDir());
        LOG.info("Resolving {} -> {}", (Object)pathString, (Object)p);
        return p;
    }

    protected int getBlockSize() {
        return 1024;
    }

    protected String getDefaultWorkingDirectory() {
        return "/user/" + System.getProperty("user.name");
    }

    protected boolean renameSupported() {
        return true;
    }

    protected boolean rootDirTestEnabled() {
        return true;
    }

    protected boolean filesystemIsCaseSensitive() {
        return true;
    }

    @Test
    public void testFsStatus() throws Exception {
        FsStatus fsStatus = this.fs.getStatus();
        Assertions.assertNotNull((Object)fsStatus);
        Assertions.assertTrue((fsStatus.getUsed() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((fsStatus.getRemaining() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((fsStatus.getCapacity() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        Path workDir = this.path(this.getDefaultWorkingDirectory());
        Assertions.assertEquals((Object)workDir, (Object)this.fs.getWorkingDirectory());
        this.fs.setWorkingDirectory(this.fs.makeQualified(new Path(".")));
        Assertions.assertEquals((Object)workDir, (Object)this.fs.getWorkingDirectory());
        this.fs.setWorkingDirectory(this.fs.makeQualified(new Path("..")));
        Assertions.assertEquals((Object)workDir.getParent(), (Object)this.fs.getWorkingDirectory());
        Path relativeDir = this.fs.makeQualified(new Path("testWorkingDirectory"));
        this.fs.setWorkingDirectory(relativeDir);
        Assertions.assertEquals((Object)relativeDir, (Object)this.fs.getWorkingDirectory());
        Path absoluteDir = this.path("/FileSystemContractBaseTest/testWorkingDirectory");
        this.fs.setWorkingDirectory(absoluteDir);
        Assertions.assertEquals((Object)absoluteDir, (Object)this.fs.getWorkingDirectory());
    }

    @Test
    public void testMkdirs() throws Exception {
        Path testDir = this.path("testMkdirs");
        Assertions.assertFalse((boolean)this.fs.exists(testDir));
        Assertions.assertFalse((boolean)this.fs.isFile(testDir));
        Assertions.assertTrue((boolean)this.fs.mkdirs(testDir));
        Assertions.assertTrue((boolean)this.fs.exists(testDir));
        Assertions.assertFalse((boolean)this.fs.isFile(testDir));
        Assertions.assertTrue((boolean)this.fs.mkdirs(testDir));
        Assertions.assertTrue((boolean)this.fs.exists(testDir));
        Assertions.assertTrue((boolean)this.fs.isDirectory(testDir), (String)"Should be a directory");
        Assertions.assertFalse((boolean)this.fs.isFile(testDir));
        Path parentDir = testDir.getParent();
        Assertions.assertTrue((boolean)this.fs.exists(parentDir));
        Assertions.assertFalse((boolean)this.fs.isFile(parentDir));
        Path grandparentDir = parentDir.getParent();
        Assertions.assertTrue((boolean)this.fs.exists(grandparentDir));
        Assertions.assertFalse((boolean)this.fs.isFile(grandparentDir));
    }

    @Test
    public void testMkdirsFailsForSubdirectoryOfExistingFile() throws Exception {
        Path testDir = this.path("testMkdirsFailsForSubdirectoryOfExistingFile");
        Assertions.assertFalse((boolean)this.fs.exists(testDir));
        Assertions.assertTrue((boolean)this.fs.mkdirs(testDir));
        Assertions.assertTrue((boolean)this.fs.exists(testDir));
        this.createFile(this.path("testMkdirsFailsForSubdirectoryOfExistingFile/file"));
        Path testSubDir = this.path("testMkdirsFailsForSubdirectoryOfExistingFile/file/subdir");
        try {
            this.fs.mkdirs(testSubDir);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assertions.assertFalse((boolean)this.fs.exists(testSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        Path testDeepSubDir = this.path("testMkdirsFailsForSubdirectoryOfExistingFile/file/deep/sub/dir");
        try {
            this.fs.mkdirs(testDeepSubDir);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assertions.assertFalse((boolean)this.fs.exists(testDeepSubDir));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMkdirsWithUmask() throws Exception {
        Configuration conf = this.fs.getConf();
        String oldUmask = conf.get("fs.permissions.umask-mode");
        try {
            conf.set("fs.permissions.umask-mode", TEST_UMASK);
            Path dir = this.path("newDir");
            Assertions.assertTrue((boolean)this.fs.mkdirs(dir, new FsPermission(511)));
            FileStatus status = this.fs.getFileStatus(dir);
            Assertions.assertTrue((boolean)status.isDirectory());
            Assertions.assertEquals((short)461, (short)status.getPermission().toShort());
        }
        finally {
            conf.set("fs.permissions.umask-mode", oldUmask);
        }
    }

    @Test
    public void testGetFileStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fs.getFileStatus(this.path("testGetFileStatusThrowsExceptionForNonExistentFile/file"));
            Assertions.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatusThrowsExceptionForNonExistentFile() throws Exception {
        try {
            this.fs.listStatus(this.path("testListStatusThrowsExceptionForNonExistentFile/file"));
            Assertions.fail((String)"Should throw FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testListStatus() throws Exception {
        Path[] testDirs = new Path[]{this.path("testListStatus/a"), this.path("testListStatus/b"), this.path("testListStatus/c/1")};
        Assertions.assertFalse((boolean)this.fs.exists(testDirs[0]));
        for (Path path : testDirs) {
            Assertions.assertTrue((boolean)this.fs.mkdirs(path));
        }
        FileStatus[] paths = this.fs.listStatus(this.path("."));
        Assertions.assertEquals((int)1, (int)paths.length);
        Assertions.assertEquals((Object)this.path("testListStatus"), (Object)paths[0].getPath());
        paths = this.fs.listStatus(this.path("testListStatus"));
        Assertions.assertEquals((int)3, (int)paths.length);
        ArrayList<Path> list = new ArrayList<Path>();
        for (FileStatus fileState : paths) {
            list.add(fileState.getPath());
        }
        Assertions.assertTrue((boolean)list.contains(this.path("testListStatus/a")));
        Assertions.assertTrue((boolean)list.contains(this.path("testListStatus/b")));
        Assertions.assertTrue((boolean)list.contains(this.path("testListStatus/c")));
        paths = this.fs.listStatus(this.path("testListStatus/a"));
        Assertions.assertEquals((int)0, (int)paths.length);
    }

    @Test
    public void testWriteReadAndDeleteEmptyFile() throws Exception {
        this.writeReadAndDelete(0);
    }

    @Test
    public void testWriteReadAndDeleteHalfABlock() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteOneBlock() throws Exception {
        this.writeReadAndDelete(this.getBlockSize());
    }

    @Test
    public void testWriteReadAndDeleteOneAndAHalfBlocks() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() + this.getBlockSize() / 2);
    }

    @Test
    public void testWriteReadAndDeleteTwoBlocks() throws Exception {
        this.writeReadAndDelete(this.getBlockSize() * 2);
    }

    protected void writeReadAndDelete(int len) throws IOException {
        Path path = this.path("writeReadAndDelete/file");
        this.writeAndRead(path, this.data, len, false, true);
    }

    @Test
    public void testOverwrite() throws IOException {
        Path path = this.path("testOverwrite/file");
        this.fs.mkdirs(path.getParent());
        this.createFile(path);
        Assertions.assertTrue((boolean)this.fs.exists(path), (String)"Exists");
        Assertions.assertEquals((long)this.data.length, (long)this.fs.getFileStatus(path).getLen(), (String)"Length");
        try {
            this.fs.create(path, false).close();
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FSDataOutputStream out = this.fs.create(path, true);
        out.write(this.data, 0, this.data.length);
        out.close();
        Assertions.assertTrue((boolean)this.fs.exists(path), (String)"Exists");
        Assertions.assertEquals((long)this.data.length, (long)this.fs.getFileStatus(path).getLen(), (String)"Length");
    }

    @Test
    public void testWriteInNonExistentDirectory() throws IOException {
        Path path = this.path("testWriteInNonExistentDirectory/file");
        Assertions.assertFalse((boolean)this.fs.exists(path.getParent()), (String)"Parent exists");
        this.createFile(path);
        Assertions.assertTrue((boolean)this.fs.exists(path), (String)"Exists");
        Assertions.assertEquals((long)this.data.length, (long)this.fs.getFileStatus(path).getLen(), (String)"Length");
        Assertions.assertTrue((boolean)this.fs.exists(path.getParent()), (String)"Parent exists");
    }

    @Test
    public void testDeleteNonExistentFile() throws IOException {
        Path path = this.path("testDeleteNonExistentFile/file");
        Assertions.assertFalse((boolean)this.fs.exists(path), (String)("Path exists: " + path));
        Assertions.assertFalse((boolean)this.fs.delete(path, true), (String)"No deletion");
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        Path dir = this.path("testDeleteRecursively");
        Path file = this.path("testDeleteRecursively/file");
        Path subdir = this.path("testDeleteRecursively/subdir");
        this.createFile(file);
        Assertions.assertTrue((boolean)this.fs.mkdirs(subdir), (String)"Created subdir");
        Assertions.assertTrue((boolean)this.fs.exists(file), (String)"File exists");
        Assertions.assertTrue((boolean)this.fs.exists(dir), (String)"Dir exists");
        Assertions.assertTrue((boolean)this.fs.exists(subdir), (String)"Subdir exists");
        try {
            this.fs.delete(dir, false);
            Assertions.fail((String)"Should throw IOException.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertTrue((boolean)this.fs.exists(file), (String)"File still exists");
        Assertions.assertTrue((boolean)this.fs.exists(dir), (String)"Dir still exists");
        Assertions.assertTrue((boolean)this.fs.exists(subdir), (String)"Subdir still exists");
        Assertions.assertTrue((boolean)this.fs.delete(dir, true), (String)"Deleted");
        Assertions.assertFalse((boolean)this.fs.exists(file), (String)"File doesn't exist");
        Assertions.assertFalse((boolean)this.fs.exists(dir), (String)"Dir doesn't exist");
        Assertions.assertFalse((boolean)this.fs.exists(subdir), (String)"Subdir doesn't exist");
    }

    @Test
    public void testDeleteEmptyDirectory() throws IOException {
        Path dir = this.path("testDeleteEmptyDirectory");
        Assertions.assertTrue((boolean)this.fs.mkdirs(dir));
        Assertions.assertTrue((boolean)this.fs.exists(dir), (String)"Dir exists");
        Assertions.assertTrue((boolean)this.fs.delete(dir, false), (String)"Deleted");
        Assertions.assertFalse((boolean)this.fs.exists(dir), (String)"Dir doesn't exist");
    }

    @Test
    public void testRenameNonExistentPath() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameNonExistentPath/path");
        Path dst = this.path("testRenameNonExistentPathNew/newpath");
        this.rename(src, dst, false, false, false);
    }

    @Test
    public void testRenameFileMoveToNonExistentDirectory() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameFileMoveToNonExistentDirectory/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileMoveToNonExistentDirectoryNew/newfile");
        this.rename(src, dst, false, true, false);
    }

    @Test
    public void testRenameFileMoveToExistingDirectory() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameFileMoveToExistingDirectory/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileMoveToExistingDirectoryNew/newfile");
        this.fs.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true);
    }

    @Test
    public void testRenameFileAsExistingFile() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameFileAsExistingFile/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileAsExistingFileNew/newfile");
        this.createFile(dst);
        this.rename(src, dst, false, true, true);
    }

    @Test
    public void testRenameFileAsExistingDirectory() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameFileAsExistingDirectory/file");
        this.createFile(src);
        Path dst = this.path("testRenameFileAsExistingDirectoryNew/newdir");
        this.fs.mkdirs(dst);
        this.rename(src, dst, true, false, true);
        this.assertIsFile(this.path("testRenameFileAsExistingDirectoryNew/newdir/file"));
    }

    @Test
    public void testRenameDirectoryMoveToNonExistentDirectory() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameDirectoryMoveToNonExistentDirectory/dir");
        this.fs.mkdirs(src);
        Path dst = this.path("testRenameDirectoryMoveToNonExistentDirectoryNew/newdir");
        this.rename(src, dst, false, true, false);
    }

    @Test
    public void testRenameDirectoryMoveToExistingDirectory() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameDirectoryMoveToExistingDirectory/dir");
        this.fs.mkdirs(src);
        this.createFile(this.path(src + "/file1"));
        this.createFile(this.path(src + "/subdir/file2"));
        Path dst = this.path("testRenameDirectoryMoveToExistingDirectoryNew/newdir");
        this.fs.mkdirs(dst.getParent());
        this.rename(src, dst, true, false, true);
        Assertions.assertFalse((boolean)this.fs.exists(this.path(src + "/file1")), (String)"Nested file1 exists");
        Assertions.assertFalse((boolean)this.fs.exists(this.path(src + "/subdir/file2")), (String)"Nested file2 exists");
        Assertions.assertTrue((boolean)this.fs.exists(this.path(dst + "/file1")), (String)"Renamed nested file1 exists");
        Assertions.assertTrue((boolean)this.fs.exists(this.path(dst + "/subdir/file2")), (String)"Renamed nested exists");
    }

    @Test
    public void testRenameDirectoryAsExistingFile() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameDirectoryAsExistingFile/dir");
        this.fs.mkdirs(src);
        Path dst = this.path("testRenameDirectoryAsExistingFileNew/newfile");
        this.createFile(dst);
        this.rename(src, dst, false, true, true);
    }

    @Test
    public void testRenameDirectoryAsExistingDirectory() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path src = this.path("testRenameDirectoryAsExistingDirectory/dir");
        this.fs.mkdirs(src);
        this.createFile(this.path(src + "/file1"));
        this.createFile(this.path(src + "/subdir/file2"));
        Path dst = this.path("testRenameDirectoryAsExistingDirectoryNew/newdir");
        this.fs.mkdirs(dst);
        this.rename(src, dst, true, false, true);
        Assertions.assertTrue((boolean)this.fs.exists(this.path(dst + "/dir")), (String)"Destination changed");
        Assertions.assertFalse((boolean)this.fs.exists(this.path(src + "/file1")), (String)"Nested file1 exists");
        Assertions.assertFalse((boolean)this.fs.exists(this.path(src + "/dir/subdir/file2")), (String)"Nested file2 exists");
        Assertions.assertTrue((boolean)this.fs.exists(this.path(dst + "/dir/file1")), (String)"Renamed nested file1 exists");
        Assertions.assertTrue((boolean)this.fs.exists(this.path(dst + "/dir/subdir/file2")), (String)"Renamed nested exists");
    }

    @Test
    public void testInputStreamClosedTwice() throws IOException {
        Path src = this.path("testInputStreamClosedTwice/file");
        this.createFile(src);
        FSDataInputStream in = this.fs.open(src);
        in.close();
        in.close();
    }

    @Test
    public void testOutputStreamClosedTwice() throws IOException {
        Path src = this.path("testOutputStreamClosedTwice/file");
        FSDataOutputStream out = this.fs.create(src);
        out.writeChar(72);
        out.close();
        out.close();
    }

    protected void createFile(Path path) throws IOException {
        FSDataOutputStream out = this.fs.create(path);
        out.write(this.data, 0, this.data.length);
        out.close();
    }

    protected void rename(Path src, Path dst, boolean renameSucceeded, boolean srcExists, boolean dstExists) throws IOException {
        Assertions.assertEquals((Object)renameSucceeded, (Object)this.fs.rename(src, dst), (String)"Rename result");
        Assertions.assertEquals((Object)srcExists, (Object)this.fs.exists(src), (String)"Source exists");
        Assertions.assertEquals((Object)dstExists, (Object)this.fs.exists(dst), (String)("Destination exists" + dst));
    }

    @Test
    public void testOverWriteAndRead() throws Exception {
        int blockSize = this.getBlockSize();
        byte[] filedata1 = this.dataset(blockSize * 2, 65, 26);
        byte[] filedata2 = this.dataset(blockSize * 2, 97, 26);
        Path path = this.path("testOverWriteAndRead/file-overwrite");
        this.writeAndRead(path, filedata1, blockSize, true, false);
        this.writeAndRead(path, filedata2, blockSize, true, false);
        this.writeAndRead(path, filedata1, blockSize * 2, true, false);
        this.writeAndRead(path, filedata2, blockSize * 2, true, false);
        this.writeAndRead(path, filedata1, blockSize, true, false);
        this.writeAndRead(path, filedata2, blockSize * 2, true, false);
    }

    @Test
    public void testFilesystemIsCaseSensitive() throws Exception {
        if (!this.filesystemIsCaseSensitive()) {
            LOG.info("Skipping test");
            return;
        }
        String mixedCaseFilename = "testFilesystemIsCaseSensitive";
        Path upper = this.path(mixedCaseFilename);
        Path lower = this.path(StringUtils.toLowerCase((String)mixedCaseFilename));
        Assertions.assertFalse((boolean)this.fs.exists(upper), (String)("File exists" + upper));
        Assertions.assertFalse((boolean)this.fs.exists(lower), (String)("File exists" + lower));
        FSDataOutputStream out = this.fs.create(upper);
        out.writeUTF("UPPER");
        out.close();
        FileStatus upperStatus = this.fs.getFileStatus(upper);
        Assertions.assertTrue((boolean)this.fs.exists(upper), (String)("File does not exist" + upper));
        Assertions.assertFalse((boolean)this.fs.exists(lower), (String)("File exists" + lower));
        out = this.fs.create(lower);
        out.writeUTF("l");
        out.close();
        Assertions.assertTrue((boolean)this.fs.exists(lower), (String)("File does not exist" + lower));
        FileStatus newStatus = this.fs.getFileStatus(upper);
        Assertions.assertEquals((long)upperStatus.getLen(), (long)newStatus.getLen(), (String)("Expected status:" + upperStatus + " actual status " + newStatus));
    }

    @Test
    public void testZeroByteFilesAreFiles() throws Exception {
        Path src = this.path("testZeroByteFilesAreFiles");
        FSDataOutputStream out = this.fs.create(src);
        out.close();
        this.assertIsFile(src);
    }

    @Test
    public void testMultiByteFilesAreFiles() throws Exception {
        Path src = this.path("testMultiByteFilesAreFiles");
        FSDataOutputStream out = this.fs.create(src);
        out.writeUTF("testMultiByteFilesAreFiles");
        out.close();
        this.assertIsFile(src);
    }

    @Test
    public void testRootDirAlwaysExists() throws Exception {
        this.fs.getFileStatus(this.path("/"));
        Assertions.assertTrue((boolean)this.fs.exists(this.path("/")), (String)"FileSystem.exists() fails for root");
    }

    @Test
    public void testRenameRootDirForbidden() throws Exception {
        Assumptions.assumeTrue((boolean)this.rootDirTestEnabled());
        Assumptions.assumeTrue((boolean)this.renameSupported());
        this.rename(this.path("/"), this.path("testRenameRootDirForbidden"), false, true, false);
    }

    @Test
    public void testRenameChildDirForbidden() throws Exception {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        LOG.info("testRenameChildDirForbidden");
        Path parentdir = this.path("testRenameChildDirForbidden");
        this.fs.mkdirs(parentdir);
        Path childFile = new Path(parentdir, "childfile");
        this.createFile(childFile);
        Path childdir = new Path(parentdir, "childdir");
        this.rename(parentdir, childdir, false, true, false);
        this.fs.mkdirs(childdir);
        Path childchilddir = new Path(childdir, "childdir");
        this.rename(parentdir, childchilddir, false, true, false);
    }

    public void testRenameEmptyToDirWithSamePrefixAllowed() throws Throwable {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path parentdir = this.path("testRenameEmptyToDirWithSamePrefixAllowed");
        this.fs.mkdirs(parentdir);
        Path dest = this.path("testRenameEmptyToDirWithSamePrefixAllowedDest");
        this.rename(parentdir, dest, true, false, true);
    }

    @Test
    public void testRenameToDirWithSamePrefixAllowed() throws Throwable {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path parentdir = this.path("testRenameToDirWithSamePrefixAllowed");
        this.fs.mkdirs(parentdir);
        this.createFile(new Path(parentdir, "mychild"));
        Path dest = this.path("testRenameToDirWithSamePrefixAllowedDest");
        this.rename(parentdir, dest, true, false, true);
    }

    @Test
    public void testRenameDirToSelf() throws Throwable {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path parentdir = this.path("testRenameDirToSelf");
        this.fs.mkdirs(parentdir);
        Path child = new Path(parentdir, "child");
        this.createFile(child);
        this.rename(parentdir, parentdir, false, true, true);
        this.assertIsFile(child);
    }

    @Test
    public void testMoveDirUnderParent() throws Throwable {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path testdir = this.path("testMoveDirUnderParent");
        this.fs.mkdirs(testdir);
        Path parent = testdir.getParent();
        this.fs.rename(testdir, parent);
        Assertions.assertEquals((Object)true, (Object)this.fs.exists(testdir), (String)("Source exists: " + testdir));
        Assertions.assertEquals((Object)true, (Object)this.fs.exists(parent), (String)("Destination exists" + parent));
    }

    @Test
    public void testRenameFileToSelf() throws Throwable {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path filepath = this.path("testRenameFileToSelf");
        this.createFile(filepath);
        this.rename(filepath, filepath, true, true, true);
        this.assertIsFile(filepath);
    }

    @Test
    public void testMoveFileUnderParent() throws Throwable {
        Assumptions.assumeTrue((boolean)this.renameSupported());
        Path filepath = this.path("testMoveFileUnderParent");
        this.createFile(filepath);
        this.rename(filepath, filepath, true, true, true);
        this.assertIsFile(filepath);
    }

    @Test
    public void testLSRootDir() throws Throwable {
        Assumptions.assumeTrue((boolean)this.rootDirTestEnabled());
        Path dir = this.path("/");
        Path child = this.path("/FileSystemContractBaseTest");
        this.createFile(child);
        this.assertListFilesFinds(dir, child);
    }

    @Test
    public void testListStatusRootDir() throws Throwable {
        Assumptions.assumeTrue((boolean)this.rootDirTestEnabled());
        Path dir = this.path("/");
        Path child = this.path("/FileSystemContractBaseTest");
        this.createFile(child);
        this.assertListStatusFinds(dir, child);
    }

    private void assertListFilesFinds(Path dir, Path subdir) throws IOException {
        RemoteIterator iterator = this.fs.listFiles(dir, true);
        boolean found = false;
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            LocatedFileStatus next = (LocatedFileStatus)iterator.next();
            builder.append(next.toString()).append('\n');
            if (!next.getPath().equals((Object)subdir)) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found, (String)("Path " + subdir + " not found in directory " + dir + ":" + builder));
    }

    protected void assertListStatusFinds(Path dir, Path subdir) throws IOException {
        FileStatus[] stats = this.fs.listStatus(dir);
        boolean found = false;
        StringBuilder builder = new StringBuilder();
        for (FileStatus stat : stats) {
            builder.append(stat.toString()).append('\n');
            if (!stat.getPath().equals((Object)subdir)) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found, (String)("Path " + subdir + " not found in directory " + dir + ":" + builder));
    }

    private void assertIsFile(Path filename) throws IOException {
        Assertions.assertTrue((boolean)this.fs.exists(filename), (String)("Does not exist: " + filename));
        FileStatus status = this.fs.getFileStatus(filename);
        String fileInfo = filename + "  " + status;
        Assertions.assertTrue((boolean)status.isFile(), (String)("Not a file " + fileInfo));
        Assertions.assertFalse((boolean)status.isSymlink(), (String)("File claims to be a symlink " + fileInfo));
        Assertions.assertFalse((boolean)status.isDirectory(), (String)("File claims to be a directory " + fileInfo));
    }

    protected void writeAndRead(Path path, byte[] src, int len, boolean overwrite, boolean delete) throws IOException {
        Assertions.assertTrue((src.length >= len ? 1 : 0) != 0, (String)("Not enough data in source array to write " + len + " bytes"));
        this.fs.mkdirs(path.getParent());
        FSDataOutputStream out = this.fs.create(path, overwrite, this.fs.getConf().getInt("io.file.buffer.size", 4096), (short)1, (long)this.getBlockSize());
        out.write(src, 0, len);
        out.close();
        Assertions.assertTrue((boolean)this.fs.exists(path), (String)"Exists");
        Assertions.assertEquals((long)len, (long)this.fs.getFileStatus(path).getLen(), (String)"Length");
        FSDataInputStream in = this.fs.open(path);
        byte[] buf = new byte[len];
        in.readFully(0L, buf);
        in.close();
        Assertions.assertEquals((int)len, (int)buf.length);
        int errors = 0;
        int first_error_byte = -1;
        for (int i = 0; i < len; ++i) {
            if (src[i] == buf[i]) continue;
            if (errors == 0) {
                first_error_byte = i;
            }
            ++errors;
        }
        if (errors > 0) {
            String message = String.format(" %d errors in file of length %d", errors, len);
            LOG.warn(message);
            int overlap = 10;
            for (int i = Math.max(0, first_error_byte - 10); i < Math.min(first_error_byte + 10, len); ++i) {
                byte actual = buf[i];
                byte expected = src[i];
                String letter = this.toChar(actual);
                String line = String.format("[%04d] %2x %s\n", i, actual, letter);
                if (expected != actual) {
                    line = String.format("[%04d] %2x %s -expected %2x %s\n", i, actual, letter, expected, this.toChar(expected));
                }
                LOG.warn(line);
            }
            Assertions.fail((String)message);
        }
        if (delete) {
            boolean deleted = this.fs.delete(path, false);
            Assertions.assertTrue((boolean)deleted, (String)"Deleted");
            Assertions.assertFalse((boolean)this.fs.exists(path), (String)"No longer exists");
        }
    }

    protected String toChar(byte b) {
        if (b >= 32) {
            return Character.toString((char)b);
        }
        return String.format("%02x", b);
    }

    protected byte[] dataset(int len, int base, int modulo) {
        byte[] dataset = new byte[len];
        for (int i = 0; i < len; ++i) {
            dataset[i] = (byte)(base + i % modulo);
        }
        return dataset;
    }
}

