/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSTestWrapper;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.junit.jupiter.api.Assertions;

public final class FileContextTestWrapper
extends FSTestWrapper {
    private final FileContext fc;

    public FileContextTestWrapper(FileContext context) {
        this(context, null);
    }

    public FileContextTestWrapper(FileContext context, String rootDir) {
        super(rootDir);
        this.fc = context;
    }

    @Override
    public FSTestWrapper getLocalFSWrapper() throws UnsupportedFileSystemException {
        return new FileContextTestWrapper(FileContext.getLocalFSFileContext());
    }

    @Override
    public Path getDefaultWorkingDirectory() throws IOException {
        return this.getTestRootPath("/user/" + System.getProperty("user.name")).makeQualified(this.fc.getDefaultFileSystem().getUri(), this.fc.getWorkingDirectory());
    }

    @Override
    public long createFile(Path path, int numBlocks, Options.CreateOpts ... options) throws IOException {
        Options.CreateOpts.BlockSize blockSizeOpt = (Options.CreateOpts.BlockSize)Options.CreateOpts.getOpt(Options.CreateOpts.BlockSize.class, (Options.CreateOpts[])options);
        long blockSize = blockSizeOpt != null ? blockSizeOpt.getValue() : 1024L;
        FSDataOutputStream out = this.fc.create(path, EnumSet.of(CreateFlag.CREATE), options);
        byte[] data = FileContextTestWrapper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
        return data.length;
    }

    @Override
    public long createFile(Path path, int numBlocks, int blockSize) throws IOException {
        return this.createFile(path, numBlocks, new Options.CreateOpts[]{Options.CreateOpts.blockSize((long)blockSize), Options.CreateOpts.createParent()});
    }

    @Override
    public long createFile(Path path) throws IOException {
        return this.createFile(path, 2, new Options.CreateOpts[]{Options.CreateOpts.createParent()});
    }

    @Override
    public long createFile(String name) throws IOException {
        Path path = this.getTestRootPath(name);
        return this.createFile(path);
    }

    @Override
    public long createFileNonRecursive(String name) throws IOException {
        Path path = this.getTestRootPath(name);
        return this.createFileNonRecursive(path);
    }

    @Override
    public long createFileNonRecursive(Path path) throws IOException {
        return this.createFile(path, 2, new Options.CreateOpts[]{Options.CreateOpts.donotCreateParent()});
    }

    @Override
    public void appendToFile(Path path, int numBlocks, Options.CreateOpts ... options) throws IOException {
        Options.CreateOpts.BlockSize blockSizeOpt = (Options.CreateOpts.BlockSize)Options.CreateOpts.getOpt(Options.CreateOpts.BlockSize.class, (Options.CreateOpts[])options);
        long blockSize = blockSizeOpt != null ? blockSizeOpt.getValue() : 1024L;
        FSDataOutputStream out = this.fc.create(path, EnumSet.of(CreateFlag.APPEND), new Options.CreateOpts[0]);
        byte[] data = FileContextTestWrapper.getFileData(numBlocks, blockSize);
        out.write(data, 0, data.length);
        out.close();
    }

    @Override
    public boolean exists(Path p) throws IOException {
        return this.fc.util().exists(p);
    }

    @Override
    public boolean isFile(Path p) throws IOException {
        try {
            return this.fc.getFileStatus(p).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isDir(Path p) throws IOException {
        try {
            return this.fc.getFileStatus(p).isDirectory();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isSymlink(Path p) throws IOException {
        try {
            return this.fc.getFileLinkStatus(p).isSymlink();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public void writeFile(Path path, byte[] b) throws IOException {
        FSDataOutputStream out = this.fc.create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.createParent()});
        out.write(b);
        out.close();
    }

    @Override
    public byte[] readFile(Path path, int len) throws IOException {
        FSDataInputStream dis = this.fc.open(path);
        byte[] buffer = new byte[len];
        IOUtils.readFully((InputStream)dis, (byte[])buffer, (int)0, (int)len);
        dis.close();
        return buffer;
    }

    @Override
    public FileStatus containsPath(Path path, FileStatus[] dirList) throws IOException {
        for (int i = 0; i < dirList.length; ++i) {
            if (!path.equals((Object)dirList[i].getPath())) continue;
            return dirList[i];
        }
        return null;
    }

    @Override
    public FileStatus containsPath(String path, FileStatus[] dirList) throws IOException {
        return this.containsPath(new Path(path), dirList);
    }

    @Override
    public void checkFileStatus(String path, FSTestWrapper.fileType expectedType) throws IOException {
        FileStatus s = this.fc.getFileStatus(new Path(path));
        Assertions.assertNotNull((Object)s);
        if (expectedType == FSTestWrapper.fileType.isDir) {
            Assertions.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == FSTestWrapper.fileType.isFile) {
            Assertions.assertTrue((boolean)s.isFile());
        } else if (expectedType == FSTestWrapper.fileType.isSymlink) {
            Assertions.assertTrue((boolean)s.isSymlink());
        }
        Assertions.assertEquals((Object)this.fc.makeQualified(new Path(path)), (Object)s.getPath());
    }

    @Override
    public void checkFileLinkStatus(String path, FSTestWrapper.fileType expectedType) throws IOException {
        FileStatus s = this.fc.getFileLinkStatus(new Path(path));
        Assertions.assertNotNull((Object)s);
        if (expectedType == FSTestWrapper.fileType.isDir) {
            Assertions.assertTrue((boolean)s.isDirectory());
        } else if (expectedType == FSTestWrapper.fileType.isFile) {
            Assertions.assertTrue((boolean)s.isFile());
        } else if (expectedType == FSTestWrapper.fileType.isSymlink) {
            Assertions.assertTrue((boolean)s.isSymlink());
        }
        Assertions.assertEquals((Object)this.fc.makeQualified(new Path(path)), (Object)s.getPath());
    }

    @Override
    public Path makeQualified(Path path) {
        return this.fc.makeQualified(path);
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fc.mkdir(dir, permission, createParent);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.delete(f, recursive);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.getFileLinkStatus(f);
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fc.createSymlink(target, link, createParent);
    }

    @Override
    public void setWorkingDirectory(Path newWDir) throws IOException {
        this.fc.setWorkingDirectory(newWDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.fc.getWorkingDirectory();
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.getFileStatus(f);
    }

    @Override
    public FSDataOutputStream create(Path f, EnumSet<CreateFlag> createFlag, Options.CreateOpts ... opts) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        return this.fc.create(f, createFlag, opts);
    }

    @Override
    public FSDataInputStream open(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.open(f);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        return this.fc.setReplication(f, replication);
    }

    @Override
    public Path getLinkTarget(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.getLinkTarget(f);
    }

    @Override
    public void rename(Path src, Path dst, Options.Rename ... options) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, IOException {
        this.fc.rename(src, dst, options);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.getFileBlockLocations(f, start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        return this.fc.getFileChecksum(f);
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.listStatus(f);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.fc.setPermission(f, permission);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, UnsupportedFileSystemException, FileNotFoundException, IOException {
        this.fc.setOwner(f, username, groupname);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        this.fc.setTimes(f, mtime, atime);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        return this.fc.util().listStatus(f);
    }

    @Override
    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return this.fc.util().globStatus(pathPattern, filter);
    }
}

