/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.crypto.key.kms.ValueQueue;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestValueQueue {
    Logger LOG = LoggerFactory.getLogger(TestValueQueue.class);

    private void waitForRefill(ValueQueue<?> valueQueue, String queueName, int queueSize) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> {
            int size = valueQueue.getSize(queueName);
            if (size != queueSize) {
                this.LOG.info("Current ValueQueue size is " + size);
                return false;
            }
            return true;
        }, 100L, 3000L);
    }

    @Test
    @Timeout(value=30L)
    public void testInitFill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assertions.assertEquals((int)1, (int)filler.getTop().num);
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testWarmUp() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.5f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        vq.initializeQueuesForKeys(new String[]{"k1", "k2", "k3"});
        FillInfo[] fillInfos = new FillInfo[]{filler.getTop(), filler.getTop(), filler.getTop()};
        Assertions.assertEquals((int)5, (int)fillInfos[0].num);
        Assertions.assertEquals((int)5, (int)fillInfos[1].num);
        Assertions.assertEquals((int)5, (int)fillInfos[2].num);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("k1", "k2", "k3")), new HashSet<String>(Arrays.asList(fillInfos[0].key, fillInfos[1].key, fillInfos[2].key)));
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testPartialWarmUp() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.5f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        LoadingCache kq = (LoadingCache)FieldUtils.getField(ValueQueue.class, (String)"keyQueues", (boolean)true).get(vq);
        LoadingCache kqSpy = (LoadingCache)Mockito.spy((Object)kq);
        ((LoadingCache)Mockito.doThrow((Throwable[])new Throwable[]{new ExecutionException(new Exception())}).when((Object)kqSpy)).get((Object)"k2");
        FieldUtils.writeField((Object)vq, (String)"keyQueues", (Object)kqSpy, (boolean)true);
        Assertions.assertThrows(IOException.class, () -> vq.initializeQueuesForKeys(new String[]{"k1", "k2", "k3"}));
        ((LoadingCache)Mockito.verify((Object)kqSpy, (VerificationMode)Mockito.times((int)1))).get((Object)"k2");
        FillInfo[] fillInfos = new FillInfo[]{filler.getTop(), filler.getTop(), filler.getTop()};
        Assertions.assertEquals((int)5, (int)fillInfos[0].num);
        Assertions.assertEquals((int)5, (int)fillInfos[1].num);
        Assertions.assertNull((Object)fillInfos[2]);
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("k1", "k3")), new HashSet<String>(Arrays.asList(fillInfos[0].key, fillInfos[1].key)));
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testRefill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(100, 0.1f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assertions.assertEquals((int)10, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 100);
        Assertions.assertEquals((int)91, (int)filler.getTop().num);
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testNoRefill() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.5f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assertions.assertEquals((int)5, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)6, (int)filler.getTop().num);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        try {
            this.waitForRefill(vq, "k1", 10);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assertions.assertEquals(null, (Object)filler.getTop());
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testGetAtMostPolicyALL() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assertions.assertEquals((int)1, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)10, (int)filler.getTop().num);
        vq.drain("k1");
        try {
            this.waitForRefill(vq, "k1", 10);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assertions.assertNull((Object)filler.getTop());
        Assertions.assertEquals((int)10, (int)vq.getAtMost("k1", 10).size(), (String)"Failed in sync call.");
        Assertions.assertEquals((int)10, (int)filler.getTop().num, (String)"Sync call filler got wrong number.");
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)10, (int)filler.getTop().num, (String)"Failed in async call.");
        vq.drain("k1");
        Assertions.assertEquals((int)0, (int)vq.getSize("k1"), (String)"Failed to drain completely after async.");
        Assertions.assertEquals((int)19, (int)vq.getAtMost("k1", 19).size(), (String)"Failed to get all 19.");
        Assertions.assertEquals((int)19, (int)filler.getTop().num, (String)"Failed in sync call.");
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testgetAtMostPolicyATLEAST_ONE() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.3f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ATLEAST_ONE, (ValueQueue.QueueRefiller)filler);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assertions.assertEquals((int)3, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)8, (int)filler.getTop().num, (String)"Failed in async call.");
        vq.drain("k1");
        Assertions.assertEquals((int)1, (int)vq.getAtMost("k1", 10).size());
        Assertions.assertEquals((int)1, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)10, (int)filler.getTop().num, (String)"Failed in async call.");
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testgetAtMostPolicyLOW_WATERMARK() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.3f, 30000L, 1, ValueQueue.SyncGenerationPolicy.LOW_WATERMARK, (ValueQueue.QueueRefiller)filler);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assertions.assertEquals((int)3, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)8, (int)filler.getTop().num, (String)"Failed in async call.");
        vq.drain("k1");
        Assertions.assertEquals((int)3, (int)vq.getAtMost("k1", 10).size());
        Assertions.assertEquals((int)3, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)10, (int)filler.getTop().num, (String)"Failed in async call.");
        vq.shutdown();
    }

    @Test
    @Timeout(value=30L)
    public void testDrain() throws Exception {
        MockFiller filler = new MockFiller();
        ValueQueue vq = new ValueQueue(10, 0.1f, 30000L, 1, ValueQueue.SyncGenerationPolicy.ALL, (ValueQueue.QueueRefiller)filler);
        Assertions.assertEquals((Object)"test", (Object)vq.getNext("k1"));
        Assertions.assertEquals((int)1, (int)filler.getTop().num);
        this.waitForRefill(vq, "k1", 10);
        Assertions.assertEquals((int)10, (int)filler.getTop().num);
        vq.drain("k1");
        try {
            this.waitForRefill(vq, "k1", 10);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assertions.assertNull((Object)filler.getTop());
        vq.shutdown();
    }

    private static class MockFiller
    implements ValueQueue.QueueRefiller<String> {
        final LinkedBlockingQueue<FillInfo> fillCalls = new LinkedBlockingQueue();

        private MockFiller() {
        }

        public void fillQueueForKey(String keyName, Queue<String> keyQueue, int numValues) throws IOException {
            this.fillCalls.add(new FillInfo(numValues, keyName));
            for (int i = 0; i < numValues; ++i) {
                keyQueue.add("test");
            }
        }

        public FillInfo getTop() throws InterruptedException {
            return this.fillCalls.poll(500L, TimeUnit.MILLISECONDS);
        }
    }

    private static class FillInfo {
        final int num;
        final String key;

        FillInfo(int num, String key) {
            this.num = num;
            this.key = key;
        }
    }
}

