/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.FailureInjectingJavaKeyStoreProvider;
import org.apache.hadoop.crypto.key.JavaKeyStoreProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.UserProvider;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestKeyProviderFactory {
    private FileSystemTestHelper fsHelper;
    private File testRootDir;

    @BeforeEach
    public void setup() {
        this.fsHelper = new FileSystemTestHelper();
        String testRoot = this.fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
    }

    @Test
    public void testFactory() throws Exception {
        Configuration conf = new Configuration();
        String userUri = "user:///";
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        String jksUri = "jceks://file" + jksPath.toUri().toString();
        conf.set("hadoop.security.key.provider.path", "user:///," + jksUri);
        List providers = KeyProviderFactory.getProviders((Configuration)conf);
        Assertions.assertEquals((int)2, (int)providers.size());
        Assertions.assertEquals(UserProvider.class, ((KeyProvider)providers.get(0)).getClass());
        Assertions.assertEquals(JavaKeyStoreProvider.class, ((KeyProvider)providers.get(1)).getClass());
        Assertions.assertEquals((Object)"user:///", (Object)((KeyProvider)providers.get(0)).toString());
        Assertions.assertEquals((Object)jksUri, (Object)((KeyProvider)providers.get(1)).toString());
    }

    @Test
    public void testFactoryErrors() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.key.provider.path", "unknown:///");
        try {
            List providers = KeyProviderFactory.getProviders((Configuration)conf);
            Assertions.assertTrue((boolean)false, (String)"should throw!");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"No KeyProviderFactory for unknown:/// in hadoop.security.key.provider.path", (Object)e.getMessage());
        }
    }

    @Test
    public void testUriErrors() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.key.provider.path", "unkn@own:/x/y");
        try {
            List providers = KeyProviderFactory.getProviders((Configuration)conf);
            Assertions.assertTrue((boolean)false, (String)"should throw!");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Bad configuration of hadoop.security.key.provider.path at unkn@own:/x/y", (Object)e.getMessage());
        }
    }

    static void checkSpecificProvider(Configuration conf, String ourUrl) throws Exception {
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        byte[] key1 = new byte[16];
        byte[] key2 = new byte[16];
        byte[] key3 = new byte[16];
        for (int i = 0; i < key1.length; ++i) {
            key1[i] = (byte)i;
            key2[i] = (byte)(i * 2);
            key3[i] = (byte)(i * 3);
        }
        Assertions.assertEquals(null, (Object)provider.getKeyVersion("no-such-key"));
        Assertions.assertEquals(null, (Object)provider.getMetadata("key"));
        try {
            provider.createKey("key3", key3, KeyProvider.options((Configuration)conf));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        KeyProvider.Metadata meta = provider.getMetadata("key3");
        Assertions.assertEquals((Object)"AES/CTR/NoPadding", (Object)meta.getCipher());
        Assertions.assertEquals((int)128, (int)meta.getBitLength());
        Assertions.assertEquals((int)1, (int)meta.getVersions());
        Assertions.assertArrayEquals((byte[])key3, (byte[])provider.getCurrentKey("key3").getMaterial());
        Assertions.assertEquals((Object)"key3@0", (Object)provider.getCurrentKey("key3").getVersionName());
        try {
            provider.createKey("key3", key3, KeyProvider.options((Configuration)conf));
            Assertions.assertTrue((boolean)false, (String)"should throw");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Key key3 already exists in " + ourUrl), (Object)e.getMessage());
        }
        provider.deleteKey("key3");
        try {
            provider.deleteKey("key3");
            Assertions.assertTrue((boolean)false, (String)"should throw");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Key key3 does not exist in " + ourUrl), (Object)e.getMessage());
        }
        provider.createKey("key3", key3, KeyProvider.options((Configuration)conf));
        try {
            provider.createKey("key4", key3, KeyProvider.options((Configuration)conf).setBitLength(8));
            Assertions.assertTrue((boolean)false, (String)"should throw");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Wrong key length. Required 8, but got 128", (Object)e.getMessage());
        }
        provider.createKey("key4", new byte[]{1}, KeyProvider.options((Configuration)conf).setBitLength(8));
        provider.rollNewVersion("key4", new byte[]{2});
        meta = provider.getMetadata("key4");
        Assertions.assertEquals((int)2, (int)meta.getVersions());
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])provider.getCurrentKey("key4").getMaterial());
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])provider.getKeyVersion("key4@0").getMaterial());
        Assertions.assertEquals((Object)"key4@1", (Object)provider.getCurrentKey("key4").getVersionName());
        try {
            provider.rollNewVersion("key4", key1);
            Assertions.assertTrue((boolean)false, (String)"should throw");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Wrong key length. Required 8, but got 128", (Object)e.getMessage());
        }
        try {
            provider.rollNewVersion("no-such-key", key1);
            Assertions.assertTrue((boolean)false, (String)"should throw");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Key no-such-key not found", (Object)e.getMessage());
        }
        provider.flush();
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])provider.getCurrentKey("key4").getMaterial());
        Assertions.assertArrayEquals((byte[])key3, (byte[])provider.getCurrentKey("key3").getMaterial());
        Assertions.assertEquals((Object)"key3@0", (Object)provider.getCurrentKey("key3").getVersionName());
        List keys = provider.getKeys();
        Assertions.assertTrue((keys.size() == 2 ? 1 : 0) != 0, (String)"Keys should have been returned.");
        Assertions.assertTrue((boolean)keys.contains("key3"), (String)"Returned Keys should have included key3.");
        Assertions.assertTrue((boolean)keys.contains("key4"), (String)"Returned Keys should have included key4.");
        List kvl = provider.getKeyVersions("key3");
        Assertions.assertEquals((int)1, (int)kvl.size(), (String)"KeyVersions should have been returned for key3.");
        Assertions.assertEquals((Object)"key3@0", (Object)((KeyProvider.KeyVersion)kvl.get(0)).getVersionName(), (String)"KeyVersions should have included key3@0.");
        Assertions.assertArrayEquals((byte[])key3, (byte[])((KeyProvider.KeyVersion)kvl.get(0)).getMaterial());
    }

    @Test
    public void testUserProvider() throws Exception {
        Configuration conf = new Configuration();
        String ourUrl = "user:///";
        conf.set("hadoop.security.key.provider.path", "user:///");
        TestKeyProviderFactory.checkSpecificProvider(conf, "user:///");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])credentials.getSecretKey(new Text("key4@0")));
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])credentials.getSecretKey(new Text("key4@1")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJksProvider() throws Exception {
        Configuration conf = new Configuration();
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(this.testRootDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.key.provider.path", ourUrl);
        TestKeyProviderFactory.checkSpecificProvider(conf, ourUrl);
        conf.set("hadoop.security.key.provider.path", ourUrl.replace("jceks", "failjceks"));
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        FailureInjectingJavaKeyStoreProvider fProvider = (FailureInjectingJavaKeyStoreProvider)provider;
        fProvider.setWriteFail(true);
        provider.createKey("key5", new byte[]{1}, KeyProvider.options((Configuration)conf).setBitLength(8));
        Assertions.assertNotNull((Object)provider.getCurrentKey("key5"));
        try {
            provider.flush();
            Assertions.fail((String)"Should not succeed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertNull((Object)provider.getCurrentKey("key5"));
        fProvider.setWriteFail(false);
        fProvider.setBackupFail(true);
        provider.createKey("key6", new byte[]{1}, KeyProvider.options((Configuration)conf).setBitLength(8));
        Assertions.assertNotNull((Object)provider.getCurrentKey("key6"));
        try {
            provider.flush();
            Assertions.fail((String)"Should not succeed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertNull((Object)provider.getCurrentKey("key6"));
        conf.set("hadoop.security.key.provider.path", ourUrl.replace("failjceks", "jceks"));
        Path path = ProviderUtils.unnestUri((URI)new URI(ourUrl));
        FileSystem fs = path.getFileSystem(conf);
        FileStatus s = fs.getFileStatus(path);
        Assertions.assertEquals((Object)"rw-------", (Object)s.getPermission().toString());
        Assertions.assertTrue((boolean)file.isFile(), (String)(file + " should exist"));
        File oldFile = new File(file.getPath() + "_OLD");
        file.renameTo(oldFile);
        file.delete();
        file.createNewFile();
        Assertions.assertTrue((boolean)oldFile.exists());
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertTrue((!oldFile.exists() ? 1 : 0) != 0, (String)(oldFile + "should be deleted"));
        this.verifyAfterReload(file, provider);
        Assertions.assertTrue((!oldFile.exists() ? 1 : 0) != 0);
        File newFile = new File(file.getPath() + "_NEW");
        newFile.createNewFile();
        try {
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assertions.fail((String)"_NEW and current file should not exist together !!");
        }
        catch (Exception exception) {
        }
        finally {
            if (newFile.exists()) {
                newFile.delete();
            }
        }
        file.renameTo(newFile);
        file.delete();
        try {
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assertions.assertFalse((boolean)newFile.exists());
            Assertions.assertFalse((boolean)oldFile.exists());
        }
        catch (Exception e) {
            Assertions.fail((String)"JKS should load from _NEW file !!");
        }
        this.verifyAfterReload(file, provider);
        newFile.createNewFile();
        file.renameTo(oldFile);
        file.delete();
        try {
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assertions.assertFalse((boolean)newFile.exists());
            Assertions.assertFalse((boolean)oldFile.exists());
        }
        catch (Exception e) {
            Assertions.fail((String)"JKS should load from _OLD file !!");
        }
        finally {
            if (newFile.exists()) {
                newFile.delete();
            }
        }
        this.verifyAfterReload(file, provider);
        fs.setPermission(path, new FsPermission("777"));
        this.checkPermissionRetention(conf, ourUrl, path);
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        try {
            provider.createKey("UPPERCASE", KeyProvider.options((Configuration)conf));
            Assertions.fail((String)"Expected failure on creating key name with uppercase characters");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Uppercase key names", e);
        }
    }

    private void verifyAfterReload(File file, KeyProvider provider) throws IOException {
        List existingKeys = provider.getKeys();
        Assertions.assertTrue((boolean)existingKeys.contains("key4"));
        Assertions.assertTrue((boolean)existingKeys.contains("key3"));
        Assertions.assertTrue((boolean)file.exists());
    }

    public void checkPermissionRetention(Configuration conf, String ourUrl, Path path) throws Exception {
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        byte[] key = new byte[16];
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)i;
        }
        try {
            provider.createKey("key5", key, KeyProvider.options((Configuration)conf));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        provider.flush();
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assertions.assertArrayEquals((byte[])key, (byte[])provider.getCurrentKey("key5").getMaterial());
        FileSystem fs = path.getFileSystem(conf);
        FileStatus s = fs.getFileStatus(path);
        Assertions.assertEquals((Object)"rwxrwxrwx", (Object)s.getPermission().toString(), (String)"Permissions should have been retained from the preexisting keystore.");
    }

    @Test
    public void testJksProviderPasswordViaConfig() throws Exception {
        KeyProvider provider;
        Configuration conf = new Configuration();
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(this.testRootDir, "test.jks");
        file.delete();
        try {
            conf.set("hadoop.security.key.provider.path", ourUrl);
            conf.set("hadoop.security.keystore.java-keystore-provider.password-file", "javakeystoreprovider.password");
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            provider.createKey("key3", new byte[16], KeyProvider.options((Configuration)conf));
            provider.flush();
        }
        catch (Exception ex) {
            Assertions.fail((String)"could not create keystore with password file");
        }
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assertions.assertNotNull((Object)provider.getCurrentKey("key3"));
        try {
            conf.set("hadoop.security.keystore.java-keystore-provider.password-file", "bar");
            KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assertions.fail((String)"using non existing password file, it should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            conf.set("hadoop.security.keystore.java-keystore-provider.password-file", "core-site.xml");
            KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assertions.fail((String)"using different password file, it should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            conf.unset("hadoop.security.keystore.java-keystore-provider.password-file");
            KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assertions.fail((String)"No password file property, env not set, it should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetProviderViaURI() throws Exception {
        Configuration conf = new Configuration(false);
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        URI uri = new URI("jceks://file" + jksPath.toUri());
        KeyProvider kp = KeyProviderFactory.get((URI)uri, (Configuration)conf);
        Assertions.assertNotNull((Object)kp);
        Assertions.assertEquals(JavaKeyStoreProvider.class, kp.getClass());
        uri = new URI("foo://bar");
        kp = KeyProviderFactory.get((URI)uri, (Configuration)conf);
        Assertions.assertNull((Object)kp);
    }

    @Test
    public void testJksProviderWithKeytoolKeys() throws Exception {
        Configuration conf = new Configuration();
        String keystoreDirAbsolutePath = conf.getResource("hdfs7067.keystore").getPath();
        String ourUrl = "jceks://file@/" + keystoreDirAbsolutePath;
        conf.set("hadoop.security.key.provider.path", ourUrl);
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        KeyProvider.KeyVersion keyVersion = provider.getKeyVersion("testkey5@0");
        try {
            KeyProvider.KeyVersion keyVersionWrongKeyNameFormat = provider.getKeyVersion("testkey2");
            Assertions.fail((String)"should have thrown an exception");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("No version in key path", e);
        }
        try {
            KeyProvider.KeyVersion keyVersionCurrentKeyNotWrongKeyNameFormat = provider.getCurrentKey("testkey5@0");
            Assertions.fail((String)"should have thrown an exception getting testkey5@0");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("other non-Hadoop method", e);
        }
        try {
            KeyProvider.KeyVersion keyVersionCurrentKeyNotReally = provider.getCurrentKey("testkey2");
            Assertions.fail((String)"should have thrown an exception getting testkey2");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("other non-Hadoop method", e);
        }
    }
}

