/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderDelegationTokenExtension;
import org.apache.hadoop.crypto.key.UserProvider;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestKeyProviderDelegationTokenExtension {
    @Test
    public void testCreateExtension() throws Exception {
        Configuration conf = new Configuration();
        Credentials credentials = new Credentials();
        KeyProvider kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        KeyProviderDelegationTokenExtension kpDTE1 = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)kp);
        Assertions.assertNotNull((Object)kpDTE1);
        Token[] tokens = kpDTE1.addDelegationTokens("user", credentials);
        Assertions.assertNotNull((Object)tokens);
        Assertions.assertEquals((int)0, (int)tokens.length);
        MockKeyProvider mock = (MockKeyProvider)((Object)Mockito.mock(MockKeyProvider.class));
        Mockito.when((Object)mock.getConf()).thenReturn((Object)new Configuration());
        Mockito.when((Object)mock.getCanonicalServiceName()).thenReturn((Object)"cservice");
        Mockito.when((Object)mock.getDelegationToken("renewer")).thenReturn((Object)new Token(null, null, new Text("kind"), new Text("tservice")));
        KeyProviderDelegationTokenExtension kpDTE2 = KeyProviderDelegationTokenExtension.createKeyProviderDelegationTokenExtension((KeyProvider)mock);
        tokens = kpDTE2.addDelegationTokens("renewer", credentials);
        Assertions.assertNotNull((Object)tokens);
        Assertions.assertEquals((int)1, (int)tokens.length);
        Assertions.assertEquals((Object)"kind", (Object)tokens[0].getKind().toString());
        Assertions.assertEquals((Object)"tservice", (Object)tokens[0].getService().toString());
        Assertions.assertNotNull((Object)credentials.getToken(new Text("cservice")));
    }

    public static abstract class MockKeyProvider
    extends KeyProvider
    implements KeyProviderDelegationTokenExtension.DelegationTokenExtension {
        public MockKeyProvider() {
            super(new Configuration(false));
        }
    }
}

