/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.CachingKeyProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.crypto.key.UserProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=180L)
public class TestKeyProviderCryptoExtension {
    private static final String CIPHER = "AES";
    private static final String ENCRYPTION_KEY_NAME = "fooKey";
    private static Configuration conf;
    private static KeyProvider kp;
    private static KeyProviderCryptoExtension kpExt;
    private static KeyProvider.Options options;
    private static KeyProvider.KeyVersion encryptionKey;

    @BeforeAll
    public static void setup() throws Exception {
        conf = new Configuration();
        kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
        kpExt = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)kp);
        options = new KeyProvider.Options(conf);
        options.setCipher(CIPHER);
        options.setBitLength(128);
        encryptionKey = kp.createKey(ENCRYPTION_KEY_NAME, SecureRandom.getSeed(16), options);
    }

    @Test
    public void testGenerateEncryptedKey() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion ek1 = kpExt.generateEncryptedKey(encryptionKey.getName());
        Assertions.assertEquals((Object)"EEK", (Object)ek1.getEncryptedKeyVersion().getVersionName(), (String)"Version name of EEK should be EEK");
        Assertions.assertEquals((Object)ENCRYPTION_KEY_NAME, (Object)ek1.getEncryptionKeyName(), (String)"Name of EEK should be encryption key name");
        Assertions.assertNotNull((Object)ek1.getEncryptedKeyVersion().getMaterial(), (String)"Expected encrypted key material");
        Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)ek1.getEncryptedKeyVersion().getMaterial().length, (String)"Length of encryption key material and EEK material should be the same");
        KeyProvider.KeyVersion k1 = kpExt.decryptEncryptedKey(ek1);
        Assertions.assertEquals((Object)"EK", (Object)k1.getVersionName());
        Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)k1.getMaterial().length);
        KeyProvider.KeyVersion k1a = kpExt.decryptEncryptedKey(ek1);
        Assertions.assertArrayEquals((byte[])k1.getMaterial(), (byte[])k1a.getMaterial());
        KeyProviderCryptoExtension.EncryptedKeyVersion ek2 = kpExt.generateEncryptedKey(encryptionKey.getName());
        KeyProvider.KeyVersion k2 = kpExt.decryptEncryptedKey(ek2);
        if (Arrays.equals(k1.getMaterial(), k2.getMaterial())) {
            Assertions.fail((String)"Generated EEKs should have different material!");
        }
        if (Arrays.equals(ek1.getEncryptedKeyIv(), ek2.getEncryptedKeyIv())) {
            Assertions.fail((String)"Generated EEKs should have different IVs!");
        }
    }

    @Test
    public void testEncryptDecrypt() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion eek = kpExt.generateEncryptedKey(encryptionKey.getName());
        byte[] encryptedKeyIv = eek.getEncryptedKeyIv();
        byte[] encryptedKeyMaterial = eek.getEncryptedKeyVersion().getMaterial();
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(encryptionKey.getMaterial(), CIPHER), new IvParameterSpec(KeyProviderCryptoExtension.EncryptedKeyVersion.deriveIV((byte[])encryptedKeyIv)));
        byte[] manualMaterial = cipher.doFinal(encryptedKeyMaterial);
        KeyProviderCryptoExtension.EncryptedKeyVersion eek2 = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)eek.getEncryptionKeyName(), (String)eek.getEncryptionKeyVersionName(), (byte[])eek.getEncryptedKeyIv(), (byte[])eek.getEncryptedKeyVersion().getMaterial());
        KeyProvider.KeyVersion decryptedKey = kpExt.decryptEncryptedKey(eek2);
        byte[] apiMaterial = decryptedKey.getMaterial();
        Assertions.assertArrayEquals((byte[])manualMaterial, (byte[])apiMaterial, (String)"Wrong key material from decryptEncryptedKey");
    }

    @Test
    public void testReencryptEncryptedKey() throws Exception {
        KeyProviderCryptoExtension.EncryptedKeyVersion ek1 = kpExt.generateEncryptedKey(encryptionKey.getName());
        KeyProvider.KeyVersion k1 = kpExt.decryptEncryptedKey(ek1);
        Assertions.assertEquals((Object)"EK", (Object)k1.getVersionName());
        Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)k1.getMaterial().length);
        kpExt.rollNewVersion(ek1.getEncryptionKeyName());
        KeyProviderCryptoExtension.EncryptedKeyVersion ek2 = kpExt.reencryptEncryptedKey(ek1);
        Assertions.assertEquals((Object)"EEK", (Object)ek2.getEncryptedKeyVersion().getVersionName(), (String)"Version name of EEK should be EEK");
        Assertions.assertEquals((Object)ENCRYPTION_KEY_NAME, (Object)ek2.getEncryptionKeyName(), (String)"Name of EEK should be encryption key name");
        Assertions.assertNotNull((Object)ek2.getEncryptedKeyVersion().getMaterial(), (String)"Expected encrypted key material");
        Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)ek2.getEncryptedKeyVersion().getMaterial().length, (String)"Length of encryption key material and EEK material should be the same");
        if (Arrays.equals(ek2.getEncryptedKeyVersion().getMaterial(), ek1.getEncryptedKeyVersion().getMaterial())) {
            Assertions.fail((String)"Re-encrypted EEK should have different material");
        }
        KeyProvider.KeyVersion k2 = kpExt.decryptEncryptedKey(ek2);
        Assertions.assertEquals((Object)"EK", (Object)k2.getVersionName());
        Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)k2.getMaterial().length);
        KeyProviderCryptoExtension.EncryptedKeyVersion ek2a = kpExt.reencryptEncryptedKey(ek1);
        Assertions.assertEquals((Object)"EEK", (Object)ek2a.getEncryptedKeyVersion().getVersionName(), (String)"Version name of EEK should be EEK");
        Assertions.assertEquals((Object)ENCRYPTION_KEY_NAME, (Object)ek2a.getEncryptionKeyName(), (String)"Name of EEK should be encryption key name");
        Assertions.assertNotNull((Object)ek2a.getEncryptedKeyVersion().getMaterial(), (String)"Expected encrypted key material");
        Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)ek2a.getEncryptedKeyVersion().getMaterial().length, (String)"Length of encryption key material and EEK material should be the same");
        if (Arrays.equals(ek2a.getEncryptedKeyVersion().getMaterial(), ek1.getEncryptedKeyVersion().getMaterial())) {
            Assertions.fail((String)"Re-encrypted EEK should have different material");
        }
        Assertions.assertArrayEquals((byte[])ek2.getEncryptedKeyVersion().getMaterial(), (byte[])ek2a.getEncryptedKeyVersion().getMaterial());
        KeyProviderCryptoExtension.EncryptedKeyVersion ek3 = kpExt.reencryptEncryptedKey(ek2);
        Assertions.assertEquals((Object)"EEK", (Object)ek3.getEncryptedKeyVersion().getVersionName(), (String)"Version name of EEK should be EEK");
        Assertions.assertEquals((Object)ENCRYPTION_KEY_NAME, (Object)ek3.getEncryptionKeyName(), (String)"Name of EEK should be encryption key name");
        Assertions.assertNotNull((Object)ek3.getEncryptedKeyVersion().getMaterial(), (String)"Expected encrypted key material");
        Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)ek3.getEncryptedKeyVersion().getMaterial().length, (String)"Length of encryption key material and EEK material should be the same");
        if (Arrays.equals(ek3.getEncryptedKeyVersion().getMaterial(), ek1.getEncryptedKeyVersion().getMaterial())) {
            Assertions.fail((String)"Re-encrypted EEK should have different material");
        }
        Assertions.assertArrayEquals((byte[])ek2.getEncryptedKeyVersion().getMaterial(), (byte[])ek3.getEncryptedKeyVersion().getMaterial());
    }

    @Test
    public void testReencryptEncryptedKeys() throws Exception {
        ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs = new ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion>(4);
        ekvs.add(kpExt.generateEncryptedKey(encryptionKey.getName()));
        ekvs.add(kpExt.generateEncryptedKey(encryptionKey.getName()));
        kpExt.rollNewVersion(((KeyProviderCryptoExtension.EncryptedKeyVersion)ekvs.get(0)).getEncryptionKeyName());
        ekvs.add(kpExt.generateEncryptedKey(encryptionKey.getName()));
        kpExt.rollNewVersion(((KeyProviderCryptoExtension.EncryptedKeyVersion)ekvs.get(0)).getEncryptionKeyName());
        ekvs.add(kpExt.generateEncryptedKey(encryptionKey.getName()));
        ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvsOrig = new ArrayList<KeyProviderCryptoExtension.EncryptedKeyVersion>(ekvs.size());
        for (KeyProviderCryptoExtension.EncryptedKeyVersion ekv : ekvs) {
            ekvsOrig.add(new KeyProviderCryptoExtension.EncryptedKeyVersion(ekv.getEncryptionKeyName(), ekv.getEncryptionKeyVersionName(), ekv.getEncryptedKeyIv(), ekv.getEncryptedKeyVersion()));
        }
        kpExt.reencryptEncryptedKeys(ekvs);
        for (int i = 0; i < ekvs.size(); ++i) {
            KeyProviderCryptoExtension.EncryptedKeyVersion ekv;
            ekv = (KeyProviderCryptoExtension.EncryptedKeyVersion)ekvs.get(i);
            KeyProviderCryptoExtension.EncryptedKeyVersion orig = (KeyProviderCryptoExtension.EncryptedKeyVersion)ekvsOrig.get(i);
            Assertions.assertEquals((Object)"EEK", (Object)ekv.getEncryptedKeyVersion().getVersionName(), (String)"Version name should be EEK");
            Assertions.assertEquals((Object)ENCRYPTION_KEY_NAME, (Object)ekv.getEncryptionKeyName(), (String)"Encryption key name should be fooKey");
            Assertions.assertNotNull((Object)ekv.getEncryptedKeyVersion().getMaterial(), (String)"Expected encrypted key material");
            Assertions.assertEquals((int)encryptionKey.getMaterial().length, (int)ekv.getEncryptedKeyVersion().getMaterial().length, (String)"Length of encryption key material and EEK material should be the same");
            Assertions.assertFalse((boolean)Arrays.equals(ekv.getEncryptedKeyVersion().getMaterial(), encryptionKey.getMaterial()), (String)"Encrypted key material should not equal encryption key material");
            if (i < 3) {
                Assertions.assertFalse((boolean)Arrays.equals(ekv.getEncryptedKeyVersion().getMaterial(), orig.getEncryptedKeyVersion().getMaterial()), (String)"Re-encrypted EEK should have different material");
            } else {
                Assertions.assertTrue((boolean)Arrays.equals(ekv.getEncryptedKeyVersion().getMaterial(), orig.getEncryptedKeyVersion().getMaterial()), (String)"Re-encrypted EEK should have same material");
            }
            KeyProvider.KeyVersion kv = kpExt.decryptEncryptedKey(ekv);
            Assertions.assertEquals((Object)"EK", (Object)kv.getVersionName());
            KeyProvider.KeyVersion kv1 = kpExt.decryptEncryptedKey(ekv);
            Assertions.assertArrayEquals((byte[])kv.getMaterial(), (byte[])kv1.getMaterial());
            KeyProvider.KeyVersion origKv = kpExt.decryptEncryptedKey(orig);
            Assertions.assertTrue((boolean)Arrays.equals(origKv.getMaterial(), kv.getMaterial()), (String)"Returned EEK and original EEK should both decrypt to the same kv.");
        }
    }

    @Test
    public void testNonDefaultCryptoExtensionSelectionWithCachingKeyProvider() throws Exception {
        Configuration config = new Configuration();
        DummyCryptoExtensionKeyProvider localKp = new DummyCryptoExtensionKeyProvider(config);
        localKp = new CachingKeyProvider((KeyProvider)localKp, 30000L, 30000L);
        KeyProviderCryptoExtension.EncryptedKeyVersion localEkv = this.getEncryptedKeyVersion(config, localKp);
        Assertions.assertEquals((Object)"dummyFakeKey@1", (Object)localEkv.getEncryptionKeyVersionName());
    }

    @Test
    public void testDefaultCryptoExtensionSelectionWithCachingKeyProvider() throws Exception {
        Configuration config = new Configuration();
        KeyProvider localKp = new UserProvider.Factory().createProvider(new URI("user:///"), config);
        localKp = new CachingKeyProvider(localKp, 30000L, 30000L);
        KeyProviderCryptoExtension.EncryptedKeyVersion localEkv = this.getEncryptedKeyVersion(config, localKp);
        Assertions.assertEquals((Object)"fooKey@0", (Object)localEkv.getEncryptionKeyVersionName());
    }

    @Test
    public void testNonDefaultCryptoExtensionSelectionOnKeyProviderExtension() throws Exception {
        Configuration config = new Configuration();
        Object localKp = new UserProvider.Factory().createProvider(new URI("user:///"), config);
        localKp = new DummyCachingCryptoExtensionKeyProvider((KeyProvider)localKp, 30000L, 30000L);
        KeyProviderCryptoExtension.EncryptedKeyVersion localEkv = this.getEncryptedKeyVersion(config, (KeyProvider)localKp);
        Assertions.assertEquals((Object)"dummyCachingFakeKey@1", (Object)localEkv.getEncryptionKeyVersionName());
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion getEncryptedKeyVersion(Configuration config, KeyProvider localKp) throws IOException, GeneralSecurityException {
        KeyProvider.Options localOptions = new KeyProvider.Options(config);
        localOptions.setCipher(CIPHER);
        localOptions.setBitLength(128);
        KeyProvider.KeyVersion localEncryptionKey = localKp.createKey(ENCRYPTION_KEY_NAME, SecureRandom.getSeed(16), localOptions);
        KeyProviderCryptoExtension localKpExt = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)localKp);
        return localKpExt.generateEncryptedKey(localEncryptionKey.getName());
    }

    public class DummyCachingCryptoExtensionKeyProvider
    extends CachingKeyProvider
    implements KeyProviderCryptoExtension.CryptoExtension {
        private KeyProvider kp;
        private KeyProvider.KeyVersion kv;
        private KeyProviderCryptoExtension.EncryptedKeyVersion ekv;

        public DummyCachingCryptoExtensionKeyProvider(KeyProvider keyProvider, long keyTimeoutMillis, long currKeyTimeoutMillis) {
            super(keyProvider, keyTimeoutMillis, currKeyTimeoutMillis);
            conf = new Configuration();
            try {
                this.kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
                this.kv = new KeyProvider.KeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyCachingFakeKey@1", new byte[16]);
                this.ekv = new KeyProviderCryptoExtension.EncryptedKeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyCachingFakeKey@1", new byte[16], this.kv);
            }
            catch (URISyntaxException e) {
                Assertions.fail((String)e.getMessage());
            }
            catch (IOException e) {
                Assertions.fail((String)e.getMessage());
            }
        }

        public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        }

        public void drain(String keyName) {
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            return this.ekv;
        }

        public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            return this.kv;
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion reencryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion ekv) throws IOException, GeneralSecurityException {
            return ekv;
        }

        public void reencryptEncryptedKeys(List<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs) throws IOException, GeneralSecurityException {
        }
    }

    public class DummyCryptoExtensionKeyProvider
    extends KeyProvider
    implements KeyProviderCryptoExtension.CryptoExtension {
        private KeyProvider kp;
        private KeyProvider.KeyVersion kv;
        private KeyProviderCryptoExtension.EncryptedKeyVersion ekv;

        public DummyCryptoExtensionKeyProvider(Configuration conf) {
            super(conf);
            conf = new Configuration();
            try {
                this.kp = new UserProvider.Factory().createProvider(new URI("user:///"), conf);
                this.kv = new KeyProvider.KeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyFakeKey@1", new byte[16]);
                this.ekv = new KeyProviderCryptoExtension.EncryptedKeyVersion(TestKeyProviderCryptoExtension.ENCRYPTION_KEY_NAME, "dummyFakeKey@1", new byte[16], this.kv);
            }
            catch (URISyntaxException e) {
                Assertions.fail((String)e.getMessage());
            }
            catch (IOException e) {
                Assertions.fail((String)e.getMessage());
            }
        }

        public void warmUpEncryptedKeys(String ... keyNames) throws IOException {
        }

        public void drain(String keyName) {
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion generateEncryptedKey(String encryptionKeyName) throws IOException, GeneralSecurityException {
            return this.ekv;
        }

        public KeyProviderCryptoExtension.EncryptedKeyVersion reencryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion ekv) throws IOException, GeneralSecurityException {
            return ekv;
        }

        public void reencryptEncryptedKeys(List<KeyProviderCryptoExtension.EncryptedKeyVersion> ekvs) throws IOException, GeneralSecurityException {
        }

        public KeyProvider.KeyVersion decryptEncryptedKey(KeyProviderCryptoExtension.EncryptedKeyVersion encryptedKeyVersion) throws IOException, GeneralSecurityException {
            return this.kv;
        }

        public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
            return this.kp.getKeyVersion(versionName);
        }

        public List<String> getKeys() throws IOException {
            return this.kp.getKeys();
        }

        public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
            return this.kp.getKeyVersions(name);
        }

        public KeyProvider.Metadata getMetadata(String name) throws IOException {
            return this.kp.getMetadata(name);
        }

        public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options localOptions) throws IOException {
            return this.kp.createKey(name, material, localOptions);
        }

        public void deleteKey(String name) throws IOException {
            this.kp.deleteKey(name);
        }

        public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
            return this.kp.rollNewVersion(name, material);
        }

        public void flush() throws IOException {
            this.kp.flush();
        }
    }
}

