/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestKeyProvider {
    private static final String CIPHER = "AES";

    @Test
    public void testBuildVersionName() throws Exception {
        Assertions.assertEquals((Object)"/a/b@3", (Object)KeyProvider.buildVersionName((String)"/a/b", (int)3));
        Assertions.assertEquals((Object)"/aaa@12", (Object)KeyProvider.buildVersionName((String)"/aaa", (int)12));
    }

    @Test
    public void testParseVersionName() throws Exception {
        Assertions.assertEquals((Object)"/a/b", (Object)KeyProvider.getBaseName((String)"/a/b@3"));
        Assertions.assertEquals((Object)"/aaa", (Object)KeyProvider.getBaseName((String)"/aaa@112"));
        try {
            KeyProvider.getBaseName((String)"no-slashes");
            Assertions.assertTrue((boolean)false, (String)"should have thrown");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)true);
        }
        LambdaTestUtils.intercept(NullPointerException.class, () -> KeyProvider.getBaseName(null));
    }

    @Test
    public void testKeyMaterial() throws Exception {
        byte[] key1 = new byte[]{1, 2, 3, 4};
        KeyProvider.KeyVersion obj = new KeyProvider.KeyVersion("key1", "key1@1", key1);
        Assertions.assertEquals((Object)"key1@1", (Object)obj.getVersionName());
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])obj.getMaterial());
    }

    @Test
    public void testMetadata() throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("y/m/d");
        Date date = format.parse("2013/12/25");
        KeyProvider.Metadata meta = new KeyProvider.Metadata("myCipher", 100, null, null, date, 123);
        Assertions.assertEquals((Object)"myCipher", (Object)meta.getCipher());
        Assertions.assertEquals((int)100, (int)meta.getBitLength());
        Assertions.assertNull((Object)meta.getDescription());
        Assertions.assertEquals((Object)date, (Object)meta.getCreated());
        Assertions.assertEquals((int)123, (int)meta.getVersions());
        KeyProvider.Metadata second = new KeyProvider.Metadata(meta.serialize());
        Assertions.assertEquals((Object)meta.getCipher(), (Object)second.getCipher());
        Assertions.assertEquals((int)meta.getBitLength(), (int)second.getBitLength());
        Assertions.assertNull((Object)second.getDescription());
        Assertions.assertTrue((boolean)second.getAttributes().isEmpty());
        Assertions.assertEquals((Object)meta.getCreated(), (Object)second.getCreated());
        Assertions.assertEquals((int)meta.getVersions(), (int)second.getVersions());
        int newVersion = second.addVersion();
        Assertions.assertEquals((int)123, (int)newVersion);
        Assertions.assertEquals((int)124, (int)second.getVersions());
        Assertions.assertEquals((int)123, (int)meta.getVersions());
        format = new SimpleDateFormat("y/m/d");
        date = format.parse("2013/12/25");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("a", "A");
        meta = new KeyProvider.Metadata("myCipher", 100, "description", attributes, date, 123);
        Assertions.assertEquals((Object)"myCipher", (Object)meta.getCipher());
        Assertions.assertEquals((int)100, (int)meta.getBitLength());
        Assertions.assertEquals((Object)"description", (Object)meta.getDescription());
        Assertions.assertEquals(attributes, (Object)meta.getAttributes());
        Assertions.assertEquals((Object)date, (Object)meta.getCreated());
        Assertions.assertEquals((int)123, (int)meta.getVersions());
        second = new KeyProvider.Metadata(meta.serialize());
        Assertions.assertEquals((Object)meta.getCipher(), (Object)second.getCipher());
        Assertions.assertEquals((int)meta.getBitLength(), (int)second.getBitLength());
        Assertions.assertEquals((Object)meta.getDescription(), (Object)second.getDescription());
        Assertions.assertEquals((Object)meta.getAttributes(), (Object)second.getAttributes());
        Assertions.assertEquals((Object)meta.getCreated(), (Object)second.getCreated());
        Assertions.assertEquals((int)meta.getVersions(), (int)second.getVersions());
        newVersion = second.addVersion();
        Assertions.assertEquals((int)123, (int)newVersion);
        Assertions.assertEquals((int)124, (int)second.getVersions());
        Assertions.assertEquals((int)123, (int)meta.getVersions());
    }

    @Test
    public void testOptions() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.key.default.cipher", "myCipher");
        conf.setInt("hadoop.security.key.default.bitlength", 512);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("a", "A");
        KeyProvider.Options options = KeyProvider.options((Configuration)conf);
        Assertions.assertEquals((Object)"myCipher", (Object)options.getCipher());
        Assertions.assertEquals((int)512, (int)options.getBitLength());
        options.setCipher("yourCipher");
        options.setDescription("description");
        options.setAttributes(attributes);
        options.setBitLength(128);
        Assertions.assertEquals((Object)"yourCipher", (Object)options.getCipher());
        Assertions.assertEquals((int)128, (int)options.getBitLength());
        Assertions.assertEquals((Object)"description", (Object)options.getDescription());
        Assertions.assertEquals(attributes, (Object)options.getAttributes());
        options = KeyProvider.options((Configuration)new Configuration());
        Assertions.assertEquals((Object)"AES/CTR/NoPadding", (Object)options.getCipher());
        Assertions.assertEquals((int)128, (int)options.getBitLength());
    }

    @Test
    public void testUnnestUri() throws Exception {
        this.assertUnwraps("hdfs://nn.example.com/my/path", "myscheme://hdfs@nn.example.com/my/path");
        this.assertUnwraps("hdfs://nn/my/path?foo=bar&baz=bat#yyy", "myscheme://hdfs@nn/my/path?foo=bar&baz=bat#yyy");
        this.assertUnwraps("inner://hdfs@nn1.example.com/my/path", "outer://inner@hdfs@nn1.example.com/my/path");
        this.assertUnwraps("user:///", "outer://user/");
        this.assertUnwraps("wasb://account@container/secret.jceks", "jceks://wasb@account@container/secret.jceks");
        this.assertUnwraps("abfs://account@container/secret.jceks", "jceks://abfs@account@container/secret.jceks");
        this.assertUnwraps("s3a://container/secret.jceks", "jceks://s3a@container/secret.jceks");
        this.assertUnwraps("file:///tmp/secret.jceks", "jceks://file/tmp/secret.jceks");
        this.assertUnwraps("https://user:pass@service/secret.jceks?token=aia", "jceks://https@user:pass@service/secret.jceks?token=aia");
    }

    protected void assertUnwraps(String unwrapped, String outer) throws URISyntaxException {
        Assertions.assertEquals((Object)new Path(unwrapped), (Object)ProviderUtils.unnestUri((URI)new URI(outer)));
    }

    @Test
    public void testMaterialGeneration() throws Exception {
        MyKeyProvider kp = new MyKeyProvider(new Configuration());
        KeyProvider.Options options = new KeyProvider.Options(new Configuration());
        options.setCipher(CIPHER);
        options.setBitLength(128);
        kp.createKey("hello", options);
        Assertions.assertEquals((int)128, (int)kp.size);
        Assertions.assertEquals((Object)CIPHER, (Object)kp.algorithm);
        Assertions.assertNotNull((Object)kp.material);
        kp = new MyKeyProvider(new Configuration());
        kp.rollNewVersion("hello");
        Assertions.assertEquals((int)128, (int)kp.size);
        Assertions.assertEquals((Object)CIPHER, (Object)kp.algorithm);
        Assertions.assertNotNull((Object)kp.material);
    }

    @Test
    public void testRolloverUnknownKey() throws Exception {
        MyKeyProvider kp = new MyKeyProvider(new Configuration());
        KeyProvider.Options options = new KeyProvider.Options(new Configuration());
        options.setCipher(CIPHER);
        options.setBitLength(128);
        kp.createKey("hello", options);
        Assertions.assertEquals((int)128, (int)kp.size);
        Assertions.assertEquals((Object)CIPHER, (Object)kp.algorithm);
        Assertions.assertNotNull((Object)kp.material);
        kp = new MyKeyProvider(new Configuration());
        try {
            kp.rollNewVersion("unknown");
            Assertions.fail((String)"should have thrown");
        }
        catch (IOException e) {
            String expectedError = "Can't find Metadata for key";
            GenericTestUtils.assertExceptionContains(expectedError, e);
        }
    }

    @Test
    public void testConfiguration() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        MyKeyProvider kp = new MyKeyProvider(conf);
        Assertions.assertEquals((Object)"A", (Object)kp.getConf().get("a"));
    }

    private static class MyKeyProvider
    extends KeyProvider {
        private String algorithm;
        private int size;
        private byte[] material;

        public MyKeyProvider(Configuration conf) {
            super(conf);
        }

        public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
            return null;
        }

        public List<String> getKeys() throws IOException {
            return null;
        }

        public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
            return null;
        }

        public KeyProvider.Metadata getMetadata(String name) throws IOException {
            if (!"unknown".equals(name)) {
                return new KeyProvider.Metadata(TestKeyProvider.CIPHER, 128, "description", null, new Date(), 0);
            }
            return null;
        }

        public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
            this.material = material;
            return null;
        }

        public void deleteKey(String name) throws IOException {
        }

        public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
            this.material = material;
            return null;
        }

        public void flush() throws IOException {
        }

        protected byte[] generateKey(int size, String algorithm) throws NoSuchAlgorithmException {
            this.size = size;
            this.algorithm = algorithm;
            return super.generateKey(size, algorithm);
        }
    }
}

