/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.OpensslCipher;
import org.apache.hadoop.crypto.OpensslSm4CtrCryptoCodec;
import org.apache.hadoop.crypto.TestCryptoStreams;
import org.apache.hadoop.crypto.random.OsSecureRandom;
import org.apache.hadoop.fs.CommonConfigurationKeysPublic;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestCryptoStreamsWithOpensslSm4CtrCryptoCodec
extends TestCryptoStreams {
    @BeforeAll
    public static void init() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Assumptions.assumeTrue((boolean)OpensslCipher.isSupported((CipherSuite)CipherSuite.SM4_CTR_NOPADDING));
        Configuration conf = new Configuration();
        conf.set("hadoop.security.crypto.cipher.suite", "SM4/CTR/NoPadding");
        conf.set(CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_SM4_CTR_NOPADDING_KEY, OpensslSm4CtrCryptoCodec.class.getName());
        codec = CryptoCodec.getInstance((Configuration)conf);
        Assertions.assertNotNull((Object)codec, (String)("Unable to instantiate codec " + OpensslSm4CtrCryptoCodec.class.getName() + ", is the required version of OpenSSL installed?"));
        Assertions.assertEquals((Object)OpensslSm4CtrCryptoCodec.class.getCanonicalName(), (Object)codec.getClass().getCanonicalName());
    }

    @Test
    public void testCodecClosesRandom() throws Exception {
        GenericTestUtils.assumeInNativeProfile();
        Configuration conf = new Configuration();
        conf.set("hadoop.security.crypto.cipher.suite", "SM4/CTR/NoPadding");
        conf.set(CommonConfigurationKeysPublic.HADOOP_SECURITY_CRYPTO_CODEC_CLASSES_SM4_CTR_NOPADDING_KEY, OpensslSm4CtrCryptoCodec.class.getName());
        conf.set("hadoop.security.secure.random.impl", OsSecureRandom.class.getName());
        CryptoCodec codecWithRandom = CryptoCodec.getInstance((Configuration)conf);
        Assertions.assertNotNull((Object)codecWithRandom, (String)("Unable to instantiate codec " + OpensslSm4CtrCryptoCodec.class.getName() + ", is the required version of OpenSSL installed?"));
        OsSecureRandom random = (OsSecureRandom)((OpensslSm4CtrCryptoCodec)codecWithRandom).getRandom();
        random.nextBytes(new byte[10]);
        Assertions.assertFalse((boolean)random.isClosed());
        codecWithRandom.close();
        Assertions.assertTrue((boolean)random.isClosed());
    }
}

