/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.CryptoStreamsTestBase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestCryptoStreamsForLocalFS
extends CryptoStreamsTestBase {
    private static final String TEST_ROOT_DIR = GenericTestUtils.getTempPath("work-dir/testcryptostreamsforlocalfs");
    private final File base = new File(TEST_ROOT_DIR);
    private final Path file = new Path(TEST_ROOT_DIR, "test-file");
    private static LocalFileSystem fileSys;

    @BeforeAll
    public static void init() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        fileSys = FileSystem.getLocal((Configuration)conf);
        codec = CryptoCodec.getInstance((Configuration)conf);
    }

    @AfterAll
    public static void shutdown() throws Exception {
    }

    @Override
    @BeforeEach
    public void setUp() throws IOException {
        fileSys.delete(new Path(TEST_ROOT_DIR), true);
        super.setUp();
    }

    @AfterEach
    public void cleanUp() throws IOException {
        FileUtil.setWritable((File)this.base, (boolean)true);
        FileUtil.fullyDelete((File)this.base);
        Assertions.assertTrue((!this.base.exists() ? 1 : 0) != 0);
    }

    @Override
    protected OutputStream getOutputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        return new CryptoOutputStream((OutputStream)fileSys.create(this.file), codec, bufferSize, key, iv);
    }

    @Override
    protected InputStream getInputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        return new CryptoInputStream((InputStream)fileSys.open(this.file), codec, bufferSize, key, iv);
    }

    @Override
    @Disabled(value="ChecksumFSInputChecker doesn't support ByteBuffer read")
    @Test
    @Timeout(value=10L)
    public void testByteBufferRead() throws Exception {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferPositionedReadable")
    @Test
    @Timeout(value=10L)
    public void testPositionedReadWithByteBuffer() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferPositionedReadable")
    @Test
    @Timeout(value=10L)
    public void testByteBufferReadFully() throws Exception {
    }

    @Override
    @Disabled(value="ChecksumFSOutputSummer doesn't support Syncable")
    @Test
    @Timeout(value=10L)
    public void testSyncable() throws IOException {
    }

    @Override
    @Disabled(value="Wrapped stream doesn't support ByteBufferPositionedReadable")
    @Test
    @Timeout(value=10L)
    public void testByteBufferPread() throws IOException {
    }

    @Override
    @Disabled(value="ChecksumFSInputChecker doesn't support ByteBuffer read")
    @Test
    @Timeout(value=10L)
    public void testCombinedOp() throws Exception {
    }

    @Override
    @Disabled(value="ChecksumFSInputChecker doesn't support enhanced ByteBuffer access")
    @Test
    @Timeout(value=10L)
    public void testHasEnhancedByteBufferAccess() throws Exception {
    }

    @Override
    @Disabled(value="ChecksumFSInputChecker doesn't support seekToNewSource")
    @Test
    @Timeout(value=10L)
    public void testSeekToNewSource() throws Exception {
    }

    @Override
    @Disabled(value="Local file input stream does not support unbuffer")
    @Test
    public void testUnbuffer() throws Exception {
    }
}

