/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurableBase;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Time;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestReconfiguration {
    private Configuration conf1;
    private Configuration conf2;
    private static final String PROP1 = "test.prop.one";
    private static final String PROP2 = "test.prop.two";
    private static final String PROP3 = "test.prop.three";
    private static final String PROP4 = "test.prop.four";
    private static final String PROP5 = "test.prop.five";
    private static final String VAL1 = "val1";
    private static final String VAL2 = "val2";

    @BeforeEach
    public void setUp() {
        this.conf1 = new Configuration();
        this.conf2 = new Configuration();
        this.conf1.set(PROP1, VAL1);
        this.conf1.set(PROP2, VAL1);
        this.conf1.set(PROP3, VAL1);
        this.conf2.set(PROP1, VAL1);
        this.conf2.set(PROP2, VAL2);
        this.conf2.set(PROP4, VAL1);
    }

    @Test
    public void testGetChangedProperties() {
        Collection changes = ReconfigurationUtil.getChangedProperties((Configuration)this.conf2, (Configuration)this.conf1);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)changes.size(), (String)("expected 3 changed properties but got " + changes.size()));
        boolean changeFound = false;
        boolean unsetFound = false;
        boolean setFound = false;
        for (ReconfigurationUtil.PropertyChange c : changes) {
            if (c.prop.equals(PROP2) && c.oldVal != null && c.oldVal.equals(VAL1) && c.newVal != null && c.newVal.equals(VAL2)) {
                changeFound = true;
                continue;
            }
            if (c.prop.equals(PROP3) && c.oldVal != null && c.oldVal.equals(VAL1) && c.newVal == null) {
                unsetFound = true;
                continue;
            }
            if (!c.prop.equals(PROP4) || c.oldVal != null || c.newVal == null || !c.newVal.equals(VAL1)) continue;
            setFound = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((changeFound && unsetFound && setFound ? 1 : 0) != 0, (String)"not all changes have been applied");
    }

    @Test
    public void testReconfigure() {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)VAL1, (Object)dummy.getConf().get(PROP1), (String)"test.prop.one set to wrong value ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)VAL1, (Object)dummy.getConf().get(PROP2), (String)"test.prop.two set to wrong value ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)VAL1, (Object)dummy.getConf().get(PROP3), (String)"test.prop.three set to wrong value ");
        org.junit.jupiter.api.Assertions.assertNull((Object)dummy.getConf().get(PROP4), (String)"test.prop.four set to wrong value ");
        org.junit.jupiter.api.Assertions.assertNull((Object)dummy.getConf().get(PROP5), (String)"test.prop.five set to wrong value ");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dummy.isPropertyReconfigurable(PROP1), (String)"test.prop.one should be reconfigurable ");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dummy.isPropertyReconfigurable(PROP2), (String)"test.prop.two should be reconfigurable ");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dummy.isPropertyReconfigurable(PROP3), (String)"test.prop.three should not be reconfigurable ");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dummy.isPropertyReconfigurable(PROP4), (String)"test.prop.four should be reconfigurable ");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dummy.isPropertyReconfigurable(PROP5), (String)"test.prop.five should not be reconfigurable ");
        boolean exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL1);
            org.junit.jupiter.api.Assertions.assertEquals((Object)VAL1, (Object)dummy.getConf().get(PROP1), (String)"test.prop.one set to wrong value ");
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)exceptionCaught, (String)"received unexpected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, null);
            org.junit.jupiter.api.Assertions.assertNull((Object)dummy.getConf().get(PROP1), (String)"test.prop.oneset to wrong value ");
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)exceptionCaught, (String)"received unexpected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL2);
            org.junit.jupiter.api.Assertions.assertEquals((Object)VAL2, (Object)dummy.getConf().get(PROP1), (String)"test.prop.oneset to wrong value ");
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)exceptionCaught, (String)"received unexpected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, null);
            org.junit.jupiter.api.Assertions.assertNull((Object)dummy.getConf().get(PROP4), (String)"test.prop.fourset to wrong value ");
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)exceptionCaught, (String)"received unexpected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, VAL1);
            org.junit.jupiter.api.Assertions.assertEquals((Object)VAL1, (Object)dummy.getConf().get(PROP4), (String)"test.prop.fourset to wrong value ");
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)exceptionCaught, (String)"received unexpected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, null);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionCaught, (String)"did not receive expected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, VAL1);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionCaught, (String)"did not receive expected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, VAL2);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionCaught, (String)"did not receive expected exception");
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, null);
        }
        catch (ReconfigurationException e) {
            exceptionCaught = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionCaught, (String)"did not receive expected exception");
    }

    @Test
    public void testThread() throws ReconfigurationException {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dummy.getConf().get(PROP1).equals(VAL1));
        Thread dummyThread = new Thread(dummy);
        dummyThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        dummy.reconfigureProperty(PROP1, VAL2);
        long endWait = Time.now() + 2000L;
        while (dummyThread.isAlive() && Time.now() < endWait) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dummyThread.isAlive(), (String)"dummy thread should not be alive");
        dummy.running = false;
        try {
            dummyThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dummy.getConf().get(PROP1).equals(VAL2), (String)"test.prop.one is set to wrong value");
    }

    private static void waitAsyncReconfigureTaskFinish(ReconfigurableBase rb) throws InterruptedException {
        ReconfigurationTaskStatus status = null;
        for (int count = 20; count > 0 && !(status = rb.getReconfigurationTaskStatus()).stopped(); --count) {
            Thread.sleep(500L);
        }
        assert (status.stopped());
    }

    @Test
    public void testAsyncReconfigure() throws ReconfigurationException, IOException, InterruptedException {
        AsyncReconfigurableDummy dummy = (AsyncReconfigurableDummy)((Object)Mockito.spy((Object)((Object)new AsyncReconfigurableDummy(this.conf1))));
        ArrayList changes = Lists.newArrayList();
        changes.add(new ReconfigurationUtil.PropertyChange("name1", "new1", "old1"));
        changes.add(new ReconfigurationUtil.PropertyChange("name2", "new2", "old2"));
        changes.add(new ReconfigurationUtil.PropertyChange("name3", "new3", "old3"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)changes).when((Object)dummy))).getChangedProperties((Configuration)ArgumentMatchers.any(Configuration.class), (Configuration)ArgumentMatchers.any(Configuration.class));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)true).when((Object)dummy))).isPropertyReconfigurable((String)ArgumentMatchers.eq((Object)"name1"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)false).when((Object)dummy))).isPropertyReconfigurable((String)ArgumentMatchers.eq((Object)"name2"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)true).when((Object)dummy))).isPropertyReconfigurable((String)ArgumentMatchers.eq((Object)"name3"));
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)"dummy").when((Object)dummy))).reconfigurePropertyImpl((String)ArgumentMatchers.eq((Object)"name1"), ArgumentMatchers.anyString());
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)"dummy").when((Object)dummy))).reconfigurePropertyImpl((String)ArgumentMatchers.eq((Object)"name2"), ArgumentMatchers.anyString());
        ((AsyncReconfigurableDummy)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new ReconfigurationException("NAME3", "NEW3", "OLD3", (Throwable)new IOException("io exception"))}).when((Object)dummy))).reconfigurePropertyImpl((String)ArgumentMatchers.eq((Object)"name3"), ArgumentMatchers.anyString());
        dummy.startReconfigurationTask();
        TestReconfiguration.waitAsyncReconfigureTaskFinish(dummy);
        ReconfigurationTaskStatus status = dummy.getReconfigurationTaskStatus();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)status.getStatus().size());
        for (Map.Entry result : status.getStatus().entrySet()) {
            ReconfigurationUtil.PropertyChange change = (ReconfigurationUtil.PropertyChange)result.getKey();
            if (change.prop.equals("name1")) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)((Optional)result.getValue()).isPresent());
                continue;
            }
            if (change.prop.equals("name2")) {
                Assertions.assertThat((String)((String)((Optional)result.getValue()).get())).contains(new CharSequence[]{"Property name2 is not reconfigurable"});
                continue;
            }
            if (change.prop.equals("name3")) {
                Assertions.assertThat((String)((String)((Optional)result.getValue()).get())).contains(new CharSequence[]{"io exception"});
                continue;
            }
            org.junit.jupiter.api.Assertions.fail((String)("Unknown property: " + change.prop));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testStartReconfigurationFailureDueToExistingRunningTask() throws InterruptedException, IOException {
        AsyncReconfigurableDummy dummy = (AsyncReconfigurableDummy)((Object)Mockito.spy((Object)((Object)new AsyncReconfigurableDummy(this.conf1))));
        ArrayList changes = Lists.newArrayList((Object[])new ReconfigurationUtil.PropertyChange[]{new ReconfigurationUtil.PropertyChange(PROP1, "new1", "old1")});
        ((AsyncReconfigurableDummy)((Object)Mockito.doReturn((Object)changes).when((Object)dummy))).getChangedProperties((Configuration)ArgumentMatchers.any(Configuration.class), (Configuration)ArgumentMatchers.any(Configuration.class));
        ReconfigurationTaskStatus status = dummy.getReconfigurationTaskStatus();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)status.hasTask());
        dummy.startReconfigurationTask();
        status = dummy.getReconfigurationTaskStatus();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)status.hasTask());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)status.stopped());
        try {
            dummy.startReconfigurationTask();
            org.junit.jupiter.api.Assertions.fail((String)"Expect to throw IOException.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Another reconfiguration task is running", e);
        }
        status = dummy.getReconfigurationTaskStatus();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)status.hasTask());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)status.stopped());
        dummy.latch.countDown();
        TestReconfiguration.waitAsyncReconfigureTaskFinish(dummy);
        status = dummy.getReconfigurationTaskStatus();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)status.hasTask());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)status.stopped());
        dummy.startReconfigurationTask();
        TestReconfiguration.waitAsyncReconfigureTaskFinish(dummy);
        ReconfigurationTaskStatus status2 = dummy.getReconfigurationTaskStatus();
        org.junit.jupiter.api.Assertions.assertTrue((status2.getStartTime() >= status.getEndTime() ? 1 : 0) != 0);
        dummy.shutdownReconfigurationTask();
        try {
            dummy.startReconfigurationTask();
            org.junit.jupiter.api.Assertions.fail((String)"Expect to throw IOException");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("The server is stopped", e);
        }
    }

    @Test
    @Timeout(value=300L)
    public void testConfIsUpdatedOnSuccess() throws ReconfigurationException {
        String property = "FOO";
        String value1 = "value1";
        String value2 = "value2";
        Configuration conf = new Configuration();
        conf.set("FOO", "value1");
        Configuration newConf = new Configuration();
        newConf.set("FOO", "value2");
        ReconfigurableBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.reconfigureProperty("FOO", "value2");
        Assertions.assertThat((String)reconfigurable.getConf().get("FOO")).isEqualTo((Object)"value2");
    }

    @Test
    @Timeout(value=300L)
    public void testConfIsUpdatedOnSuccessAsync() throws ReconfigurationException, TimeoutException, InterruptedException, IOException {
        String property = "FOO";
        String value1 = "value1";
        String value2 = "value2";
        Configuration conf = new Configuration();
        conf.set("FOO", "value1");
        Configuration newConf = new Configuration();
        newConf.set("FOO", "value2");
        final ReconfigurableBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.startReconfigurationTask();
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return reconfigurable.getReconfigurationTaskStatus().stopped();
            }
        }, 100L, 60000L);
        Assertions.assertThat((String)reconfigurable.getConf().get("FOO")).isEqualTo((Object)"value2");
    }

    @Test
    @Timeout(value=300L)
    public void testConfIsUnset() throws ReconfigurationException {
        String property = "FOO";
        String value1 = "value1";
        Configuration conf = new Configuration();
        conf.set("FOO", "value1");
        Configuration newConf = new Configuration();
        ReconfigurableBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.reconfigureProperty("FOO", null);
        org.junit.jupiter.api.Assertions.assertNull((Object)reconfigurable.getConf().get("FOO"));
    }

    @Test
    @Timeout(value=300L)
    public void testConfIsUnsetAsync() throws ReconfigurationException, IOException, TimeoutException, InterruptedException {
        String property = "FOO";
        String value1 = "value1";
        Configuration conf = new Configuration();
        conf.set("FOO", "value1");
        Configuration newConf = new Configuration();
        final ReconfigurableBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.startReconfigurationTask();
        GenericTestUtils.waitFor(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return reconfigurable.getReconfigurationTaskStatus().stopped();
            }
        }, 100L, 60000L);
        org.junit.jupiter.api.Assertions.assertNull((Object)reconfigurable.getConf().get("FOO"));
    }

    private ReconfigurableBase makeReconfigurable(Configuration oldConf, final Configuration newConf, final Collection<String> reconfigurableProperties) {
        return new ReconfigurableBase(oldConf){

            protected Configuration getNewConf() {
                return newConf;
            }

            public Collection<String> getReconfigurableProperties() {
                return reconfigurableProperties;
            }

            protected String reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
                return newVal;
            }
        };
    }

    private static class AsyncReconfigurableDummy
    extends ReconfigurableBase {
        final CountDownLatch latch = new CountDownLatch(1);

        AsyncReconfigurableDummy(Configuration conf) {
            super(conf);
        }

        protected Configuration getNewConf() {
            return new Configuration();
        }

        public Collection<String> getReconfigurableProperties() {
            return Arrays.asList(TestReconfiguration.PROP1, TestReconfiguration.PROP2, TestReconfiguration.PROP4);
        }

        public synchronized String reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return newVal;
        }
    }

    public static class ReconfigurableDummy
    extends ReconfigurableBase
    implements Runnable {
        public volatile boolean running = true;

        public ReconfigurableDummy(Configuration conf) {
            super(conf);
        }

        protected Configuration getNewConf() {
            return new Configuration();
        }

        public Collection<String> getReconfigurableProperties() {
            return Arrays.asList(TestReconfiguration.PROP1, TestReconfiguration.PROP2, TestReconfiguration.PROP4);
        }

        public synchronized String reconfigurePropertyImpl(String property, String newVal) throws ReconfigurationException {
            return newVal;
        }

        @Override
        public void run() {
            while (this.running && this.getConf().get(TestReconfiguration.PROP1).equals(TestReconfiguration.VAL1)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

