/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Common", "HDFS", "MapReduce", "Yarn"})
@InterfaceStability.Unstable
public final class CrcUtil {
    public static final int MULTIPLICATIVE_IDENTITY = Integer.MIN_VALUE;
    public static final int GZIP_POLYNOMIAL = -306674912;
    public static final int CASTAGNOLI_POLYNOMIAL = -2097792136;

    private CrcUtil() {
    }

    public static int getMonomial(long lengthBytes, int mod) {
        if (lengthBytes == 0L) {
            return Integer.MIN_VALUE;
        }
        if (lengthBytes < 0L) {
            throw new IllegalArgumentException("lengthBytes must be positive, got " + lengthBytes);
        }
        int multiplier = 0x800000;
        int product = Integer.MIN_VALUE;
        for (long degree = lengthBytes; degree > 0L; degree >>= 1) {
            if ((degree & 1L) != 0L) {
                product = product == Integer.MIN_VALUE ? multiplier : CrcUtil.galoisFieldMultiply(product, multiplier, mod);
            }
            multiplier = CrcUtil.galoisFieldMultiply(multiplier, multiplier, mod);
        }
        return product;
    }

    public static int composeWithMonomial(int crcA, int crcB, int monomial, int mod) {
        return CrcUtil.galoisFieldMultiply(crcA, monomial, mod) ^ crcB;
    }

    public static int compose(int crcA, int crcB, long lengthB, int mod) {
        int monomial = CrcUtil.getMonomial(lengthB, mod);
        return CrcUtil.composeWithMonomial(crcA, crcB, monomial, mod);
    }

    public static byte[] intToBytes(int value) {
        byte[] buf = new byte[4];
        CrcUtil.writeInt(buf, 0, value);
        return buf;
    }

    public static void writeInt(byte[] buf, int offset, int value) {
        if (offset + 4 > buf.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("writeInt out of bounds: buf.length=%d, offset=%d", buf.length, offset));
        }
        buf[offset] = (byte)(value >>> 24 & 0xFF);
        buf[offset + 1] = (byte)(value >>> 16 & 0xFF);
        buf[offset + 2] = (byte)(value >>> 8 & 0xFF);
        buf[offset + 3] = (byte)(value & 0xFF);
    }

    public static int readInt(byte[] buf, int offset) {
        if (offset + 4 > buf.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("readInt out of bounds: buf.length=%d, offset=%d", buf.length, offset));
        }
        return (buf[offset] & 0xFF) << 24 | (buf[offset + 1] & 0xFF) << 16 | (buf[offset + 2] & 0xFF) << 8 | buf[offset + 3] & 0xFF;
    }

    public static String toSingleCrcString(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException(String.format("Unexpected byte[] length '%d' for single CRC. Contents: %s", bytes.length, Arrays.toString(bytes)));
        }
        return String.format("0x%08x", CrcUtil.readInt(bytes, 0));
    }

    public static String toMultiCrcString(byte[] bytes) {
        if (bytes.length % 4 != 0) {
            throw new IllegalArgumentException(String.format("Unexpected byte[] length '%d' not divisible by 4. Contents: %s", bytes.length, Arrays.toString(bytes)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < bytes.length; i += 4) {
            sb.append(String.format("0x%08x", CrcUtil.readInt(bytes, i)));
            if (i == bytes.length - 4) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private static int galoisFieldMultiply(int p, int q, int m) {
        int summation = 0;
        int px = p;
        for (int curTerm = Integer.MIN_VALUE; curTerm != 0; curTerm >>>= 1) {
            if ((q & curTerm) != 0) {
                summation ^= px;
            }
            boolean hasMaxDegree = (px & 1) != 0;
            px >>>= 1;
            if (!hasMaxDegree) continue;
            px ^= m;
        }
        return summation;
    }
}

