/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.curator;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.util.JaasConfiguration;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.util.curator.ZKCuratorManager;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestZKCuratorManager {
    private TestingServer server;
    private ZKCuratorManager curator;

    @BeforeEach
    public void setup() throws Exception {
        this.server = new TestingServer();
        Configuration conf = new Configuration();
        String zkHostPort = this.server.getConnectString();
        this.curator = new ZKCuratorManager(conf);
        this.curator.start(zkHostPort);
    }

    @AfterEach
    public void teardown() throws Exception {
        this.curator.close();
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Test
    public void testReadWriteData() throws Exception {
        String testZNode = "/test";
        String expectedString = "testString";
        Assertions.assertFalse((boolean)this.curator.exists(testZNode));
        this.curator.create(testZNode);
        Assertions.assertTrue((boolean)this.curator.exists(testZNode));
        this.curator.setData(testZNode, expectedString, -1);
        String testString = this.curator.getStringData("/test");
        Assertions.assertEquals((Object)expectedString, (Object)testString);
    }

    @Test
    public void testChildren() throws Exception {
        List children = this.curator.getChildren("/");
        Assertions.assertEquals((int)1, (int)children.size());
        Assertions.assertFalse((boolean)this.curator.exists("/node1"));
        this.curator.create("/node1");
        Assertions.assertTrue((boolean)this.curator.exists("/node1"));
        Assertions.assertFalse((boolean)this.curator.exists("/node2"));
        this.curator.create("/node2");
        Assertions.assertTrue((boolean)this.curator.exists("/node2"));
        children = this.curator.getChildren("/");
        Assertions.assertEquals((int)3, (int)children.size());
        this.curator.delete("/node2");
        Assertions.assertFalse((boolean)this.curator.exists("/node2"));
        children = this.curator.getChildren("/");
        Assertions.assertEquals((int)2, (int)children.size());
    }

    @Test
    public void testGetStringData() throws Exception {
        String node1 = "/node1";
        String node2 = "/node2";
        Assertions.assertFalse((boolean)this.curator.exists(node1));
        this.curator.create(node1);
        Assertions.assertNull((Object)this.curator.getStringData(node1));
        byte[] setData = "setData".getBytes(StandardCharsets.UTF_8);
        this.curator.setData(node1, setData, -1);
        Assertions.assertEquals((Object)"setData", (Object)this.curator.getStringData(node1));
        Stat stat = new Stat();
        Assertions.assertFalse((boolean)this.curator.exists(node2));
        this.curator.create(node2);
        Assertions.assertNull((Object)this.curator.getStringData(node2, stat));
        this.curator.setData(node2, setData, -1);
        Assertions.assertEquals((Object)"setData", (Object)this.curator.getStringData(node2, stat));
    }

    @Test
    public void testTransaction() throws Exception {
        List zkAcl = ZKUtil.parseACLs((String)"world:anyone:rwcda");
        String fencingNodePath = "/fencing";
        String node1 = "/node1";
        String node2 = "/node2";
        byte[] testData = "testData".getBytes(StandardCharsets.UTF_8);
        Assertions.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assertions.assertFalse((boolean)this.curator.exists(node1));
        Assertions.assertFalse((boolean)this.curator.exists(node2));
        ZKCuratorManager.SafeTransaction txn = this.curator.createTransaction(zkAcl, fencingNodePath);
        txn.create(node1, testData, zkAcl, CreateMode.PERSISTENT);
        txn.create(node2, testData, zkAcl, CreateMode.PERSISTENT);
        Assertions.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assertions.assertFalse((boolean)this.curator.exists(node1));
        Assertions.assertFalse((boolean)this.curator.exists(node2));
        txn.commit();
        Assertions.assertFalse((boolean)this.curator.exists(fencingNodePath));
        Assertions.assertTrue((boolean)this.curator.exists(node1));
        Assertions.assertTrue((boolean)this.curator.exists(node2));
        Assertions.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node1)));
        Assertions.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node2)));
        byte[] setData = "setData".getBytes(StandardCharsets.UTF_8);
        txn = this.curator.createTransaction(zkAcl, fencingNodePath);
        txn.setData(node1, setData, -1);
        txn.delete(node2);
        Assertions.assertTrue((boolean)this.curator.exists(node2));
        Assertions.assertTrue((boolean)Arrays.equals(testData, this.curator.getData(node1)));
        txn.commit();
        Assertions.assertFalse((boolean)this.curator.exists(node2));
        Assertions.assertTrue((boolean)Arrays.equals(setData, this.curator.getData(node1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaasConfiguration() throws Exception {
        ZKCuratorManager.HadoopZookeeperFactory factory1 = new ZKCuratorManager.HadoopZookeeperFactory("foo1", "bar1", "bar1.keytab");
        ZooKeeper zk1 = factory1.newZooKeeper("connString", 1000, null, false);
        this.validateJaasConfiguration("HadoopZookeeperClient", "bar1", "bar1.keytab", zk1);
        ZKCuratorManager.HadoopZookeeperFactory factory2 = new ZKCuratorManager.HadoopZookeeperFactory("foo2", "bar2", "bar2.keytab");
        ZooKeeper zk2 = factory2.newZooKeeper("connString", 1000, null, false);
        this.validateJaasConfiguration("HadoopZookeeperClient", "bar2", "bar2.keytab", zk2);
        try {
            String testClientConfig = "TestClientConfig";
            JaasConfiguration jconf = new JaasConfiguration(testClientConfig, "test", "test.keytab");
            javax.security.auth.login.Configuration.setConfiguration((javax.security.auth.login.Configuration)jconf);
            System.setProperty("zookeeper.sasl.clientconfig", testClientConfig);
            ZKCuratorManager.HadoopZookeeperFactory factory3 = new ZKCuratorManager.HadoopZookeeperFactory("foo3", "bar3", "bar3.keytab");
            ZooKeeper zk3 = factory3.newZooKeeper("connString", 1000, null, false);
            this.validateJaasConfiguration(testClientConfig, "test", "test.keytab", zk3);
        }
        finally {
            System.clearProperty("zookeeper.sasl.clientconfig");
        }
    }

    @Test
    public void testCuratorFrameworkFactory() throws Exception {
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        Configuration conf = new Configuration();
        conf.set("hadoop.zk.address", this.server.getConnectString());
        int numRetries = conf.getInt("hadoop.zk.num-retries", 1000);
        int zkSessionTimeout = conf.getInt("hadoop.zk.timeout-ms", 10000);
        int zkRetryInterval = conf.getInt("hadoop.zk.retry-interval-ms", 1000);
        RetryNTimes retryPolicy = new RetryNTimes(numRetries, zkRetryInterval);
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(conf.get("hadoop.zk.address")).zkClientConfig(zkClientConfig).sessionTimeoutMs(zkSessionTimeout).retryPolicy((RetryPolicy)retryPolicy).authorization(new ArrayList()).zookeeperFactory((ZookeeperFactory)new ZKCuratorManager.HadoopZookeeperFactory("foo1", "bar1", "bar1.keytab", false, new SecurityUtil.TruststoreKeystore(conf))).build();
        client.start();
        this.validateJaasConfiguration("HadoopZookeeperClient", "bar1", "bar1.keytab", client.getZookeeperClient().getZooKeeper());
    }

    private void validateJaasConfiguration(String clientConfig, String principal, String keytab, ZooKeeper zk) {
        Assertions.assertEquals((Object)clientConfig, (Object)zk.getClientConfig().getProperty("zookeeper.sasl.clientconfig"), (String)"Validate that expected clientConfig is set in ZK config");
        AppConfigurationEntry[] entries = javax.security.auth.login.Configuration.getConfiguration().getAppConfigurationEntry(clientConfig);
        Assertions.assertEquals((Object)principal, entries[0].getOptions().get("principal"), (String)"Validate that expected principal is set in Jaas config");
        Assertions.assertEquals((Object)keytab, entries[0].getOptions().get("keyTab"), (String)"Validate that expected keytab is set in Jaas config");
    }
}

