/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.io.FileWriteMode;
import org.apache.hadoop.thirdparty.com.google.common.io.Files;
import org.apache.hadoop.util.ZKUtil;
import org.apache.zookeeper.data.ACL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestZKUtil {
    private static final String TEST_ROOT_DIR = GenericTestUtils.getTempPath("TestZKUtil");
    private static final File TEST_FILE = new File(TEST_ROOT_DIR, "test-file");
    private static final String BOGUS_FILE = new File("/xxxx-this-does-not-exist").getPath();

    @Test
    public void testEmptyACL() {
        List result = ZKUtil.parseACLs((String)"");
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNullACL() {
        List result = ZKUtil.parseACLs(null);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testInvalidACLs() {
        TestZKUtil.badAcl("a:b", "ACL 'a:b' not of expected form scheme:id:perm");
        TestZKUtil.badAcl("a", "ACL 'a' not of expected form scheme:id:perm");
        TestZKUtil.badAcl("password:foo:rx", "Invalid permission 'x' in permission string 'rx'");
    }

    private static void badAcl(String acls, String expectedErr) {
        try {
            ZKUtil.parseACLs((String)acls);
            Assertions.fail((String)("Should have failed to parse '" + acls + "'"));
        }
        catch (ZKUtil.BadAclFormatException e) {
            Assertions.assertEquals((Object)expectedErr, (Object)e.getMessage());
        }
    }

    @Test
    public void testRemoveSpecificPerms() {
        int perms = 31;
        int remove = 4;
        int newPerms = ZKUtil.removeSpecificPerms((int)perms, (int)remove);
        Assertions.assertEquals((int)0, (int)(newPerms & 4), (String)"Removal failed");
    }

    @Test
    public void testGoodACLs() {
        List result = ZKUtil.parseACLs((String)"sasl:hdfs/host1@MY.DOMAIN:cdrwa, sasl:hdfs/host2@MY.DOMAIN:ca");
        ACL acl0 = (ACL)result.get(0);
        Assertions.assertEquals((int)31, (int)acl0.getPerms());
        Assertions.assertEquals((Object)"sasl", (Object)acl0.getId().getScheme());
        Assertions.assertEquals((Object)"hdfs/host1@MY.DOMAIN", (Object)acl0.getId().getId());
        ACL acl1 = (ACL)result.get(1);
        Assertions.assertEquals((int)20, (int)acl1.getPerms());
        Assertions.assertEquals((Object)"sasl", (Object)acl1.getId().getScheme());
        Assertions.assertEquals((Object)"hdfs/host2@MY.DOMAIN", (Object)acl1.getId().getId());
    }

    @Test
    public void testEmptyAuth() {
        List result = ZKUtil.parseAuth((String)"");
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNullAuth() {
        List result = ZKUtil.parseAuth(null);
        Assertions.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testGoodAuths() {
        List result = ZKUtil.parseAuth((String)"scheme:data,\n   scheme2:user:pass");
        Assertions.assertEquals((int)2, (int)result.size());
        ZKUtil.ZKAuthInfo auth0 = (ZKUtil.ZKAuthInfo)result.get(0);
        Assertions.assertEquals((Object)"scheme", (Object)auth0.getScheme());
        Assertions.assertEquals((Object)"data", (Object)new String(auth0.getAuth()));
        ZKUtil.ZKAuthInfo auth1 = (ZKUtil.ZKAuthInfo)result.get(1);
        Assertions.assertEquals((Object)"scheme2", (Object)auth1.getScheme());
        Assertions.assertEquals((Object)"user:pass", (Object)new String(auth1.getAuth()));
    }

    @Test
    public void testConfIndirection() throws IOException {
        Assertions.assertNull((Object)ZKUtil.resolveConfIndirection(null));
        Assertions.assertEquals((Object)"x", (Object)ZKUtil.resolveConfIndirection((String)"x"));
        TEST_FILE.getParentFile().mkdirs();
        Files.asCharSink((File)TEST_FILE, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"hello world");
        Assertions.assertEquals((Object)"hello world", (Object)ZKUtil.resolveConfIndirection((String)("@" + TEST_FILE.getAbsolutePath())));
        try {
            ZKUtil.resolveConfIndirection((String)("@" + BOGUS_FILE));
            Assertions.fail((String)"Did not throw for non-existent file reference");
        }
        catch (FileNotFoundException fnfe) {
            Assertions.assertTrue((boolean)fnfe.getMessage().startsWith(BOGUS_FILE));
        }
    }
}

