/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.UTF8ByteArrayUtils;
import org.junit.jupiter.api.Test;

public class TestUTF8ByteArrayUtils
extends HadoopTestBase {
    @Test
    public void testFindByte() {
        byte[] data = "Hello, world!".getBytes();
        TestUTF8ByteArrayUtils.assertEquals((int)-1, (int)UTF8ByteArrayUtils.findByte((byte[])data, (int)0, (int)data.length, (byte)97), (String)"Character 'a' does not exist in string");
        TestUTF8ByteArrayUtils.assertEquals((int)4, (int)UTF8ByteArrayUtils.findByte((byte[])data, (int)0, (int)data.length, (byte)111), (String)"Did not find first occurrence of character 'o'");
    }

    @Test
    public void testFindBytes() {
        byte[] data = "Hello, world!".getBytes();
        TestUTF8ByteArrayUtils.assertEquals((int)1, (int)UTF8ByteArrayUtils.findBytes((byte[])data, (int)0, (int)data.length, (byte[])"ello".getBytes()), (String)"Did not find first occurrence of pattern 'ello'");
        TestUTF8ByteArrayUtils.assertEquals((int)-1, (int)UTF8ByteArrayUtils.findBytes((byte[])data, (int)2, (int)data.length, (byte[])"ello".getBytes()), (String)"Substring starting at position 2 does not contain pattern 'ello'");
    }

    @Test
    public void testFindNthByte() {
        byte[] data = "Hello, world!".getBytes();
        TestUTF8ByteArrayUtils.assertEquals((int)3, (int)UTF8ByteArrayUtils.findNthByte((byte[])data, (int)0, (int)data.length, (byte)108, (int)2), (String)"Did not find 2nd occurrence of character 'l'");
        TestUTF8ByteArrayUtils.assertEquals((int)-1, (int)UTF8ByteArrayUtils.findNthByte((byte[])data, (int)0, (int)data.length, (byte)108, (int)4), (String)"4th occurrence of character 'l' does not exist");
        TestUTF8ByteArrayUtils.assertEquals((int)10, (int)UTF8ByteArrayUtils.findNthByte((byte[])data, (byte)108, (int)3), (String)"Did not find 3rd occurrence of character 'l'");
    }
}

