/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStopWatch {
    @Test
    public void testStartAndStop() throws Exception {
        try (StopWatch sw = new StopWatch();){
            Assertions.assertFalse((boolean)sw.isRunning());
            sw.start();
            Assertions.assertTrue((boolean)sw.isRunning());
            sw.stop();
            Assertions.assertFalse((boolean)sw.isRunning());
        }
    }

    @Test
    public void testStopInTryWithResource() throws Exception {
        StopWatch sw = new StopWatch();
        Throwable throwable = null;
        if (sw != null) {
            if (throwable != null) {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                sw.close();
            }
        }
    }

    @Test
    public void testExceptions() throws Exception {
        StopWatch sw = new StopWatch();
        try {
            sw.stop();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException), (String)"IllegalStateException is expected");
        }
        sw.reset();
        sw.start();
        try {
            sw.start();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalStateException), (String)"IllegalStateException is expected");
        }
    }
}

