/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReflectionUtils {
    private static Class[] toConstruct = new Class[]{String.class, TestReflectionUtils.class, HashMap.class};
    private Throwable failure = null;

    @BeforeEach
    public void setUp() {
        ReflectionUtils.clearCache();
    }

    @Test
    public void testCache() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.cacheSize());
        this.doTestCache();
        org.junit.jupiter.api.Assertions.assertEquals((int)toConstruct.length, (int)this.cacheSize());
        ReflectionUtils.clearCache();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.cacheSize());
    }

    private void doTestCache() {
        for (int i = 0; i < toConstruct.length; ++i) {
            Class cl = toConstruct[i];
            Object x = ReflectionUtils.newInstance((Class)cl, null);
            Object y = ReflectionUtils.newInstance((Class)cl, null);
            org.junit.jupiter.api.Assertions.assertEquals((Object)cl, x.getClass());
            org.junit.jupiter.api.Assertions.assertEquals((Object)cl, y.getClass());
        }
    }

    @Test
    public void testThreadSafe() throws Exception {
        int i;
        Thread[] th = new Thread[32];
        for (i = 0; i < th.length; ++i) {
            th[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        TestReflectionUtils.this.doTestCache();
                    }
                    catch (Throwable t) {
                        TestReflectionUtils.this.failure = t;
                    }
                }
            };
            th[i].start();
        }
        for (i = 0; i < th.length; ++i) {
            th[i].join();
        }
        if (this.failure != null) {
            this.failure.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)this.failure.getMessage());
        }
    }

    private int cacheSize() throws Exception {
        return ReflectionUtils.getCacheSize();
    }

    @Test
    public void testCantCreate() {
        try {
            ReflectionUtils.newInstance(NoDefaultCtor.class, null);
            org.junit.jupiter.api.Assertions.fail((String)"invalid call should fail");
        }
        catch (RuntimeException rte) {
            org.junit.jupiter.api.Assertions.assertEquals(NoSuchMethodException.class, rte.getCause().getClass());
        }
    }

    @Test
    public void testCacheDoesntLeak() throws Exception {
        int iterations = 9999;
        for (int i = 0; i < iterations; ++i) {
            URLClassLoader loader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
            Class<?> cl = Class.forName("org.apache.hadoop.util.TestReflectionUtils$LoadedInChild", false, loader);
            Object o = ReflectionUtils.newInstance(cl, null);
            org.junit.jupiter.api.Assertions.assertEquals(cl, o.getClass());
        }
        System.gc();
        org.junit.jupiter.api.Assertions.assertTrue((this.cacheSize() < iterations ? 1 : 0) != 0, (String)(this.cacheSize() + " too big"));
    }

    @Test
    public void testGetDeclaredFieldsIncludingInherited() {
        Parent child = new Parent(){
            private int childField;

            public int getChildField() {
                return this.childField;
            }
        };
        List fields = ReflectionUtils.getDeclaredFieldsIncludingInherited(child.getClass());
        boolean containsParentField = false;
        boolean containsChildField = false;
        for (Field field : fields) {
            if (field.getName().equals("parentField")) {
                containsParentField = true;
                continue;
            }
            if (!field.getName().equals("childField")) continue;
            containsChildField = true;
        }
        List methods = ReflectionUtils.getDeclaredMethodsIncludingInherited(child.getClass());
        boolean containsParentMethod = false;
        boolean containsChildMethod = false;
        for (Method method : methods) {
            if (method.getName().equals("getParentField")) {
                containsParentMethod = true;
                continue;
            }
            if (!method.getName().equals("getChildField")) continue;
            containsChildMethod = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)containsParentField, (String)"Missing parent field");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)containsChildField, (String)"Missing child field");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)containsParentMethod, (String)"Missing parent method");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)containsChildMethod, (String)"Missing child method");
    }

    @Test
    public void testLogThreadInfo() throws Exception {
        Logger logger = LoggerFactory.getLogger(TestReflectionUtils.class);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs(logger);
        String title = "title";
        ReflectionUtils.logThreadInfo((Logger)logger, (String)"title", (long)0L);
        Assertions.assertThat((String)logCapturer.getOutput()).contains(new CharSequence[]{"Process Thread Dump: title"});
    }

    @Test
    public void testNewInstanceForNonDefaultConstructor() {
        Object x = ReflectionUtils.newInstance(NoDefaultCtor.class, null, (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{1});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(x instanceof NoDefaultCtor));
    }

    @Test
    public void testNewInstanceForNonDefaultConstructorWithException() {
        try {
            ReflectionUtils.newInstance(NoDefaultCtor.class, null, (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{1, 2});
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed before this point");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("1 parameters are required but 2 arguments are provided", e);
        }
        try {
            ReflectionUtils.newInstance(NoDefaultCtor.class, null, (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[0]);
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed before this point");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("1 parameters are required but 0 arguments are provided", e);
        }
    }

    public static class NoDefaultCtor {
        public NoDefaultCtor(int x) {
        }
    }

    private static class LoadedInChild {
        private LoadedInChild() {
        }
    }

    private class Parent {
        private int parentField;

        private Parent() {
        }

        public int getParentField() {
            return this.parentField;
        }
    }
}

