/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecords;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.DiskValidatorFactory;
import org.apache.hadoop.util.ReadWriteDiskValidator;
import org.apache.hadoop.util.ReadWriteDiskValidatorMetrics;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestReadWriteDiskValidator {
    private MetricsSystem ms;

    @BeforeEach
    public void setUp() {
        this.ms = DefaultMetricsSystem.instance();
    }

    @Test
    public void testReadWriteDiskValidator() throws DiskChecker.DiskErrorException, InterruptedException {
        int count = 100;
        File testDir = new File(System.getProperty("test.build.data"));
        ReadWriteDiskValidator readWriteDiskValidator = (ReadWriteDiskValidator)DiskValidatorFactory.getInstance((String)"read-write");
        for (int i = 0; i < count; ++i) {
            readWriteDiskValidator.checkStatus(testDir);
        }
        ReadWriteDiskValidatorMetrics metric = ReadWriteDiskValidatorMetrics.getMetric((String)testDir.toString());
        Assertions.assertEquals((long)metric.getFileReadQuantiles()[0].getEstimator().getCount(), (long)count, (String)"The count number of estimator in MutableQuantilesmetrics of file read is not right");
        Assertions.assertEquals((long)metric.getFileWriteQuantiles()[0].getEstimator().getCount(), (long)count, (String)"The count number of estimator in MutableQuantilesmetrics of file write is not right");
        MetricsSource source = this.ms.getSource(ReadWriteDiskValidatorMetrics.sourceName((String)testDir.toString()));
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        source.getMetrics((MetricsCollector)collector, true);
        MetricsRecords.assertMetric((MetricsRecord)collector.getRecords().get(0), "FailureCount", 0);
        MetricsRecords.assertMetric((MetricsRecord)collector.getRecords().get(0), "LastFailureTime", 0L);
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "WriteLatency3600sNumOps");
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "WriteLatency3600s50thPercentileLatencyMicros");
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "WriteLatency86400sNumOps");
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "WriteLatency864000sNumOps");
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "ReadLatency3600sNumOps");
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "ReadLatency3600s50thPercentileLatencyMicros");
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "ReadLatency86400sNumOps");
        MetricsRecords.assertMetricNotNull((MetricsRecord)collector.getRecords().get(0), "ReadLatency864000sNumOps");
    }

    @Test
    public void testCheckFailures() throws Throwable {
        ReadWriteDiskValidator readWriteDiskValidator = (ReadWriteDiskValidator)DiskValidatorFactory.getInstance((String)"read-write");
        File testDir = Files.createTempDirectory(Paths.get(System.getProperty("test.build.data"), new String[0]), "test", new FileAttribute[0]).toFile();
        try {
            Shell.execCommand((String[])Shell.getSetPermissionCommand((String)"000", (boolean)false, (String)testDir.getAbsolutePath()));
        }
        catch (Exception e) {
            testDir.delete();
            throw e;
        }
        try {
            readWriteDiskValidator.checkStatus(testDir);
            Assertions.fail((String)"Disk check should fail.");
        }
        catch (DiskChecker.DiskErrorException e) {
            Assertions.assertEquals((Object)"Disk Check failed!", (Object)e.getMessage());
        }
        MetricsSource source = this.ms.getSource(ReadWriteDiskValidatorMetrics.sourceName((String)testDir.toString()));
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        source.getMetrics((MetricsCollector)collector, true);
        try {
            readWriteDiskValidator.checkStatus(testDir);
            Assertions.fail((String)"Disk check should fail.");
        }
        catch (DiskChecker.DiskErrorException e) {
            Assertions.assertEquals((Object)"Disk Check failed!", (Object)e.getMessage());
        }
        source.getMetrics((MetricsCollector)collector, true);
        MetricsRecords.assertMetric((MetricsRecord)collector.getRecords().get(0), "FailureCount", 1);
        Long lastFailureTime1 = (Long)MetricsRecords.getMetricValueByName((MetricsRecord)collector.getRecords().get(0), "LastFailureTime");
        MetricsRecords.assertMetric((MetricsRecord)collector.getRecords().get(1), "FailureCount", 2);
        Long lastFailureTime2 = (Long)MetricsRecords.getMetricValueByName((MetricsRecord)collector.getRecords().get(1), "LastFailureTime");
        Assertions.assertTrue((lastFailureTime1 < lastFailureTime2 ? 1 : 0) != 0, (String)"The first failure time should be less than the second one");
        testDir.delete();
    }
}

