/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.util.Lists;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestLists {
    @Test
    public void testAddToEmptyArrayList() {
        ArrayList list = Lists.newArrayList();
        list.add("record1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record1", list.get(0));
    }

    @Test
    public void testAddToEmptyLinkedList() {
        LinkedList list = Lists.newLinkedList();
        list.add("record1");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record1", list.get(0));
    }

    @Test
    public void testVarArgArrayLists() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"record1", "record2", "record3"});
        list.add("record4");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)list.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record1", list.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record2", list.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record3", list.get(2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record4", list.get(3));
    }

    @Test
    public void testItrArrayLists() {
        HashSet<String> set = new HashSet<String>();
        set.add("record1");
        set.add("record2");
        set.add("record3");
        ArrayList list = Lists.newArrayList(set);
        list.add("record4");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)list.size());
    }

    @Test
    public void testItrLinkedLists() {
        HashSet<String> set = new HashSet<String>();
        set.add("record1");
        set.add("record2");
        set.add("record3");
        LinkedList list = Lists.newLinkedList(set);
        list.add("record4");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)list.size());
    }

    @Test
    public void testListsPartition() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        list.add("d");
        list.add("e");
        List res = Lists.partition(list, (int)2);
        ((ListAssert)Assertions.assertThat((List)res).describedAs("Number of partitions post partition", new Object[0])).hasSize(3);
        ((ListAssert)Assertions.assertThat((List)((List)res.get(0))).describedAs("Number of elements in first partition", new Object[0])).hasSize(2);
        ((ListAssert)Assertions.assertThat((List)((List)res.get(2))).describedAs("Number of elements in last partition", new Object[0])).hasSize(1);
        List res2 = Lists.partition(list, (int)1);
        ((ListAssert)Assertions.assertThat((List)res2).describedAs("Number of partitions post partition", new Object[0])).hasSize(5);
        ((ListAssert)Assertions.assertThat((List)((List)res2.get(0))).describedAs("Number of elements in first partition", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)((List)res2.get(4))).describedAs("Number of elements in last partition", new Object[0])).hasSize(1);
        List res3 = Lists.partition(list, (int)6);
        ((ListAssert)Assertions.assertThat((List)res3).describedAs("Number of partitions post partition", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat((List)((List)res3.get(0))).describedAs("Number of elements in first partition", new Object[0])).hasSize(5);
    }

    @Test
    public void testArrayListWithSize() {
        ArrayList list = Lists.newArrayListWithCapacity((int)3);
        list.add("record1");
        list.add("record2");
        list.add("record3");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)list.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record1", list.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record2", list.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record3", list.get(2));
        list = Lists.newArrayListWithCapacity((int)3);
        list.add("record1");
        list.add("record2");
        list.add("record3");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)list.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record1", list.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record2", list.get(1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"record3", list.get(2));
    }
}

