/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.LimitInputStream;
import org.junit.jupiter.api.Test;

public class TestLimitInputStream
extends HadoopTestBase {
    @Test
    public void testRead() throws IOException {
        try (LimitInputStream limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 0L);){
            TestLimitInputStream.assertEquals((int)-1, (int)limitInputStream.read(), (String)"Reading byte after reaching limit should return -1");
        }
        limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 4L);
        var2_2 = null;
        try {
            TestLimitInputStream.assertEquals((int)new Random(0L).nextInt(), (int)limitInputStream.read(), (String)"Incorrect byte returned");
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (limitInputStream != null) {
                if (var2_2 != null) {
                    try {
                        limitInputStream.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    limitInputStream.close();
                }
            }
        }
    }

    @Test
    public void testResetWithoutMark() throws IOException {
        TestLimitInputStream.assertThrows(IOException.class, () -> {
            try (LimitInputStream limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 128L);){
                limitInputStream.reset();
            }
        });
    }

    @Test
    public void testReadBytes() throws IOException {
        try (LimitInputStream limitInputStream = new LimitInputStream((InputStream)new RandomInputStream(), 128L);){
            Random r = new Random(0L);
            byte[] data = new byte[4];
            byte[] expected = new byte[]{(byte)r.nextInt(), (byte)r.nextInt(), (byte)r.nextInt(), (byte)r.nextInt()};
            limitInputStream.read(data, 0, 4);
            TestLimitInputStream.assertArrayEquals((byte[])expected, (byte[])data, (String)"Incorrect bytes returned");
        }
    }

    static class RandomInputStream
    extends InputStream {
        private Random rn = new Random(0L);

        RandomInputStream() {
        }

        @Override
        public int read() {
            return this.rn.nextInt();
        }
    }
}

