/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.util.IntrusiveCollection;
import org.junit.jupiter.api.Test;

public class TestIntrusiveCollection
extends HadoopTestBase {
    @Test
    public void testShouldAddElement() {
        IntrusiveCollection intrusiveCollection = new IntrusiveCollection();
        SimpleElement element = new SimpleElement();
        intrusiveCollection.add((IntrusiveCollection.Element)element);
        TestIntrusiveCollection.assertFalse((boolean)intrusiveCollection.isEmpty(), (String)"Collection should not be empty");
        TestIntrusiveCollection.assertTrue((boolean)intrusiveCollection.contains((Object)element), (String)"Collection should contain added element");
    }

    @Test
    public void testShouldRemoveElement() {
        IntrusiveCollection intrusiveCollection = new IntrusiveCollection();
        SimpleElement element = new SimpleElement();
        intrusiveCollection.add((IntrusiveCollection.Element)element);
        intrusiveCollection.remove((Object)element);
        TestIntrusiveCollection.assertTrue((boolean)intrusiveCollection.isEmpty(), (String)"Collection should be empty");
        TestIntrusiveCollection.assertFalse((boolean)intrusiveCollection.contains((Object)element), (String)"Collection should not contain removed element");
    }

    @Test
    public void testShouldRemoveAllElements() {
        IntrusiveCollection intrusiveCollection = new IntrusiveCollection();
        intrusiveCollection.add((IntrusiveCollection.Element)new SimpleElement());
        intrusiveCollection.add((IntrusiveCollection.Element)new SimpleElement());
        intrusiveCollection.add((IntrusiveCollection.Element)new SimpleElement());
        intrusiveCollection.clear();
        TestIntrusiveCollection.assertTrue((boolean)intrusiveCollection.isEmpty(), (String)"Collection should be empty");
    }

    @Test
    public void testIterateShouldReturnAllElements() {
        IntrusiveCollection intrusiveCollection = new IntrusiveCollection();
        SimpleElement elem1 = new SimpleElement();
        SimpleElement elem2 = new SimpleElement();
        SimpleElement elem3 = new SimpleElement();
        intrusiveCollection.add((IntrusiveCollection.Element)elem1);
        intrusiveCollection.add((IntrusiveCollection.Element)elem2);
        intrusiveCollection.add((IntrusiveCollection.Element)elem3);
        Iterator iterator = intrusiveCollection.iterator();
        TestIntrusiveCollection.assertEquals((Object)elem1, iterator.next(), (String)"First element returned is incorrect");
        TestIntrusiveCollection.assertEquals((Object)elem2, iterator.next(), (String)"Second element returned is incorrect");
        TestIntrusiveCollection.assertEquals((Object)elem3, iterator.next(), (String)"Third element returned is incorrect");
        TestIntrusiveCollection.assertFalse((boolean)iterator.hasNext(), (String)"Iterator should not have next element");
    }

    static class SimpleElement
    implements IntrusiveCollection.Element {
        private Map<IntrusiveCollection<? extends IntrusiveCollection.Element>, IntrusiveCollection.Element> prevMap = new HashMap<IntrusiveCollection<? extends IntrusiveCollection.Element>, IntrusiveCollection.Element>();
        private Map<IntrusiveCollection<? extends IntrusiveCollection.Element>, IntrusiveCollection.Element> nextMap = new HashMap<IntrusiveCollection<? extends IntrusiveCollection.Element>, IntrusiveCollection.Element>();
        private Map<IntrusiveCollection<? extends IntrusiveCollection.Element>, Boolean> isMemberMap = new HashMap<IntrusiveCollection<? extends IntrusiveCollection.Element>, Boolean>();

        public void insertInternal(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element prev, IntrusiveCollection.Element next) {
            this.isMemberMap.put(list, true);
            this.prevMap.put(list, prev);
            this.nextMap.put(list, next);
        }

        public void setPrev(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element prev) {
            this.prevMap.put(list, prev);
        }

        public void setNext(IntrusiveCollection<? extends IntrusiveCollection.Element> list, IntrusiveCollection.Element next) {
            this.nextMap.put(list, next);
        }

        public void removeInternal(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
            this.prevMap.remove(list);
            this.nextMap.remove(list);
            this.isMemberMap.remove(list);
        }

        public IntrusiveCollection.Element getPrev(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
            return this.prevMap.getOrDefault(list, null);
        }

        public IntrusiveCollection.Element getNext(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
            return this.nextMap.getOrDefault(list, null);
        }

        public boolean isInList(IntrusiveCollection<? extends IntrusiveCollection.Element> list) {
            return this.isMemberMap.getOrDefault(list, false);
        }
    }
}

