/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.InstrumentedLock;
import org.apache.hadoop.util.InstrumentedReadLock;
import org.apache.hadoop.util.InstrumentedReadWriteLock;
import org.apache.hadoop.util.InstrumentedWriteLock;
import org.apache.hadoop.util.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInstrumentedReadWriteLock {
    static final Logger LOG = LoggerFactory.getLogger(TestInstrumentedReadWriteLock.class);

    @Test
    @Timeout(value=10L)
    public void testWriteLock(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        final ThreadLocal<Boolean> locked = new ThreadLocal<Boolean>();
        locked.set(Boolean.FALSE);
        InstrumentedReadWriteLock readWriteLock = new InstrumentedReadWriteLock(true, testname, LOG, 2000L, 300L);
        final AutoCloseableLock writeLock = new AutoCloseableLock(readWriteLock.writeLock()){

            public AutoCloseableLock acquire() {
                AutoCloseableLock lock = super.acquire();
                locked.set(Boolean.TRUE);
                return lock;
            }

            public void release() {
                super.release();
                locked.set(Boolean.FALSE);
            }
        };
        final AutoCloseableLock readLock = new AutoCloseableLock(readWriteLock.readLock());
        try (AutoCloseableLock lock = writeLock.acquire();){
            Thread competingWriteThread = new Thread(){

                @Override
                public void run() {
                    Assertions.assertFalse((boolean)writeLock.tryLock());
                }
            };
            competingWriteThread.start();
            competingWriteThread.join();
            Thread competingReadThread = new Thread(){

                @Override
                public void run() {
                    Assertions.assertFalse((boolean)readLock.tryLock());
                }
            };
            competingReadThread.start();
            competingReadThread.join();
        }
        Assertions.assertFalse((boolean)((Boolean)locked.get()));
        locked.remove();
    }

    @Test
    @Timeout(value=10L)
    public void testReadLock(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        InstrumentedReadWriteLock readWriteLock = new InstrumentedReadWriteLock(true, testname, LOG, 2000L, 300L);
        final AutoCloseableLock readLock = new AutoCloseableLock(readWriteLock.readLock());
        final AutoCloseableLock writeLock = new AutoCloseableLock(readWriteLock.writeLock());
        try (AutoCloseableLock lock = readLock.acquire();){
            Thread competingReadThread = new Thread(){

                @Override
                public void run() {
                    Assertions.assertTrue((boolean)readLock.tryLock());
                    readLock.release();
                }
            };
            competingReadThread.start();
            competingReadThread.join();
            Thread competingWriteThread = new Thread(){

                @Override
                public void run() {
                    Assertions.assertFalse((boolean)writeLock.tryLock());
                }
            };
            competingWriteThread.start();
            competingWriteThread.join();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testReadLockLongHoldingReport(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        InstrumentedReadLock readLock = new InstrumentedReadLock(testname, LOG, readWriteLock, 2000L, 300L, mclock){

            protected void logWarning(long lockHeldTime, InstrumentedLock.SuppressedSnapshot stats) {
                wlogged.incrementAndGet();
                wsuppresed.set(stats.getSuppressedCount());
            }
        };
        readLock.lock();
        time.set(100L);
        readLock.unlock();
        Assertions.assertEquals((long)0L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        readLock.lock();
        time.set(500L);
        readLock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        readLock.lock();
        time.set(900L);
        readLock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        readLock.lock();
        time.set(3000L);
        readLock.unlock();
        Assertions.assertEquals((long)2L, (long)wlogged.get());
        Assertions.assertEquals((long)1L, (long)wsuppresed.get());
    }

    @Test
    @Timeout(value=10L)
    public void testWriteLockLongHoldingReport(TestInfo testInfo) throws Exception {
        String testname = testInfo.getDisplayName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        InstrumentedWriteLock writeLock = new InstrumentedWriteLock(testname, LOG, readWriteLock, 2000L, 300L, mclock){

            protected void logWarning(long lockHeldTime, InstrumentedLock.SuppressedSnapshot stats) {
                wlogged.incrementAndGet();
                wsuppresed.set(stats.getSuppressedCount());
            }
        };
        writeLock.lock();
        time.set(100L);
        writeLock.unlock();
        Assertions.assertEquals((long)0L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        writeLock.lock();
        time.set(500L);
        writeLock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        writeLock.lock();
        time.set(900L);
        writeLock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        writeLock.lock();
        time.set(3000L);
        writeLock.unlock();
        Assertions.assertEquals((long)2L, (long)wlogged.get());
        Assertions.assertEquals((long)1L, (long)wsuppresed.get());
    }

    @Test
    @Timeout(value=10L)
    public void testWriteLockLongHoldingReportWithReentrant(TestInfo testInfo) {
        String testname = testInfo.getDisplayName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        final AtomicLong totalHeldTime = new AtomicLong(0L);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        InstrumentedWriteLock writeLock = new InstrumentedWriteLock(testname, LOG, readWriteLock, 2000L, 300L, mclock){

            protected void logWarning(long lockHeldTime, InstrumentedLock.SuppressedSnapshot stats) {
                totalHeldTime.addAndGet(lockHeldTime);
                wlogged.incrementAndGet();
                wsuppresed.set(stats.getSuppressedCount());
            }
        };
        InstrumentedReadLock readLock = new InstrumentedReadLock(testname, LOG, readWriteLock, 2000L, 300L, mclock){

            protected void logWarning(long lockHeldTime, InstrumentedLock.SuppressedSnapshot stats) {
                totalHeldTime.addAndGet(lockHeldTime);
                wlogged.incrementAndGet();
                wsuppresed.set(stats.getSuppressedCount());
            }
        };
        writeLock.lock();
        time.set(100L);
        writeLock.lock();
        time.set(500L);
        writeLock.lock();
        time.set(2900L);
        writeLock.unlock();
        readLock.lock();
        time.set(3000L);
        readLock.unlock();
        writeLock.unlock();
        writeLock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)3000L, (long)totalHeldTime.get());
    }

    @Test
    @Timeout(value=10L)
    public void testReadLockLongHoldingReportWithReentrant(TestInfo testInfo) {
        String testname = testInfo.getDisplayName();
        final AtomicLong time = new AtomicLong(0L);
        Timer mclock = new Timer(){

            public long monotonicNow() {
                return time.get();
            }
        };
        final AtomicLong wlogged = new AtomicLong(0L);
        final AtomicLong wsuppresed = new AtomicLong(0L);
        final AtomicLong totalHelpTime = new AtomicLong(0L);
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
        InstrumentedReadLock readLock = new InstrumentedReadLock(testname, LOG, readWriteLock, 2000L, 300L, mclock){

            protected void logWarning(long lockHeldTime, InstrumentedLock.SuppressedSnapshot stats) {
                totalHelpTime.addAndGet(lockHeldTime);
                wlogged.incrementAndGet();
                wsuppresed.set(stats.getSuppressedCount());
            }
        };
        readLock.lock();
        time.set(100L);
        readLock.lock();
        time.set(500L);
        readLock.lock();
        time.set(3000L);
        readLock.unlock();
        readLock.unlock();
        readLock.unlock();
        Assertions.assertEquals((long)1L, (long)wlogged.get());
        Assertions.assertEquals((long)0L, (long)wsuppresed.get());
        Assertions.assertEquals((long)3000L, (long)totalHelpTime.get());
    }
}

