/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.util.DiskChecker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=30L)
public final class TestDiskCheckerWithDiskIo {
    @Test
    public final void testDiskIoIgnoresTransientCreateErrors() throws Throwable {
        DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(2, 0));
        this.checkDirs(true);
    }

    @Test
    public final void testDiskIoDetectsCreateErrors() throws Throwable {
        Assertions.assertThrows(DiskChecker.DiskErrorException.class, () -> {
            DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(3, 0));
            this.checkDirs(false);
        });
    }

    @Test
    public final void testDiskIoIgnoresTransientWriteErrors() throws Throwable {
        DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(0, 2));
        this.checkDirs(true);
    }

    @Test
    public final void testDiskIoDetectsWriteErrors() throws Throwable {
        Assertions.assertThrows(DiskChecker.DiskErrorException.class, () -> {
            DiskChecker.replaceFileOutputStreamProvider((DiskChecker.FileIoProvider)new TestFileIoProvider(0, 3));
            this.checkDirs(false);
        });
    }

    @Test
    public void testDiskIoFileNaming() {
        File rootDir = new File("/");
        Assertions.assertTrue((boolean)".001".matches("\\.00\\d$"));
        for (int i = 1; i < 3; ++i) {
            File file = DiskChecker.getFileNameForDiskIoCheck((File)rootDir, (int)i);
            Assertions.assertTrue((boolean)file.toString().matches("^.*\\.[0-9]+$"), (String)("File name does not match expected pattern: " + file));
        }
        File guidFile = DiskChecker.getFileNameForDiskIoCheck((File)rootDir, (int)3);
        Assertions.assertTrue((boolean)guidFile.toString().matches("^.*\\.[A-Za-z0-9-]+$"), (String)("File name does not match expected pattern: " + guidFile));
    }

    private void checkDirs(boolean success) throws Throwable {
        File localDir = this.createTempDir();
        try {
            DiskChecker.checkDirWithDiskIo((File)localDir);
        }
        finally {
            localDir.delete();
        }
    }

    private File createTempDir() throws IOException {
        File testDir = new File(System.getProperty("test.build.data"));
        return Files.createTempDirectory(testDir.toPath(), "test", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"))).toFile();
    }

    private static class TestFileIoProvider
    implements DiskChecker.FileIoProvider {
        private final AtomicInteger numCreateCalls = new AtomicInteger(0);
        private final AtomicInteger numWriteCalls = new AtomicInteger(0);
        private final int numTimesToThrowOnCreate;
        private final int numTimesToThrowOnWrite;

        public TestFileIoProvider(int numTimesToThrowOnCreate, int numTimesToThrowOnWrite) {
            this.numTimesToThrowOnCreate = numTimesToThrowOnCreate;
            this.numTimesToThrowOnWrite = numTimesToThrowOnWrite;
        }

        public FileOutputStream get(File f) throws FileNotFoundException {
            if (this.numCreateCalls.getAndIncrement() < this.numTimesToThrowOnCreate) {
                throw new FileNotFoundException("Dummy exception for testing");
            }
            return new FileOutputStream(f);
        }

        public void write(FileOutputStream fos, byte[] data) throws IOException {
            if (this.numWriteCalls.getAndIncrement() < this.numTimesToThrowOnWrite) {
                throw new IOException("Dummy exception for testing");
            }
            fos.write(data);
        }
    }
}

