/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.apache.hadoop.util.DirectBufferPool;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDirectBufferPool {
    final DirectBufferPool pool = new DirectBufferPool();

    @Test
    public void testBasics() {
        ByteBuffer a = this.pool.getBuffer(100);
        Assertions.assertEquals((int)100, (int)a.capacity());
        Assertions.assertEquals((int)100, (int)a.remaining());
        this.pool.returnBuffer(a);
        ByteBuffer b = this.pool.getBuffer(100);
        Assertions.assertSame((Object)a, (Object)b);
        ByteBuffer c = this.pool.getBuffer(100);
        Assertions.assertNotSame((Object)b, (Object)c);
        this.pool.returnBuffer(b);
        this.pool.returnBuffer(c);
    }

    @Test
    public void testBuffersAreReset() {
        ByteBuffer a = this.pool.getBuffer(100);
        a.putInt(-559038737);
        Assertions.assertEquals((int)96, (int)a.remaining());
        this.pool.returnBuffer(a);
        ByteBuffer b = this.pool.getBuffer(100);
        Assertions.assertSame((Object)a, (Object)b);
        Assertions.assertEquals((int)100, (int)a.remaining());
        this.pool.returnBuffer(b);
    }

    @Test
    public void testWeakRefClearing() {
        LinkedList bufs = Lists.newLinkedList();
        for (int i = 0; i < 10; ++i) {
            ByteBuffer buf = this.pool.getBuffer(100);
            bufs.add(buf);
        }
        for (ByteBuffer buf : bufs) {
            this.pool.returnBuffer(buf);
        }
        Assertions.assertEquals((int)10, (int)this.pool.countBuffersOfSize(100));
        bufs.clear();
        bufs = null;
        for (int i = 0; i < 3; ++i) {
            System.gc();
        }
        ByteBuffer buf = this.pool.getBuffer(100);
        Assertions.assertEquals((int)0, (int)this.pool.countBuffersOfSize(100));
        this.pool.returnBuffer(buf);
    }
}

