/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Objects;
import java.util.Random;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.CrcUtil;
import org.apache.hadoop.util.DataChecksum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=10L)
public class TestCrcUtil {
    private static final Random RANDOM = new Random(1234L);

    @Test
    public void testComposeCrc32() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 512, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 511, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 32768, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, Short.MAX_VALUE, false);
    }

    @Test
    public void testComposeCrc32c() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 512, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 511, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 32768, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, Short.MAX_VALUE, false);
    }

    @Test
    public void testComposeCrc32WithMonomial() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 512, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 511, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 32768, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, Short.MAX_VALUE, true);
    }

    @Test
    public void testComposeCrc32cWithMonomial() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 512, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 511, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 32768, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, Short.MAX_VALUE, true);
    }

    @Test
    public void testComposeCrc32ZeroLength() {
        TestCrcUtil.doTestComposeCrcZerolength(DataChecksum.Type.CRC32);
    }

    @Test
    public void testComposeCrc32CZeroLength() {
        TestCrcUtil.doTestComposeCrcZerolength(DataChecksum.Type.CRC32C);
    }

    private static void doTestComposeCrc(byte[] data, DataChecksum.Type type, int chunkSize, boolean useMonomial) {
        int partialCrc;
        int crcPolynomial = DataChecksum.getCrcPolynomialForType((DataChecksum.Type)type);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)Integer.MAX_VALUE);
        Objects.requireNonNull(checksum, "checksum");
        checksum.update(data, 0, data.length);
        int fullCrc = (int)checksum.getValue();
        int compositeCrc = 0;
        int crcMonomial = useMonomial ? CrcUtil.getMonomial((long)chunkSize, (int)crcPolynomial) : 0;
        int offset = 0;
        while (offset + chunkSize <= data.length) {
            checksum.reset();
            checksum.update(data, offset, chunkSize);
            partialCrc = (int)checksum.getValue();
            compositeCrc = useMonomial ? CrcUtil.composeWithMonomial((int)compositeCrc, (int)partialCrc, (int)crcMonomial, (int)crcPolynomial) : CrcUtil.compose((int)compositeCrc, (int)partialCrc, (long)chunkSize, (int)crcPolynomial);
            offset += chunkSize;
        }
        int partialChunkSize = data.length % chunkSize;
        if (partialChunkSize > 0) {
            checksum.reset();
            checksum.update(data, data.length - partialChunkSize, partialChunkSize);
            partialCrc = (int)checksum.getValue();
            compositeCrc = CrcUtil.compose((int)compositeCrc, (int)partialCrc, (long)partialChunkSize, (int)crcPolynomial);
        }
        Assertions.assertEquals((int)fullCrc, (int)compositeCrc, (String)String.format("Using CRC type '%s' with crcPolynomial '0x%08x' and chunkSize '%d', expected '0x%08x', got '0x%08x'", type, crcPolynomial, chunkSize, fullCrc, compositeCrc));
    }

    private static void doTestComposeCrcZerolength(DataChecksum.Type type) {
        int crcA = -889274641;
        int crcPolynomial = DataChecksum.getCrcPolynomialForType((DataChecksum.Type)type);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)Integer.MAX_VALUE);
        Objects.requireNonNull(checksum, "checksum");
        int crcB = (int)checksum.getValue();
        Assertions.assertEquals((int)crcA, (int)CrcUtil.compose((int)crcA, (int)crcB, (long)0L, (int)crcPolynomial));
        int monomial = CrcUtil.getMonomial((long)0L, (int)crcPolynomial);
        Assertions.assertEquals((int)crcA, (int)CrcUtil.composeWithMonomial((int)crcA, (int)crcB, (int)monomial, (int)crcPolynomial));
    }

    @Test
    public void testIntSerialization() {
        byte[] bytes = CrcUtil.intToBytes((int)-889274641);
        Assertions.assertEquals((int)-889274641, (int)CrcUtil.readInt((byte[])bytes, (int)0));
        bytes = new byte[8];
        CrcUtil.writeInt((byte[])bytes, (int)0, (int)-889274641);
        Assertions.assertEquals((int)-889274641, (int)CrcUtil.readInt((byte[])bytes, (int)0));
        CrcUtil.writeInt((byte[])bytes, (int)4, (int)-1412584499);
        Assertions.assertEquals((int)-1412584499, (int)CrcUtil.readInt((byte[])bytes, (int)4));
        Assertions.assertEquals((int)-1091589171, (int)CrcUtil.readInt((byte[])bytes, (int)2));
    }

    @Test
    public void testToSingleCrcStringBadLength() throws Exception {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "length", () -> CrcUtil.toSingleCrcString((byte[])new byte[8]));
    }

    @Test
    public void testToSingleCrcString() {
        byte[] buf = CrcUtil.intToBytes((int)-889274641);
        Assertions.assertEquals((Object)"0xcafebeef", (Object)CrcUtil.toSingleCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringBadLength() throws Exception {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "length", () -> CrcUtil.toMultiCrcString((byte[])new byte[6]));
    }

    @Test
    public void testToMultiCrcStringMultipleElements() {
        byte[] buf = new byte[12];
        CrcUtil.writeInt((byte[])buf, (int)0, (int)-889274641);
        CrcUtil.writeInt((byte[])buf, (int)4, (int)-1414804276);
        CrcUtil.writeInt((byte[])buf, (int)8, (int)-572657681);
        Assertions.assertEquals((Object)"[0xcafebeef, 0xababcccc, 0xddddefef]", (Object)CrcUtil.toMultiCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringSingleElement() {
        byte[] buf = new byte[4];
        CrcUtil.writeInt((byte[])buf, (int)0, (int)-889274641);
        Assertions.assertEquals((Object)"[0xcafebeef]", (Object)CrcUtil.toMultiCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringNoElements() {
        Assertions.assertEquals((Object)"[]", (Object)CrcUtil.toMultiCrcString((byte[])new byte[0]));
    }
}

