/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Classpath;
import org.apache.hadoop.util.ExitUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClasspath {
    private static final Logger LOG = LoggerFactory.getLogger(TestClasspath.class);
    private static final File TEST_DIR = GenericTestUtils.getTestDir("TestClasspath");
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private PrintStream oldStdout;
    private PrintStream oldStderr;
    private ByteArrayOutputStream stdout;
    private ByteArrayOutputStream stderr;
    private PrintStream printStdout;
    private PrintStream printStderr;

    @BeforeEach
    public void setUp() {
        Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)TEST_DIR));
        Assertions.assertTrue((boolean)TEST_DIR.mkdirs());
        this.oldStdout = System.out;
        this.oldStderr = System.err;
        this.stdout = new ByteArrayOutputStream();
        this.printStdout = new PrintStream(this.stdout);
        System.setOut(this.printStdout);
        this.stderr = new ByteArrayOutputStream();
        this.printStderr = new PrintStream(this.stderr);
        System.setErr(this.printStderr);
    }

    @AfterEach
    public void tearDown() {
        System.setOut(this.oldStdout);
        System.setErr(this.oldStderr);
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.printStdout, this.printStderr});
        Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)TEST_DIR));
    }

    @Test
    public void testGlob() {
        Classpath.main((String[])new String[]{"--glob"});
        String strOut = new String(this.stdout.toByteArray(), UTF8);
        Assertions.assertEquals((Object)System.getProperty("java.class.path"), (Object)strOut.trim());
        Assertions.assertTrue((this.stderr.toByteArray().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJar() throws IOException {
        File file = new File(TEST_DIR, "classpath.jar");
        Classpath.main((String[])new String[]{"--jar", file.getAbsolutePath()});
        Assertions.assertTrue((this.stdout.toByteArray().length == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.stderr.toByteArray().length == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)file.exists());
        TestClasspath.assertJar(file);
    }

    @Test
    public void testJarReplace() throws IOException {
        this.testJar();
        this.testJar();
    }

    @Test
    public void testJarFileMissing() throws IOException {
        try {
            Classpath.main((String[])new String[]{"--jar"});
            Assertions.fail((String)"expected exit");
        }
        catch (ExitUtil.ExitException e) {
            Assertions.assertTrue((this.stdout.toByteArray().length == 0 ? 1 : 0) != 0);
            String strErr = new String(this.stderr.toByteArray(), UTF8);
            Assertions.assertTrue((boolean)strErr.contains("requires path of jar"));
        }
    }

    @Test
    public void testHelp() {
        Classpath.main((String[])new String[]{"--help"});
        String strOut = new String(this.stdout.toByteArray(), UTF8);
        Assertions.assertTrue((boolean)strOut.contains("Prints the classpath"));
        Assertions.assertTrue((this.stderr.toByteArray().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHelpShort() {
        Classpath.main((String[])new String[]{"-h"});
        String strOut = new String(this.stdout.toByteArray(), UTF8);
        Assertions.assertTrue((boolean)strOut.contains("Prints the classpath"));
        Assertions.assertTrue((this.stderr.toByteArray().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUnrecognized() {
        try {
            Classpath.main((String[])new String[]{"--notarealoption"});
            Assertions.fail((String)"expected exit");
        }
        catch (ExitUtil.ExitException e) {
            Assertions.assertTrue((this.stdout.toByteArray().length == 0 ? 1 : 0) != 0);
            String strErr = new String(this.stderr.toByteArray(), UTF8);
            Assertions.assertTrue((boolean)strErr.contains("unrecognized option"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertJar(File file) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            Assertions.assertNotNull((Object)manifest);
            Attributes mainAttributes = manifest.getMainAttributes();
            Assertions.assertNotNull((Object)mainAttributes);
            Assertions.assertTrue((boolean)mainAttributes.containsKey(Attributes.Name.CLASS_PATH));
            String classPathAttr = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            Assertions.assertNotNull((Object)classPathAttr);
            Assertions.assertFalse((boolean)classPathAttr.isEmpty());
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LOG.warn("exception closing jarFile: " + jarFile, (Throwable)e);
                }
            }
        }
    }

    static {
        ExitUtil.disableSystemExit();
    }
}

