/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.util.ClassUtil;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestClassUtil {
    @Test
    @Timeout(value=10L)
    public void testFindContainingJar() {
        String containingJar = ClassUtil.findContainingJar(Assertions.class);
        ((AbstractStringAssert)Assertions.assertThat((String)containingJar).describedAs("Containing jar for %s", new Object[]{Assertions.class})).isNotNull();
        File jarFile = new File(containingJar);
        ((AbstractFileAssert)Assertions.assertThat((File)jarFile).describedAs("Containing jar %s", new Object[]{jarFile})).exists();
        ((AbstractStringAssert)Assertions.assertThat((String)jarFile.getName()).describedAs("Containing jar name %s", new Object[]{jarFile.getName()})).matches((CharSequence)"assertj-core.*[.]jar");
    }

    @Test
    @Timeout(value=10L)
    public void testFindContainingClass() {
        String classFileLocation = ClassUtil.findClassLocation(ViewFileSystem.class);
        ((AbstractStringAssert)Assertions.assertThat((String)classFileLocation).describedAs("Class path for %s", new Object[]{ViewFileSystem.class})).isNotNull();
        File classFile = new File(classFileLocation);
        ((AbstractFileAssert)Assertions.assertThat((File)classFile).describedAs("Containing class file %s", new Object[]{classFile})).exists();
        ((AbstractStringAssert)Assertions.assertThat((String)classFile.getName()).describedAs("Containing class file name %s", new Object[]{classFile.getName()})).matches((CharSequence)"ViewFileSystem.class");
    }
}

