/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import org.apache.hadoop.util.CacheableIPList;
import org.apache.hadoop.util.FileBasedIPList;
import org.apache.hadoop.util.TestFileBasedIPList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCacheableIPList {
    @Test
    public void testAddWithSleepForCacheTimeout() throws IOException, InterruptedException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102.0/23", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        CacheableIPList cipl = new CacheableIPList(new FileBasedIPList("ips.txt"), 100L);
        Assertions.assertFalse((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is in the list");
        Assertions.assertFalse((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is  in the list");
        TestFileBasedIPList.removeFile("ips.txt");
        String[] ips2 = new String[]{"10.119.103.112", "10.221.102.0/23", "10.222.0.0/16", "10.113.221.221", "10.113.221.222"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips2);
        Thread.sleep(101L);
        Assertions.assertTrue((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is not in the list");
        Assertions.assertTrue((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is not in the list");
        TestFileBasedIPList.removeFile("ips.txt");
    }

    @Test
    public void testRemovalWithSleepForCacheTimeout() throws IOException, InterruptedException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102.0/23", "10.222.0.0/16", "10.113.221.221", "10.113.221.222"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        CacheableIPList cipl = new CacheableIPList(new FileBasedIPList("ips.txt"), 100L);
        Assertions.assertTrue((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is not in the list");
        Assertions.assertTrue((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is not in the list");
        TestFileBasedIPList.removeFile("ips.txt");
        String[] ips2 = new String[]{"10.119.103.112", "10.221.102.0/23", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips2);
        Thread.sleep(1005L);
        Assertions.assertFalse((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is in the list");
        Assertions.assertFalse((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is  in the list");
        TestFileBasedIPList.removeFile("ips.txt");
    }

    @Test
    public void testAddWithRefresh() throws IOException, InterruptedException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102.0/23", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        CacheableIPList cipl = new CacheableIPList(new FileBasedIPList("ips.txt"), 100L);
        Assertions.assertFalse((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is in the list");
        Assertions.assertFalse((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is  in the list");
        TestFileBasedIPList.removeFile("ips.txt");
        String[] ips2 = new String[]{"10.119.103.112", "10.221.102.0/23", "10.222.0.0/16", "10.113.221.221", "10.113.221.222"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips2);
        cipl.refresh();
        Assertions.assertTrue((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is not in the list");
        Assertions.assertTrue((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is not in the list");
        TestFileBasedIPList.removeFile("ips.txt");
    }

    @Test
    public void testRemovalWithRefresh() throws IOException, InterruptedException {
        String[] ips = new String[]{"10.119.103.112", "10.221.102.0/23", "10.222.0.0/16", "10.113.221.221", "10.113.221.222"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips);
        CacheableIPList cipl = new CacheableIPList(new FileBasedIPList("ips.txt"), 100L);
        Assertions.assertTrue((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is not in the list");
        Assertions.assertTrue((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is not in the list");
        TestFileBasedIPList.removeFile("ips.txt");
        String[] ips2 = new String[]{"10.119.103.112", "10.221.102.0/23", "10.113.221.221"};
        TestFileBasedIPList.createFileWithEntries("ips.txt", ips2);
        cipl.refresh();
        Assertions.assertFalse((boolean)cipl.isIn("10.113.221.222"), (String)"10.113.221.222 is in the list");
        Assertions.assertFalse((boolean)cipl.isIn("10.222.103.121"), (String)"10.222.103.121 is  in the list");
        TestFileBasedIPList.removeFile("ips.txt");
    }
}

