/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.AsyncDiskService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAsyncDiskService {
    public static final Logger LOG = LoggerFactory.getLogger(TestAsyncDiskService.class);
    volatile int count;

    @Test
    public void testAsyncDiskService() throws Throwable {
        String[] vols = new String[]{"/0", "/1"};
        AsyncDiskService service = new AsyncDiskService(vols);
        int total = 100;
        for (int i = 0; i < total; ++i) {
            service.execute(vols[i % 2], (Runnable)new ExampleTask());
        }
        RuntimeException e = null;
        try {
            service.execute("no_such_volume", (Runnable)new ExampleTask());
        }
        catch (RuntimeException ex) {
            e = ex;
        }
        Assertions.assertNotNull((Object)e, (String)"Executing a task on a non-existing volume should throw an Exception.");
        service.shutdown();
        if (!service.awaitTermination(5000L)) {
            Assertions.fail((String)"AsyncDiskService didn't shutdown in 5 seconds.");
        }
        Assertions.assertEquals((int)total, (int)this.count);
    }

    class ExampleTask
    implements Runnable {
        ExampleTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TestAsyncDiskService testAsyncDiskService = TestAsyncDiskService.this;
            synchronized (testAsyncDiskService) {
                ++TestAsyncDiskService.this.count;
            }
        }
    }
}

