/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Splitter;
import org.apache.hadoop.util.ApplicationClassLoader;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestApplicationClassLoader {
    private static File testDir = GenericTestUtils.getTestDir("appclassloader");

    @BeforeEach
    public void setUp() {
        FileUtil.fullyDelete((File)testDir);
        testDir.mkdirs();
    }

    @Test
    public void testConstructUrlsFromClasspath() throws Exception {
        File file = new File(testDir, "file");
        Assertions.assertTrue((boolean)file.createNewFile(), (String)"Create file");
        File dir = new File(testDir, "dir");
        Assertions.assertTrue((boolean)dir.mkdir(), (String)"Make dir");
        File jarsDir = new File(testDir, "jarsdir");
        Assertions.assertTrue((boolean)jarsDir.mkdir(), (String)"Make jarsDir");
        File nonJarFile = new File(jarsDir, "nonjar");
        Assertions.assertTrue((boolean)nonJarFile.createNewFile(), (String)"Create non-jar file");
        File jarFile = new File(jarsDir, "a.jar");
        Assertions.assertTrue((boolean)jarFile.createNewFile(), (String)"Create jar file");
        File nofile = new File(testDir, "nofile");
        StringBuilder cp = new StringBuilder();
        cp.append(file.getAbsolutePath()).append(File.pathSeparator).append(dir.getAbsolutePath()).append(File.pathSeparator).append(jarsDir.getAbsolutePath() + "/*").append(File.pathSeparator).append(nofile.getAbsolutePath()).append(File.pathSeparator).append(nofile.getAbsolutePath() + "/*").append(File.pathSeparator);
        URL[] urls = ApplicationClassLoader.constructUrlsFromClasspath((String)cp.toString());
        Assertions.assertEquals((int)3, (int)urls.length);
        Assertions.assertEquals((Object)file.toURI().toURL(), (Object)urls[0]);
        Assertions.assertEquals((Object)dir.toURI().toURL(), (Object)urls[1]);
        Assertions.assertEquals((Object)jarFile.toURI().toURL(), (Object)urls[2]);
    }

    @Test
    public void testIsSystemClass() {
        this.testIsSystemClassInternal("");
    }

    @Test
    public void testIsSystemNestedClass() {
        this.testIsSystemClassInternal("$Klass");
    }

    private void testIsSystemClassInternal(String nestedClass) {
        Assertions.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), null));
        Assertions.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.Foo")));
        Assertions.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("/org.example.Foo" + nestedClass), this.classes("org.example.Foo")));
        Assertions.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.")));
        Assertions.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("net.example.Foo" + nestedClass), this.classes("org.example.,net.example.")));
        Assertions.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("-org.example.Foo,org.example.")));
        Assertions.assertTrue((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Bar" + nestedClass), this.classes("-org.example.Foo.,org.example.")));
        Assertions.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.,-org.example.Foo")));
        Assertions.assertFalse((boolean)ApplicationClassLoader.isSystemClass((String)("org.example.Foo" + nestedClass), this.classes("org.example.Foo,-org.example.Foo")));
    }

    private List<String> classes(String classes) {
        return Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)classes));
    }

    @Test
    public void testGetResource() throws IOException {
        URL testJar = this.makeTestJar().toURI().toURL();
        ClassLoader currentClassLoader = this.getClass().getClassLoader();
        ApplicationClassLoader appClassloader = new ApplicationClassLoader(new URL[]{testJar}, currentClassLoader, null);
        Assertions.assertNull((Object)currentClassLoader.getResourceAsStream("resource.txt"), (String)"Resource should be null for current classloader");
        InputStream in = appClassloader.getResourceAsStream("resource.txt");
        Assertions.assertNotNull((Object)in, (String)"Resource should not be null for app classloader");
        Assertions.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
    }

    private File makeTestJar() throws IOException {
        File jarFile = new File(testDir, "test.jar");
        JarOutputStream out = new JarOutputStream(new FileOutputStream(jarFile));
        ZipEntry entry = new ZipEntry("resource.txt");
        out.putNextEntry(entry);
        out.write("hello".getBytes());
        out.closeEntry();
        out.close();
        return jarFile;
    }
}

