/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMultithreadedTestUtil {
    private static final String FAIL_MSG = "Inner thread fails an assert";

    @Test
    public void testNoErrors() throws Exception {
        final AtomicInteger threadsRun = new AtomicInteger();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 3; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    threadsRun.incrementAndGet();
                }
            });
        }
        Assertions.assertEquals((int)0, (int)threadsRun.get());
        ctx.startThreads();
        long st = Time.now();
        ctx.waitFor(30000L);
        long et = Time.now();
        Assertions.assertEquals((int)3, (int)threadsRun.get());
        Assertions.assertTrue((et - st < 5000L ? 1 : 0) != 0, (String)("Test took " + (et - st) + "ms"));
    }

    @Test
    public void testThreadFails() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

            @Override
            public void doWork() throws Exception {
                Assertions.fail((String)TestMultithreadedTestUtil.FAIL_MSG);
            }
        });
        ctx.startThreads();
        long st = Time.now();
        try {
            ctx.waitFor(30000L);
            Assertions.fail((String)"waitFor did not throw");
        }
        catch (RuntimeException rte) {
            Assertions.assertEquals((Object)FAIL_MSG, (Object)rte.getCause().getMessage());
        }
        long et = Time.now();
        Assertions.assertTrue((et - st < 5000L ? 1 : 0) != 0, (String)("Test took " + (et - st) + "ms"));
    }

    @Test
    public void testThreadThrowsCheckedException() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

            @Override
            public void doWork() throws Exception {
                throw new IOException("my ioe");
            }
        });
        ctx.startThreads();
        long st = Time.now();
        try {
            ctx.waitFor(30000L);
            Assertions.fail((String)"waitFor did not throw");
        }
        catch (RuntimeException rte) {
            Assertions.assertEquals((Object)"my ioe", (Object)rte.getCause().getMessage());
        }
        long et = Time.now();
        Assertions.assertTrue((et - st < 5000L ? 1 : 0) != 0, (String)("Test took " + (et - st) + "ms"));
    }

    @Test
    public void testRepeatingThread() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        ctx.addThread(new MultithreadedTestUtil.RepeatingTestThread(ctx){

            @Override
            public void doAnAction() throws Exception {
                counter.incrementAndGet();
            }
        });
        ctx.startThreads();
        long st = Time.now();
        ctx.waitFor(3000L);
        ctx.stop();
        long et = Time.now();
        long elapsed = et - st;
        Assertions.assertTrue((Math.abs(elapsed - 3000L) < 500L ? 1 : 0) != 0, (String)("Test took " + (et - st) + "ms"));
        Assertions.assertTrue((counter.get() > 1000 ? 1 : 0) != 0, (String)("Counter value = " + counter.get()));
    }
}

