/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLambdaTestUtils
extends Assertions {
    public static final int INTERVAL = 10;
    public static final int TIMEOUT = 50;
    private LambdaTestUtils.FixedRetryInterval retry = new LambdaTestUtils.FixedRetryInterval(10);
    private int count;
    public static final Callable<Boolean> ALWAYS_TRUE = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return true;
        }
    };
    public static final Callable<Boolean> ALWAYS_FALSE = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return false;
        }
    };
    public static final String MISSING = "not found";
    public static final Callable<Boolean> ALWAYS_FNFE = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            throw new FileNotFoundException(TestLambdaTestUtils.MISSING);
        }
    };
    public static final LambdaTestUtils.GenerateTimeout TIMEOUT_FAILURE_HANDLER = new LambdaTestUtils.GenerateTimeout();
    public static final Callable<Long> EVAL_3L = new Callable<Long>(){

        @Override
        public Long call() throws Exception {
            return 3L;
        }
    };
    public static final Callable<Long> EVAL_FNFE = new Callable<Long>(){

        @Override
        public Long call() throws Exception {
            throw new FileNotFoundException(TestLambdaTestUtils.MISSING);
        }
    };

    protected void assertRetryCount(int expected) {
        TestLambdaTestUtils.assertEquals((int)expected, (int)this.retry.getInvocationCount(), (String)this.retry.toString());
    }

    protected void assertMinRetryCount(int minCount) {
        TestLambdaTestUtils.assertTrue((minCount <= this.retry.getInvocationCount() ? 1 : 0) != 0, (String)("retry count of " + this.retry + " is not >= " + minCount));
    }

    private boolean r(Exception e) throws Exception {
        throw e;
    }

    private boolean r(Error e) throws Exception {
        throw e;
    }

    @Test
    public void testAwaitAlwaysTrue() throws Throwable {
        LambdaTestUtils.await(50, ALWAYS_TRUE, new LambdaTestUtils.FixedRetryInterval(10), TIMEOUT_FAILURE_HANDLER);
    }

    @Test
    public void testAwaitAlwaysFalse() throws Throwable {
        try {
            LambdaTestUtils.await(50, ALWAYS_FALSE, this.retry, TIMEOUT_FAILURE_HANDLER);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (TimeoutException e) {
            this.assertMinRetryCount(1);
        }
    }

    @Test
    public void testAwaitLinearRetry() throws Throwable {
        LambdaTestUtils.ProportionalRetryInterval linearRetry = new LambdaTestUtils.ProportionalRetryInterval(20, 100);
        try {
            LambdaTestUtils.await(50, ALWAYS_FALSE, linearRetry, TIMEOUT_FAILURE_HANDLER);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (TimeoutException e) {
            TestLambdaTestUtils.assertEquals((int)2, (int)linearRetry.getInvocationCount(), (String)linearRetry.toString());
        }
    }

    @Test
    public void testAwaitFNFE() throws Throwable {
        try {
            LambdaTestUtils.await(50, ALWAYS_FNFE, this.retry, TIMEOUT_FAILURE_HANDLER);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (TimeoutException e) {
            TestLambdaTestUtils.assertTrue((this.retry.getInvocationCount() > 0 ? 1 : 0) != 0);
            TestLambdaTestUtils.assertTrue((boolean)(e.getCause() instanceof FileNotFoundException));
            GenericTestUtils.assertExceptionContains(MISSING, e);
        }
    }

    @Test
    public void testRetryInterval() throws Throwable {
        LambdaTestUtils.ProportionalRetryInterval interval = new LambdaTestUtils.ProportionalRetryInterval(200, 1000);
        TestLambdaTestUtils.assertEquals((int)200, (int)interval.call());
        TestLambdaTestUtils.assertEquals((int)400, (int)interval.call());
        TestLambdaTestUtils.assertEquals((int)600, (int)interval.call());
        TestLambdaTestUtils.assertEquals((int)800, (int)interval.call());
        TestLambdaTestUtils.assertEquals((int)1000, (int)interval.call());
        TestLambdaTestUtils.assertEquals((int)1000, (int)interval.call());
        TestLambdaTestUtils.assertEquals((int)1000, (int)interval.call());
    }

    @Test
    public void testInterceptSuccess() throws Throwable {
        IOException ioe = LambdaTestUtils.intercept(IOException.class, ALWAYS_FNFE);
        GenericTestUtils.assertExceptionContains(MISSING, ioe);
    }

    @Test
    public void testInterceptContains() throws Throwable {
        LambdaTestUtils.intercept(IOException.class, MISSING, ALWAYS_FNFE);
    }

    @Test
    public void testInterceptContainsWrongString() throws Throwable {
        try {
            FileNotFoundException e = LambdaTestUtils.intercept(FileNotFoundException.class, "404", ALWAYS_FNFE);
            TestLambdaTestUtils.assertNotNull((Object)e);
            throw e;
        }
        catch (AssertionError expected) {
            GenericTestUtils.assertExceptionContains(MISSING, (Throwable)((Object)expected));
            return;
        }
    }

    @Test
    public void testInterceptVoidCallable() throws Throwable {
        LambdaTestUtils.intercept(AssertionError.class, "(null)", new Callable<IOException>(){

            @Override
            public IOException call() throws Exception {
                return LambdaTestUtils.intercept(IOException.class, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        return null;
                    }
                });
            }
        });
    }

    @Test
    public void testEventually() throws Throwable {
        long result = LambdaTestUtils.eventually(50, EVAL_3L, (Callable<Integer>)this.retry);
        TestLambdaTestUtils.assertEquals((long)3L, (long)result);
        TestLambdaTestUtils.assertEquals((int)0, (int)this.retry.getInvocationCount());
    }

    @Test
    public void testEventuallyFailuresRetry() throws Throwable {
        try {
            LambdaTestUtils.eventually(50, EVAL_FNFE, (Callable<Integer>)this.retry);
            TestLambdaTestUtils.fail((String)"should not have got here");
        }
        catch (IOException expected) {
            this.assertMinRetryCount(1);
        }
    }

    @Test
    public void testInterceptFailure() throws Throwable {
        try {
            IOException ioe = LambdaTestUtils.intercept(IOException.class, () -> "hello");
            TestLambdaTestUtils.assertNotNull((Object)ioe);
            throw ioe;
        }
        catch (AssertionError expected) {
            GenericTestUtils.assertExceptionContains("hello", (Throwable)((Object)expected));
            return;
        }
    }

    @Test
    public void testInterceptInterceptLambda() throws Throwable {
        LambdaTestUtils.intercept(AssertionError.class, MISSING, () -> LambdaTestUtils.intercept(FileNotFoundException.class, "404", ALWAYS_FNFE));
    }

    @Test
    public void testInterceptInterceptVoidResultLambda() throws Throwable {
        LambdaTestUtils.intercept(AssertionError.class, "(null)", () -> LambdaTestUtils.intercept(IOException.class, () -> null));
    }

    @Test
    public void testInterceptInterceptStringResultLambda() throws Throwable {
        LambdaTestUtils.intercept(AssertionError.class, "hello, world", () -> LambdaTestUtils.intercept(IOException.class, () -> "hello, world"));
    }

    @Test
    public void testAwaitNoTimeoutLambda() throws Throwable {
        LambdaTestUtils.await(0, () -> true, this.retry, (timeout, ex) -> ex != null ? ex : new Exception("timeout"));
        this.assertRetryCount(0);
    }

    @Test
    public void testAwaitLambdaRepetitions() throws Throwable {
        this.count = 0;
        int reps = LambdaTestUtils.await(50, () -> ++this.count == 4, () -> 10, (timeout, ex) -> ex != null ? ex : new Exception("timeout"));
        TestLambdaTestUtils.assertEquals((int)4, (int)reps);
    }

    @Test
    public void testInterceptAwaitLambdaException() throws Throwable {
        this.count = 0;
        IOException ioe = LambdaTestUtils.intercept(IOException.class, () -> LambdaTestUtils.await(50, () -> this.r(new IOException("inner " + ++this.count)), this.retry, (timeout, ex) -> ex));
        this.assertRetryCount(this.count - 1);
        GenericTestUtils.assertExceptionContains(Integer.toString(this.count), ioe);
    }

    @Test
    public void testInterceptAwaitLambdaDiagnostics() throws Throwable {
        LambdaTestUtils.intercept(IOException.class, "generated", () -> LambdaTestUtils.await(5, () -> false, () -> -1, (timeout, ex) -> new IOException("generated")));
    }

    @Test
    public void testInterceptAwaitFailFastLambda() throws Throwable {
        LambdaTestUtils.intercept(LambdaTestUtils.FailFastException.class, () -> LambdaTestUtils.await(50, () -> this.r(new LambdaTestUtils.FailFastException("ffe")), this.retry, (timeout, ex) -> ex));
        this.assertRetryCount(0);
    }

    @Test
    public void testEventuallyOnceLambda() throws Throwable {
        String result = LambdaTestUtils.eventually(0, () -> "hello", (Callable<Integer>)this.retry);
        TestLambdaTestUtils.assertEquals((Object)"hello", (Object)result);
        TestLambdaTestUtils.assertEquals((int)0, (int)this.retry.getInvocationCount());
    }

    @Test
    public void testEventuallyLambda() throws Throwable {
        long result = LambdaTestUtils.eventually(50, () -> 3, (Callable<Integer>)this.retry).intValue();
        TestLambdaTestUtils.assertEquals((long)3L, (long)result);
        this.assertRetryCount(0);
    }

    @Test
    public void testInterceptEventuallyLambdaFailures() throws Throwable {
        LambdaTestUtils.intercept(IOException.class, "oops", () -> LambdaTestUtils.eventually(50, () -> this.r(new IOException("oops")), (Callable<Integer>)this.retry));
        this.assertMinRetryCount(1);
    }

    @Test
    public void testInterceptEventuallyambdaFailuresNegativeRetry() throws Throwable {
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> LambdaTestUtils.eventually(50, EVAL_FNFE, () -> -1));
    }

    @Test
    public void testInterceptEventuallyLambdaFailFast() throws Throwable {
        LambdaTestUtils.intercept(LambdaTestUtils.FailFastException.class, "oops", () -> LambdaTestUtils.eventually(50, () -> this.r(new LambdaTestUtils.FailFastException("oops")), (Callable<Integer>)this.retry));
        this.assertRetryCount(0);
    }

    @Test
    public void testEventuallySpinsOnAssertions() throws Throwable {
        AtomicInteger counter = new AtomicInteger(0);
        LambdaTestUtils.eventually(50, () -> {
            while (counter.incrementAndGet() < 5) {
                TestLambdaTestUtils.fail((String)"if you see this, we are in trouble");
            }
        }, (Callable<Integer>)this.retry);
        this.assertMinRetryCount(4);
    }

    @Test
    public void testInterceptEventuallyThrowsVMErrors() throws Throwable {
        LambdaTestUtils.intercept(OutOfMemoryError.class, "OOM", () -> LambdaTestUtils.eventually(50, () -> this.r(new OutOfMemoryError("OOM")), (Callable<Integer>)this.retry));
        this.assertRetryCount(0);
    }

    @Test
    public void testInterceptHandlesErrors() throws Throwable {
        LambdaTestUtils.intercept(OutOfMemoryError.class, "OOM", () -> this.r(new OutOfMemoryError("OOM")));
    }

    @Test
    public void testInterceptRethrowsVMErrors() throws Throwable {
        LambdaTestUtils.intercept(StackOverflowError.class, "", () -> LambdaTestUtils.intercept(OutOfMemoryError.class, "", () -> this.r(new StackOverflowError())));
    }

    @Test
    public void testAwaitHandlesAssertions() throws Throwable {
        TimeoutException ex = LambdaTestUtils.intercept(TimeoutException.class, "failure", () -> LambdaTestUtils.await(50, () -> this.r((Error)((Object)new AssertionError((Object)"failure"))), this.retry, TIMEOUT_FAILURE_HANDLER));
        this.assertMinRetryCount(1);
        if (!(ex.getCause() instanceof AssertionError)) {
            throw ex;
        }
    }

    @Test
    public void testAwaitRethrowsVMErrors() throws Throwable {
        LambdaTestUtils.intercept(StackOverflowError.class, () -> LambdaTestUtils.await(50, () -> this.r(new StackOverflowError()), this.retry, TIMEOUT_FAILURE_HANDLER));
        this.assertMinRetryCount(0);
    }

    @Test
    public void testEvalToSuccess() {
        TestLambdaTestUtils.assertTrue((boolean)LambdaTestUtils.eval(() -> true), (String)"Eval to success");
    }

    @Test
    public void testEvalDoesntWrapRTEs() throws Throwable {
        LambdaTestUtils.intercept(RuntimeException.class, "", () -> LambdaTestUtils.eval(() -> {
            throw new RuntimeException("t");
        }));
    }

    @Test
    public void testEvalDoesWrapIOEs() throws Throwable {
        LambdaTestUtils.verifyCause(IOException.class, (Throwable)((Object)LambdaTestUtils.intercept(AssertionError.class, "ioe", () -> LambdaTestUtils.eval(() -> {
            throw new IOException("ioe");
        }))));
    }

    @Test
    public void testInterceptFutureUnwrapped() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new IOException("oops"));
        LambdaTestUtils.interceptFuture(IOException.class, "oops", future);
    }

    @Test
    public void testInterceptFutureWrongException() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new RuntimeException("oops"));
        LambdaTestUtils.intercept(RuntimeException.class, "oops", () -> LambdaTestUtils.interceptFuture(IOException.class, "", future));
    }

    @Test
    public void testInterceptFutureNotAnException() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new Error("oops"));
        LambdaTestUtils.verifyCause(Error.class, LambdaTestUtils.intercept(ExecutionException.class, "oops", () -> LambdaTestUtils.interceptFuture(IOException.class, "", future)));
    }

    @Test
    public void testInterceptFutureNotAnException2() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new Error("oops"));
        LambdaTestUtils.verifyCause(Error.class, LambdaTestUtils.interceptFuture(ExecutionException.class, "", future));
    }

    @Test
    public void testInterceptFutureNoFailures() throws Throwable {
        CompletableFuture<String> future = new CompletableFuture<String>();
        future.complete("happy");
        LambdaTestUtils.intercept(AssertionError.class, "happy", () -> LambdaTestUtils.interceptFuture(IOException.class, "oops", future));
    }

    @Test
    public void testInterceptFutureTimeout() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        LambdaTestUtils.intercept(TimeoutException.class, "", () -> LambdaTestUtils.interceptFuture(IOException.class, "oops", 1L, TimeUnit.NANOSECONDS, future));
    }

    @Test
    public void testInterceptFutureTimeout2() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        LambdaTestUtils.interceptFuture(TimeoutException.class, "", 1L, TimeUnit.NANOSECONDS, future);
    }

    @Test
    public void testInterceptFutureTimeoutSuccess() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new IOException("oops"));
        LambdaTestUtils.interceptFuture(IOException.class, "oops", 1L, TimeUnit.NANOSECONDS, future);
    }

    @Test
    public void testInterceptFutureCancelled() throws Throwable {
        CompletableFuture future = new CompletableFuture();
        future.cancel(false);
        LambdaTestUtils.interceptFuture(CancellationException.class, "", 1L, TimeUnit.NANOSECONDS, future);
    }
}

