/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.function.Supplier;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestGenericTestUtils
extends GenericTestUtils {
    @Test
    public void testAssertExceptionContainsNullEx() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", null);
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains("Null Throwable")) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsNullString() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", new BrokenException());
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains("Null Throwable.toString() value")) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWrongText() throws Throwable {
        block3: {
            try {
                TestGenericTestUtils.assertExceptionContains("Expected", new Exception("(actual)"));
            }
            catch (AssertionError e) {
                String s = ((Throwable)((Object)e)).toString();
                if (!s.contains("but got unexpected exception") || !s.contains("(actual)")) {
                    throw e;
                }
                if (((Throwable)((Object)e)).getCause() != null) break block3;
                throw new AssertionError("No nested cause in assertion", (Throwable)((Object)e));
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWorking() throws Throwable {
        TestGenericTestUtils.assertExceptionContains("Expected", new Exception("Expected"));
    }

    @Test
    @Timeout(value=10L)
    public void testLogCapturer() {
        Logger log = LoggerFactory.getLogger(TestGenericTestUtils.class);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs(log);
        String infoMessage = "info message";
        log.info("info message");
        Assertions.assertTrue((boolean)logCapturer.getOutput().endsWith(String.format("info message%n", new Object[0])));
        logCapturer.clearOutput();
        Assertions.assertTrue((boolean)logCapturer.getOutput().isEmpty());
        logCapturer.stopCapturing();
        log.info("info message");
        Assertions.assertTrue((boolean)logCapturer.getOutput().isEmpty());
    }

    @Test
    @Timeout(value=10L)
    public void testLogCapturerSlf4jLogger() {
        Logger logger = LoggerFactory.getLogger(TestGenericTestUtils.class);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs(logger);
        String infoMessage = "info message";
        logger.info("info message");
        Assertions.assertTrue((boolean)logCapturer.getOutput().endsWith(String.format("info message%n", new Object[0])));
        logCapturer.clearOutput();
        Assertions.assertTrue((boolean)logCapturer.getOutput().isEmpty());
        logCapturer.stopCapturing();
        logger.info("info message");
        Assertions.assertTrue((boolean)logCapturer.getOutput().isEmpty());
    }

    @Test
    public void testWaitingForConditionWithInvalidParams() throws Throwable {
        try {
            TestGenericTestUtils.waitFor(null, 0L, 0L);
        }
        catch (NullPointerException e) {
            TestGenericTestUtils.assertExceptionContains("Input supplier interface should be initailized", e);
        }
        Supplier<Boolean> simpleSupplier = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return true;
            }
        };
        TestGenericTestUtils.waitFor(simpleSupplier, 5L, 10L);
        try {
            TestGenericTestUtils.waitFor(simpleSupplier, 10L, 5L);
            Assertions.fail((String)"Excepted a failure when the param value of waitForMillis is smaller than checkEveryMillis.");
        }
        catch (IllegalArgumentException e) {
            TestGenericTestUtils.assertExceptionContains("Total wait time should be greater than check interval time", e);
        }
    }

    @Test
    public void testToLevel() throws Throwable {
        Assertions.assertEquals((Object)Level.INFO, (Object)TestGenericTestUtils.toLevel("INFO"));
        Assertions.assertEquals((Object)Level.DEBUG, (Object)TestGenericTestUtils.toLevel("NonExistLevel"));
        Assertions.assertEquals((Object)Level.INFO, (Object)TestGenericTestUtils.toLevel("INFO", Level.TRACE));
        Assertions.assertEquals((Object)Level.TRACE, (Object)TestGenericTestUtils.toLevel("NonExistLevel", Level.TRACE));
    }

    private static class BrokenException
    extends Exception {
        @Override
        public String toString() {
            return null;
        }
    }
}

