/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public class MoreAsserts {
    public static <T> void assertEquals(String s, T[] expected, Iterable<T> actual) {
        int i;
        Iterator<T> it = actual.iterator();
        for (i = 0; i < expected.length && it.hasNext(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals(expected[i], it.next(), (String)("Element " + i + " for " + s));
        }
        org.junit.jupiter.api.Assertions.assertTrue((i == expected.length ? 1 : 0) != 0, (String)"Expected more elements");
        org.junit.jupiter.api.Assertions.assertTrue((!it.hasNext() ? 1 : 0) != 0, (String)"Expected less elements");
    }

    public static <T> void assertEquals(String s, Iterable<T> expected, Iterable<T> actual) {
        Iterator<T> ite = expected.iterator();
        Iterator<T> ita = actual.iterator();
        int i = 0;
        while (ite.hasNext() && ita.hasNext()) {
            org.junit.jupiter.api.Assertions.assertEquals(ite.next(), ita.next(), (String)("Element " + i + " for " + s));
        }
        org.junit.jupiter.api.Assertions.assertTrue((!ite.hasNext() ? 1 : 0) != 0, (String)"Expected more elements");
        org.junit.jupiter.api.Assertions.assertTrue((!ita.hasNext() ? 1 : 0) != 0, (String)"Expected less elements");
    }

    public static <T> void assertFutureCompletedSuccessfully(CompletableFuture<T> future) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)future.isDone()).describedAs("This future is supposed to be completed successfully", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)future.isCompletedExceptionally()).describedAs("This future is supposed to be completed successfully", new Object[0])).isFalse();
    }

    public static <T> void assertFutureFailedExceptionally(CompletableFuture<T> future) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)future.isCompletedExceptionally()).describedAs("This future is supposed to be completed exceptionally", new Object[0])).isTrue();
    }

    public static <T> void assertEqual(T actual, T expected, String message) {
        ((ObjectAssert)Assertions.assertThat(actual).describedAs("Mismatch in %s", new Object[]{message})).isEqualTo(expected);
    }
}

