/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.launcher.AbstractServiceLauncherTestBase;
import org.apache.hadoop.service.launcher.ServiceLauncher;
import org.apache.hadoop.service.launcher.testservices.ExceptionInExecuteLaunchableService;
import org.apache.hadoop.service.launcher.testservices.LaunchableRunningService;
import org.apache.hadoop.service.launcher.testservices.NoArgsAllowedService;
import org.junit.jupiter.api.Test;

public class TestServiceLauncherInnerMethods
extends AbstractServiceLauncherTestBase {
    @Test
    public void testLaunchService() throws Throwable {
        ServiceLauncher launcher = this.launchService(NoArgsAllowedService.class, new Configuration(), new String[0]);
        NoArgsAllowedService service = (NoArgsAllowedService)launcher.getService();
        TestServiceLauncherInnerMethods.assertNotNull((Object)((Object)service), (String)("null service from " + launcher));
        service.stop();
    }

    @Test
    public void testLaunchServiceArgs() throws Throwable {
        this.launchExpectingException(NoArgsAllowedService.class, new Configuration(), "arguments", 40, "one", "two");
    }

    @Test
    public void testAccessLaunchedService() throws Throwable {
        ServiceLauncher launcher = this.launchService(LaunchableRunningService.class, new Configuration(), new String[0]);
        LaunchableRunningService service = (LaunchableRunningService)launcher.getService();
        this.assertInState((Service)service, Service.STATE.STARTED);
        service.failInRun = true;
        service.setExitCode(48);
        TestServiceLauncherInnerMethods.assertEquals((int)48, (int)service.execute());
    }

    @Test
    public void testLaunchThrowableRaised() throws Throwable {
        this.launchExpectingException(ExceptionInExecuteLaunchableService.class, new Configuration(), "java.lang.OutOfMemoryError", 50, "--throwable");
    }

    @Test
    public void testBreakableServiceLifecycle() throws Throwable {
        ServiceLauncher launcher = this.launchService(BreakableService.class, new Configuration(), new String[0]);
        BreakableService service = (BreakableService)launcher.getService();
        TestServiceLauncherInnerMethods.assertNotNull((Object)((Object)service), (String)("null service from " + launcher));
        service.stop();
    }

    @Test
    public void testConfigLoading() throws Throwable {
        ServiceLauncher launcher = new ServiceLauncher("BreakableService");
        List configurationsToCreate = launcher.getConfigurationsToCreate();
        TestServiceLauncherInnerMethods.assertTrue((configurationsToCreate.size() > 1 ? 1 : 0) != 0);
        int created = launcher.loadConfigurationClasses();
        TestServiceLauncherInnerMethods.assertEquals((int)1, (int)created);
    }
}

