/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.BreakableStateChangeListener;
import org.apache.hadoop.service.LoggingStateChangeListener;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceAssert;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class TestGlobalStateChangeListener
extends ServiceAssert {
    BreakableStateChangeListener listener = new BreakableStateChangeListener("listener");

    private void register() {
        this.register(this.listener);
    }

    private boolean unregister() {
        return this.unregister(this.listener);
    }

    private void register(ServiceStateChangeListener l) {
        AbstractService.registerGlobalListener((ServiceStateChangeListener)l);
    }

    private boolean unregister(ServiceStateChangeListener l) {
        return AbstractService.unregisterGlobalListener((ServiceStateChangeListener)l);
    }

    @AfterEach
    public void cleanup() {
        AbstractService.resetGlobalListeners();
    }

    public void assertListenerState(BreakableStateChangeListener breakable, Service.STATE state) {
        TestGlobalStateChangeListener.assertEquals((Object)state, (Object)breakable.getLastState(), (String)("Wrong state in " + breakable));
    }

    public void assertListenerEventCount(BreakableStateChangeListener breakable, int count) {
        TestGlobalStateChangeListener.assertEquals((int)count, (int)breakable.getEventCount(), (String)("Wrong event count in " + breakable));
    }

    @Test
    public void testRegisterListener() {
        this.register();
        TestGlobalStateChangeListener.assertTrue((boolean)this.unregister(), (String)"listener not registered");
    }

    @Test
    public void testRegisterListenerTwice() {
        this.register();
        this.register();
        TestGlobalStateChangeListener.assertTrue((boolean)this.unregister(), (String)"listener not registered");
        TestGlobalStateChangeListener.assertFalse((boolean)this.unregister(), (String)"listener double registered");
    }

    @Test
    public void testEventHistory() {
        this.register();
        BreakableService service = new BreakableService();
        this.assertListenerState(this.listener, Service.STATE.NOTINITED);
        TestGlobalStateChangeListener.assertEquals((int)0, (int)this.listener.getEventCount());
        service.init(new Configuration());
        this.assertListenerState(this.listener, Service.STATE.INITED);
        TestGlobalStateChangeListener.assertSame((Object)((Object)service), (Object)this.listener.getLastService());
        this.assertListenerEventCount(this.listener, 1);
        service.start();
        this.assertListenerState(this.listener, Service.STATE.STARTED);
        this.assertListenerEventCount(this.listener, 2);
        service.stop();
        this.assertListenerState(this.listener, Service.STATE.STOPPED);
        this.assertListenerEventCount(this.listener, 3);
    }

    @Test
    public void testListenerFailure() {
        this.listener.setFailingState(Service.STATE.INITED);
        this.register();
        BreakableStateChangeListener l2 = new BreakableStateChangeListener();
        this.register(l2);
        BreakableService service = new BreakableService();
        service.init(new Configuration());
        this.assertListenerState(this.listener, Service.STATE.INITED);
        this.assertListenerEventCount(this.listener, 1);
        this.assertListenerEventCount(l2, 0);
        TestGlobalStateChangeListener.assertServiceStateInited((Service)service);
        service.start();
        service.stop();
    }

    @Test
    public void testListenerChain() {
        LoggingStateChangeListener logListener = new LoggingStateChangeListener();
        this.register((ServiceStateChangeListener)logListener);
        BreakableStateChangeListener l0 = new BreakableStateChangeListener("l0");
        this.register(l0);
        this.listener.setFailingState(Service.STATE.STARTED);
        this.register();
        BreakableStateChangeListener l3 = new BreakableStateChangeListener("l3");
        this.register(l3);
        BreakableService service = new BreakableService();
        service.init(new Configuration());
        TestGlobalStateChangeListener.assertServiceStateInited((Service)service);
        this.assertListenerState(l0, Service.STATE.INITED);
        this.assertListenerState(this.listener, Service.STATE.INITED);
        this.assertListenerState(l3, Service.STATE.INITED);
        service.start();
        TestGlobalStateChangeListener.assertServiceStateStarted((Service)service);
        this.assertListenerState(l0, Service.STATE.STARTED);
        this.assertListenerEventCount(l0, 2);
        this.assertListenerState(this.listener, Service.STATE.STARTED);
        this.assertListenerEventCount(this.listener, 2);
        this.assertListenerState(l3, Service.STATE.INITED);
        this.assertListenerEventCount(l3, 1);
        service.stop();
        this.assertListenerEventCount(l0, 3);
        this.assertListenerEventCount(this.listener, 3);
        this.assertListenerEventCount(l3, 2);
        this.unregister((ServiceStateChangeListener)logListener);
        this.unregister(l0);
        this.unregister(l3);
        service = new BreakableService();
        service.init(new Configuration());
        this.assertListenerEventCount(l0, 3);
        this.assertListenerEventCount(l3, 2);
        this.assertListenerEventCount(this.listener, 4);
    }
}

