/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.Service;
import org.junit.jupiter.api.Assertions;

public class ServiceAssert
extends Assertions {
    public static void assertServiceStateCreated(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.NOTINITED);
    }

    public static void assertServiceStateInited(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.INITED);
    }

    public static void assertServiceStateStarted(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.STARTED);
    }

    public static void assertServiceStateStopped(Service service) {
        ServiceAssert.assertServiceInState(service, Service.STATE.STOPPED);
    }

    public static void assertServiceInState(Service service, Service.STATE state) {
        ServiceAssert.assertNotNull((Object)service, (String)"Null service");
        ServiceAssert.assertEquals((Object)state, (Object)service.getServiceState(), (String)("Service in wrong state: " + service));
    }

    public static void assertStateCount(BreakableService service, Service.STATE state, int expected) {
        ServiceAssert.assertNotNull((Object)((Object)service), (String)"Null service");
        int actual = service.getCount(state);
        if (expected != actual) {
            ServiceAssert.fail((String)("Expected entry count for state [" + state + "] of " + (Object)((Object)service) + " to be " + expected + " but was " + actual));
        }
    }

    public static void assertServiceConfigurationContains(Service service, String key) {
        ServiceAssert.assertNotNull((Object)service.getConfig().get(key), (String)("No option " + key + " in service configuration"));
    }
}

