/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestDelegationTokenManager {
    private static final long DAY_IN_SECS = 86400L;
    private boolean enableZKKey;

    public static Collection<Object[]> headers() {
        return Arrays.asList({false}, {true});
    }

    public void initTestDelegationTokenManager(boolean pEnableZKKey) {
        this.enableZKKey = pEnableZKKey;
    }

    @ParameterizedTest
    @MethodSource(value={"headers"})
    public void testDTManager(boolean pEnableZKKey) throws Exception {
        this.initTestDelegationTokenManager(pEnableZKKey);
        Configuration conf = new Configuration(false);
        conf.setLong("delegation-token.update-interval.sec", 86400L);
        conf.setLong("delegation-token.max-lifetime.sec", 86400L);
        conf.setLong("delegation-token.renew-interval.sec", 86400L);
        conf.setLong("delegation-token.removal-scan-interval.sec", 86400L);
        conf.getBoolean("zk-dt-secret-manager.enable", this.enableZKKey);
        DelegationTokenManager tm = new DelegationTokenManager(conf, new Text("foo"));
        tm.init();
        Token token = tm.createToken(UserGroupInformation.getCurrentUser(), "foo");
        Assertions.assertNotNull((Object)token);
        tm.verifyToken(token);
        Assertions.assertTrue((tm.renewToken(token, "foo") > System.currentTimeMillis() ? 1 : 0) != 0);
        tm.cancelToken(token, "foo");
        try {
            tm.verifyToken(token);
            Assertions.fail();
        }
        catch (IOException iOException) {
        }
        catch (Exception ex) {
            Assertions.fail();
        }
        tm.destroy();
    }
}

