/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.DtUtilShell;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestDtUtilShell {
    private static byte[] IDENTIFIER = new byte[]{105, 100, 101, 110, 116, 105, 102, 105, 101, 114};
    private static byte[] PASSWORD = new byte[]{112, 97, 115, 115, 119, 111, 114, 100};
    private static Text KIND = new Text("testTokenKind");
    private static Text SERVICE = new Text("testTokenService");
    private static Text SERVICE2 = new Text("ecivreSnekoTtset");
    private static Configuration defaultConf = new Configuration();
    private static FileSystem localFs = null;
    private final String alias = "proxy_ip:1234";
    private final String getUrl = SERVICE_GET.toString() + "://localhost:9000/";
    private final String getUrl2 = "http://localhost:9000/";
    public static Text SERVICE_GET = new Text("testTokenServiceGet");
    public static Text KIND_GET = new Text("testTokenKindGet");
    public static Token<?> MOCK_TOKEN = new Token(IDENTIFIER, PASSWORD, KIND_GET, SERVICE_GET);
    private static final Text SERVICE_IMPORT = new Text("testTokenServiceImport");
    private static final Text KIND_IMPORT = new Text("testTokenKindImport");
    private static final Token<?> IMPORT_TOKEN = new Token(IDENTIFIER, PASSWORD, KIND_IMPORT, SERVICE_IMPORT);
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final Path workDir = new Path(GenericTestUtils.getTestDir("TestDtUtilShell").getAbsolutePath());
    private final Path tokenFile = new Path(this.workDir, "testPrintTokenFile");
    private final Path tokenFile2 = new Path(this.workDir, "testPrintTokenFile2");
    private final Path tokenLegacyFile = new Path(this.workDir, "testPrintTokenFile3");
    private final Path tokenFileGet = new Path(this.workDir, "testGetTokenFile");
    private final Path tokenFileImport = new Path(this.workDir, "testImportTokenFile");
    private final String tokenFilename = this.tokenFile.toString();
    private final String tokenFilename2 = this.tokenFile2.toString();
    private final String tokenFilenameGet = this.tokenFileGet.toString();
    private final String tokenFilenameImport = this.tokenFileImport.toString();
    private String[] args = null;
    private DtUtilShell dt = null;
    private int rc = 0;

    @BeforeEach
    public void setup() throws Exception {
        localFs.mkdirs(localFs.makeQualified(this.workDir));
        this.makeTokenFile(this.tokenFile, false, null);
        this.makeTokenFile(this.tokenFile2, false, SERVICE2);
        this.makeTokenFile(this.tokenLegacyFile, true, null);
        this.dt = new DtUtilShell();
        this.dt.setConf(new Configuration());
        this.dt.setOut(new PrintStream(this.outContent));
        this.outContent.reset();
        this.rc = 0;
    }

    @AfterEach
    public void teardown() throws Exception {
        localFs.delete(localFs.makeQualified(this.workDir), true);
    }

    public void makeTokenFile(Path tokenPath, boolean legacy, Text service) throws IOException {
        if (service == null) {
            service = SERVICE;
        }
        Credentials creds = new Credentials();
        Token tok = new Token(IDENTIFIER, PASSWORD, KIND, service);
        creds.addToken(tok.getService(), tok);
        Credentials.SerializedFormat format = Credentials.SerializedFormat.PROTOBUF;
        if (legacy) {
            format = Credentials.SerializedFormat.WRITABLE;
        }
        creds.writeTokenStorageFile(tokenPath, defaultConf, format);
    }

    @Test
    public void testPrint() throws Exception {
        this.args = new String[]{"print", this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple print exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test simple print output kind:\n" + this.outContent.toString()));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(SERVICE.toString()), (String)("test simple print output service:\n" + this.outContent.toString()));
        this.outContent.reset();
        this.args = new String[]{"print", this.tokenLegacyFile.toString()};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test legacy print exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test simple print output kind:\n" + this.outContent.toString()));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(SERVICE.toString()), (String)("test simple print output service:\n" + this.outContent.toString()));
        this.outContent.reset();
        this.args = new String[]{"print", "-alias", SERVICE.toString(), this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test alias print exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test simple print output kind:\n" + this.outContent.toString()));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(SERVICE.toString()), (String)("test simple print output service:\n" + this.outContent.toString()));
        this.outContent.reset();
        this.args = new String[]{"print", "-alias", "not-a-serivce", this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test no alias print exit code");
        Assertions.assertFalse((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test no alias print output kind:\n" + this.outContent.toString()));
        Assertions.assertFalse((boolean)this.outContent.toString().contains(SERVICE.toString()), (String)("test no alias print output service:\n" + this.outContent.toString()));
    }

    @Test
    public void testEdit() throws Exception {
        String oldService = SERVICE2.toString();
        String newAlias = "newName:12345";
        this.args = new String[]{"edit", "-service", oldService, "-alias", newAlias, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple edit exit code");
        this.args = new String[]{"print", "-alias", oldService, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple edit print old exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test simple edit output kind old:\n" + this.outContent.toString()));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(oldService), (String)("test simple edit output service old:\n" + this.outContent.toString()));
        this.args = new String[]{"print", "-alias", newAlias, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple edit print new exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test simple edit output kind new:\n" + this.outContent.toString()));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(newAlias), (String)("test simple edit output service new:\n" + this.outContent.toString()));
    }

    @Test
    public void testAppend() throws Exception {
        this.args = new String[]{"append", this.tokenFilename, this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple append exit code");
        this.args = new String[]{"print", this.tokenFilename2};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple append print exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test simple append output kind:\n" + this.outContent.toString()));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(SERVICE.toString()), (String)("test simple append output service:\n" + this.outContent.toString()));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(SERVICE2.toString()), (String)("test simple append output service:\n" + this.outContent.toString()));
    }

    @Test
    public void testRemove() throws Exception {
        this.args = new String[]{"remove", "-alias", SERVICE.toString(), this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple remove exit code");
        this.args = new String[]{"print", this.tokenFilename};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple remove print exit code");
        Assertions.assertFalse((boolean)this.outContent.toString().contains(KIND.toString()), (String)("test simple remove output kind:\n" + this.outContent.toString()));
        Assertions.assertFalse((boolean)this.outContent.toString().contains(SERVICE.toString()), (String)("test simple remove output service:\n" + this.outContent.toString()));
    }

    @Test
    public void testGet() throws Exception {
        this.args = new String[]{"get", this.getUrl, this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test mocked get exit code");
        this.args = new String[]{"print", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        String oc = this.outContent.toString();
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test print after get exit code");
        Assertions.assertTrue((boolean)oc.contains(KIND_GET.toString()), (String)("test print after get output kind:\n" + oc));
        Assertions.assertTrue((boolean)oc.contains(SERVICE_GET.toString()), (String)("test print after get output service:\n" + oc));
    }

    @Test
    public void testGetWithServiceFlag() throws Exception {
        this.args = new String[]{"get", "http://localhost:9000/", "-service", SERVICE_GET.toString(), this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test mocked get with service flag exit code");
        this.args = new String[]{"print", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        String oc = this.outContent.toString();
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test print after get with service flag exit code");
        Assertions.assertTrue((boolean)oc.contains(KIND_GET.toString()), (String)("test print after get with service flag output kind:\n" + oc));
        Assertions.assertTrue((boolean)oc.contains(SERVICE_GET.toString()), (String)("test print after get with service flag output service:\n" + oc));
    }

    @Test
    public void testGetWithAliasFlag() throws Exception {
        this.args = new String[]{"get", this.getUrl, "-alias", "proxy_ip:1234", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test mocked get with alias flag exit code");
        this.args = new String[]{"print", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        String oc = this.outContent.toString();
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test print after get with alias flag exit code");
        Assertions.assertTrue((boolean)oc.contains(KIND_GET.toString()), (String)("test print after get with alias flag output kind:\n" + oc));
        Assertions.assertTrue((boolean)oc.contains("proxy_ip:1234"), (String)("test print after get with alias flag output alias:\n" + oc));
        Assertions.assertFalse((boolean)oc.contains(SERVICE_GET.toString()), (String)("test print after get with alias flag output old service:\n" + oc));
    }

    @Test
    public void testFormatJavaFlag() throws Exception {
        this.args = new String[]{"get", this.getUrl, "-format", "java", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test mocked get with java format flag exit code");
        Credentials creds = new Credentials();
        Credentials spyCreds = (Credentials)Mockito.spy((Object)creds);
        DataInputStream in = new DataInputStream(new FileInputStream(this.tokenFilenameGet));
        spyCreds.readTokenStorageStream(in);
        ((Credentials)Mockito.verify((Object)spyCreds)).readFields((DataInput)in);
    }

    @Test
    public void testFormatProtoFlag() throws Exception {
        this.args = new String[]{"get", this.getUrl, "-format", "protobuf", this.tokenFilenameGet};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test mocked get with protobuf format flag exit code");
        Credentials creds = new Credentials();
        Credentials spyCreds = (Credentials)Mockito.spy((Object)creds);
        DataInputStream in = new DataInputStream(new FileInputStream(this.tokenFilenameGet));
        spyCreds.readTokenStorageStream(in);
        ((Credentials)Mockito.verify((Object)spyCreds, (VerificationMode)Mockito.never())).readFields((DataInput)in);
    }

    @Test
    public void testImport() throws Exception {
        String base64 = IMPORT_TOKEN.encodeToUrlString();
        this.args = new String[]{"import", base64, this.tokenFilenameImport};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple import print old exit code");
        this.args = new String[]{"print", this.tokenFilenameImport};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple import print old exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND_IMPORT.toString()), (String)("test print after import output:\n" + this.outContent));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(SERVICE_IMPORT.toString()), (String)("test print after import output:\n" + this.outContent));
        Assertions.assertTrue((boolean)this.outContent.toString().contains(base64), (String)("test print after simple import output:\n" + this.outContent));
    }

    @Test
    public void testImportWithAliasFlag() throws Exception {
        String base64 = IMPORT_TOKEN.encodeToUrlString();
        this.args = new String[]{"import", base64, "-alias", "proxy_ip:1234", this.tokenFilenameImport};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test import with alias print old exit code");
        this.args = new String[]{"print", this.tokenFilenameImport};
        this.rc = this.dt.run(this.args);
        Assertions.assertEquals((int)0, (int)this.rc, (String)"test simple import print old exit code");
        Assertions.assertTrue((boolean)this.outContent.toString().contains(KIND_IMPORT.toString()), (String)("test print after import output:\n" + this.outContent));
        Assertions.assertTrue((boolean)this.outContent.toString().contains("proxy_ip:1234"), (String)("test print after import with alias output:\n" + this.outContent));
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }
}

