/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.TestRPC;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.security.token.TokenInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestServiceAuthorization {
    private static final String ACL_CONFIG = "test.protocol.acl";
    private static final String ACL_CONFIG1 = "test.protocol1.acl";
    private static final String ADDRESS = "0.0.0.0";
    private static final String HOST_CONFIG = "test.protocol.hosts";
    private static final String BLOCKED_HOST_CONFIG = "test.protocol.hosts.blocked";
    private static final String AUTHORIZED_IP = "1.2.3.4";
    private static final String UNAUTHORIZED_IP = "1.2.3.5";
    private static final String IP_RANGE = "10.222.0.0/16,10.113.221.221";

    @Test
    public void testWithClientPrincipalOnUnsecureMode() throws UnknownHostException {
        UserGroupInformation hdfsUser = UserGroupInformation.createUserForTesting((String)"hdfs", (String[])new String[]{"hadoop"});
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        SecurityUtil.setSecurityInfoProviders((SecurityInfo[])new SecurityInfo[]{new CustomSecurityInfo()});
        Configuration conf = new Configuration();
        conf.set("dfs.datanode.kerberos.principal", "dn/_HOST@EXAMPLE.COM");
        conf.set(ACL_CONFIG, "user1 hadoop");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(hdfsUser, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
    }

    @Test
    public void testDefaultAcl() {
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        conf.set(ACL_CONFIG, "user1 group1");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        AccessControlList acl = serviceAuthorizationManager.getProtocolsAcls(TestRPC.TestProtocol.class);
        Assertions.assertEquals((Object)"user1 group1", (Object)acl.getAclString());
        acl = serviceAuthorizationManager.getProtocolsAcls(TestProtocol1.class);
        Assertions.assertEquals((Object)"*", (Object)acl.getAclString());
        conf.set("security.service.authorization.default.acl", "user2 group2");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        acl = serviceAuthorizationManager.getProtocolsAcls(TestRPC.TestProtocol.class);
        Assertions.assertEquals((Object)"user1 group1", (Object)acl.getAclString());
        acl = serviceAuthorizationManager.getProtocolsAcls(TestProtocol1.class);
        Assertions.assertEquals((Object)"user2 group2", (Object)acl.getAclString());
    }

    @Test
    public void testBlockedAcl() throws UnknownHostException {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@EXAMPLE.COM", (String[])new String[]{"group1", "group2"});
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        conf.set(ACL_CONFIG, "user1 group1");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        conf.set("test.protocol.acl.blocked", "drwho2 group3");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        conf.set("test.protocol.acl.blocked", "drwho group3");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
            Assertions.fail();
        }
        catch (AuthorizationException e) {
            // empty catch block
        }
        conf.set("test.protocol.acl.blocked", "drwho2 group3");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        conf.set("test.protocol.acl.blocked", "drwho2 group2");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
            Assertions.fail();
        }
        catch (AuthorizationException e) {
            // empty catch block
        }
        conf.set("test.protocol.acl.blocked", "");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
    }

    @Test
    public void testDefaultBlockedAcl() throws UnknownHostException {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@EXAMPLE.COM", (String[])new String[]{"group1", "group2"});
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestProtocol1.class, conf, InetAddress.getByName(ADDRESS));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        conf.set("security.service.authorization.default.acl.blocked", "user2 group2");
        conf.set("test.protocol.acl.blocked", "user2");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(ADDRESS));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        try {
            serviceAuthorizationManager.authorize(drwho, TestProtocol1.class, conf, InetAddress.getByName(ADDRESS));
            Assertions.fail();
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testMachineList() throws UnknownHostException {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@EXAMPLE.COM", (String[])new String[]{"group1", "group2"});
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        conf.set(HOST_CONFIG, AUTHORIZED_IP);
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(AUTHORIZED_IP));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(UNAUTHORIZED_IP));
            Assertions.fail();
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultMachineList() throws UnknownHostException {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@EXAMPLE.COM", (String[])new String[]{"group1", "group2"});
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(UNAUTHORIZED_IP));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        conf.set("security.service.authorization.default.hosts", IP_RANGE);
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(UNAUTHORIZED_IP));
            Assertions.fail();
        }
        catch (AuthorizationException e) {
            // empty catch block
        }
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName("10.222.0.0"));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
    }

    @Test
    public void testBlockedMachineList() throws UnknownHostException {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@EXAMPLE.COM", (String[])new String[]{"group1", "group2"});
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName("10.222.0.0"));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        conf.set(BLOCKED_HOST_CONFIG, IP_RANGE);
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName("10.222.0.0"));
            Assertions.fail();
        }
        catch (AuthorizationException e) {
            // empty catch block
        }
        conf.set(BLOCKED_HOST_CONFIG, "");
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName("10.222.0.0"));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
    }

    @Test
    public void testDefaultBlockedMachineList() throws UnknownHostException {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@EXAMPLE.COM", (String[])new String[]{"group1", "group2"});
        ServiceAuthorizationManager serviceAuthorizationManager = new ServiceAuthorizationManager();
        Configuration conf = new Configuration();
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestProtocol1.class, conf, InetAddress.getByName("10.222.0.0"));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        conf.set("security.service.authorization.default.hosts.blocked", IP_RANGE);
        conf.set(BLOCKED_HOST_CONFIG, AUTHORIZED_IP);
        serviceAuthorizationManager.refresh(conf, (PolicyProvider)new TestPolicyProvider());
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName("10.222.0.0"));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        try {
            serviceAuthorizationManager.authorize(drwho, TestRPC.TestProtocol.class, conf, InetAddress.getByName(AUTHORIZED_IP));
            Assertions.fail();
        }
        catch (AuthorizationException e) {
            // empty catch block
        }
        try {
            serviceAuthorizationManager.authorize(drwho, TestProtocol1.class, conf, InetAddress.getByName(AUTHORIZED_IP));
        }
        catch (AuthorizationException e) {
            Assertions.fail();
        }
        try {
            serviceAuthorizationManager.authorize(drwho, TestProtocol1.class, conf, InetAddress.getByName("10.222.0.0"));
            Assertions.fail();
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    private static class CustomSecurityInfo
    extends SecurityInfo {
        private CustomSecurityInfo() {
        }

        public KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
            return new KerberosInfo(){

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public String serverPrincipal() {
                    return null;
                }

                public String clientPrincipal() {
                    return "dfs.datanode.kerberos.principal";
                }
            };
        }

        public TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
            return null;
        }
    }

    private static class TestPolicyProvider
    extends PolicyProvider {
        private TestPolicyProvider() {
        }

        public Service[] getServices() {
            return new Service[]{new Service(TestServiceAuthorization.ACL_CONFIG, TestRPC.TestProtocol.class), new Service(TestServiceAuthorization.ACL_CONFIG1, TestProtocol1.class)};
        }
    }

    public static interface TestProtocol1
    extends TestRPC.TestProtocol {
    }
}

