/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.hadoop.security.alias.JavaKeyStoreProvider;
import org.apache.hadoop.security.alias.UserProvider;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCredentialProviderFactory {
    public static final Logger LOG = LoggerFactory.getLogger(TestCredentialProviderFactory.class);
    private static char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final File tmpDir = GenericTestUtils.getTestDir("creds");

    @BeforeEach
    public void announce(TestInfo testInfo) {
        LOG.info("Running test " + testInfo.getDisplayName());
    }

    @Test
    public void testFactory() throws Exception {
        Configuration conf = new Configuration();
        String userUri = "user:///";
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        String jksUri = "jceks://file" + jksPath.toUri();
        conf.set("hadoop.security.credential.provider.path", "user:///," + jksUri);
        List providers = CredentialProviderFactory.getProviders((Configuration)conf);
        Assertions.assertEquals((int)2, (int)providers.size());
        Assertions.assertEquals(UserProvider.class, ((CredentialProvider)providers.get(0)).getClass());
        Assertions.assertEquals(JavaKeyStoreProvider.class, ((CredentialProvider)providers.get(1)).getClass());
        Assertions.assertEquals((Object)"user:///", (Object)((CredentialProvider)providers.get(0)).toString());
        Assertions.assertEquals((Object)jksUri, (Object)((CredentialProvider)providers.get(1)).toString());
    }

    @Test
    public void testFactoryErrors() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.credential.provider.path", "unknown:///");
        try {
            List providers = CredentialProviderFactory.getProviders((Configuration)conf);
            Assertions.assertTrue((boolean)false, (String)"should throw!");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"No CredentialProviderFactory for unknown:/// in hadoop.security.credential.provider.path", (Object)e.getMessage());
        }
    }

    @Test
    public void testUriErrors() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.credential.provider.path", "unkn@own:/x/y");
        try {
            List providers = CredentialProviderFactory.getProviders((Configuration)conf);
            Assertions.assertTrue((boolean)false, (String)"should throw!");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Bad configuration of hadoop.security.credential.provider.path at unkn@own:/x/y", (Object)e.getMessage());
        }
    }

    private static char[] generatePassword(int length) {
        StringBuilder sb = new StringBuilder();
        Random r = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(chars[r.nextInt(chars.length)]);
        }
        return sb.toString().toCharArray();
    }

    static void checkSpecificProvider(Configuration conf, String ourUrl) throws Exception {
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] passwd = TestCredentialProviderFactory.generatePassword(16);
        Assertions.assertEquals(null, (Object)provider.getCredentialEntry("no-such-key"));
        Assertions.assertEquals(null, (Object)provider.getCredentialEntry("key"));
        try {
            provider.createCredentialEntry("pass", passwd);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        Assertions.assertArrayEquals((char[])passwd, (char[])provider.getCredentialEntry("pass").getCredential());
        try {
            provider.createCredentialEntry("pass", passwd);
            Assertions.assertTrue((boolean)false, (String)"should throw");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Credential pass already exists in " + ourUrl), (Object)e.getMessage());
        }
        provider.deleteCredentialEntry("pass");
        try {
            provider.deleteCredentialEntry("pass");
            Assertions.assertTrue((boolean)false, (String)"should throw");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Credential pass does not exist in " + ourUrl), (Object)e.getMessage());
        }
        char[] passTwo = new char[]{'1', '2', '3'};
        provider.createCredentialEntry("pass", passwd);
        provider.createCredentialEntry("pass2", passTwo);
        Assertions.assertArrayEquals((char[])passTwo, (char[])provider.getCredentialEntry("pass2").getCredential());
        provider.flush();
        Assertions.assertArrayEquals((char[])passTwo, (char[])conf.getPassword("pass2"));
        conf.set("onetwothree", "123");
        Assertions.assertArrayEquals((char[])passTwo, (char[])conf.getPassword("onetwothree"));
        conf.set("hadoop.security.credential.clear-text-fallback", "false");
        Assertions.assertArrayEquals(null, (char[])conf.getPassword("onetwothree"));
        provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        Assertions.assertTrue((provider != null ? 1 : 0) != 0);
        Assertions.assertArrayEquals((char[])new char[]{'1', '2', '3'}, (char[])provider.getCredentialEntry("pass2").getCredential());
        Assertions.assertArrayEquals((char[])passwd, (char[])provider.getCredentialEntry("pass").getCredential());
        List creds = provider.getAliases();
        Assertions.assertTrue((creds.size() == 2 ? 1 : 0) != 0, (String)"Credentials should have been returned.");
        Assertions.assertTrue((boolean)creds.contains("pass"), (String)"Returned Credentials should have included pass.");
        Assertions.assertTrue((boolean)creds.contains("pass2"), (String)"Returned Credentials should have included pass2.");
    }

    @Test
    public void testUserProvider() throws Exception {
        Configuration conf = new Configuration();
        String ourUrl = "user:///";
        conf.set("hadoop.security.credential.provider.path", "user:///");
        TestCredentialProviderFactory.checkSpecificProvider(conf, "user:///");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        Assertions.assertArrayEquals((byte[])new byte[]{49, 50, 51}, (byte[])credentials.getSecretKey(new Text("pass2")));
    }

    @Test
    public void testJksProvider() throws Exception {
        Configuration conf = new Configuration();
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(tmpDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        TestCredentialProviderFactory.checkSpecificProvider(conf, ourUrl);
        Path path = ProviderUtils.unnestUri((URI)new URI(ourUrl));
        FileSystem fs = path.getFileSystem(conf);
        FileStatus s = fs.getFileStatus(path);
        Assertions.assertEquals((Object)"rw-------", (Object)s.getPermission().toString());
        Assertions.assertTrue((boolean)file.isFile(), (String)(file + " should exist"));
        fs.setPermission(path, new FsPermission("777"));
        this.checkPermissionRetention(conf, ourUrl, path);
    }

    @Test
    public void testLocalJksProvider() throws Exception {
        Configuration conf = new Configuration();
        Path jksPath = new Path(tmpDir.toString(), "test.jks");
        String ourUrl = "localjceks://file" + jksPath.toUri();
        File file = new File(tmpDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        TestCredentialProviderFactory.checkSpecificProvider(conf, ourUrl);
        Path path = ProviderUtils.unnestUri((URI)new URI(ourUrl));
        FileSystem fs = path.getFileSystem(conf);
        FileStatus s = fs.getFileStatus(path);
        Assertions.assertEquals((Object)"rw-------", (Object)s.getPermission().toString(), (String)("Unexpected permissions: " + s.getPermission().toString()));
        Assertions.assertTrue((boolean)file.isFile(), (String)(file + " should exist"));
        fs.setPermission(path, new FsPermission("777"));
        this.checkPermissionRetention(conf, ourUrl, path);
    }

    @Test
    public void testLocalBCFKSProvider() {
        Configuration conf = new Configuration();
        Path ksPath = new Path(tmpDir.toString(), "test.bcfks");
        String ourUrl = "localbcfks://file" + ksPath.toUri();
        conf.set("hadoop.security.credential.provider.path", ourUrl);
        Exception exception = (Exception)Assertions.assertThrows(IOException.class, () -> CredentialProviderFactory.getProviders((Configuration)conf));
        Assertions.assertEquals((Object)"Can't create keystore", (Object)exception.getMessage());
    }

    public void checkPermissionRetention(Configuration conf, String ourUrl, Path path) throws Exception {
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        char[] cred = new char[32];
        for (int i = 0; i < cred.length; ++i) {
            cred[i] = (char)i;
        }
        try {
            provider.createCredentialEntry("key5", cred);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        provider.flush();
        provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        Assertions.assertArrayEquals((char[])cred, (char[])provider.getCredentialEntry("key5").getCredential());
        FileSystem fs = path.getFileSystem(conf);
        FileStatus s = fs.getFileStatus(path);
        Assertions.assertEquals((Object)"rwxrwxrwx", (Object)s.getPermission().toString(), (String)"Permissions should have been retained from the preexisting keystore.");
    }
}

