/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.User;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestUserGroupInformation {
    static final Logger LOG = LoggerFactory.getLogger(TestUserGroupInformation.class);
    private static final String USER_NAME = "user1@HADOOP.APACHE.ORG";
    private static final String GROUP1_NAME = "group1";
    private static final String GROUP2_NAME = "group2";
    private static final String GROUP3_NAME = "group3";
    private static final String[] GROUP_NAMES = new String[]{"group1", "group2", "group3"};
    private static final int PERCENTILES_INTERVAL = 1;
    private static Configuration conf;

    @BeforeAll
    public static void setup() {
        javax.security.auth.login.Configuration.setConfiguration(new DummyLoginConfiguration());
        String home = System.getenv("HADOOP_HOME");
        System.setProperty("hadoop.home.dir", home != null ? home : ".");
    }

    @BeforeEach
    public void setupUgi() {
        conf = new Configuration();
        UserGroupInformation.reset();
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterEach
    public void resetUgi() {
        UserGroupInformation.setLoginUser(null);
    }

    @Test
    @Timeout(value=30L)
    public void testSimpleLogin() throws IOException {
        this.tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod.SIMPLE, true);
    }

    @Test
    @Timeout(value=30L)
    public void testTokenLogin() throws IOException {
        this.tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN, false);
    }

    @Test
    @Timeout(value=30L)
    public void testProxyLogin() throws IOException {
        this.tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY, false);
    }

    private void tryLoginAuthenticationMethod(UserGroupInformation.AuthenticationMethod method, boolean expectSuccess) throws IOException {
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)method, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = null;
        Exception ex = null;
        try {
            ugi = UserGroupInformation.getLoginUser();
        }
        catch (Exception e) {
            ex = e;
        }
        if (expectSuccess) {
            Assertions.assertNotNull((Object)ugi);
            Assertions.assertEquals((Object)method, (Object)ugi.getAuthenticationMethod());
        } else {
            Assertions.assertNotNull((Object)ex);
            Assertions.assertEquals(UnsupportedOperationException.class, ex.getClass());
            Assertions.assertEquals((Object)(method + " login authentication is not supported"), (Object)ex.getMessage());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testGetRealAuthenticationMethod() {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"user1");
        ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.SIMPLE);
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)ugi.getAuthenticationMethod());
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)ugi.getRealAuthenticationMethod());
        ugi = UserGroupInformation.createProxyUser((String)"user2", (UserGroupInformation)ugi);
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)ugi.getAuthenticationMethod());
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)ugi.getRealAuthenticationMethod());
    }

    @Test
    @Timeout(value=30L)
    public void testCreateRemoteUser() {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"user1");
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE, (Object)ugi.getAuthenticationMethod());
        Assertions.assertTrue((boolean)ugi.toString().contains("(auth:SIMPLE)"));
        ugi = UserGroupInformation.createRemoteUser((String)"user1", (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        Assertions.assertTrue((boolean)ugi.toString().contains("(auth:KERBEROS)"));
    }

    @Test
    @Timeout(value=30L)
    public void testLogin() throws Exception {
        conf.set("hadoop.user.group.metrics.percentiles.intervals", String.valueOf(1));
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assertions.assertEquals((Object)UserGroupInformation.getCurrentUser(), (Object)UserGroupInformation.getLoginUser());
        Assertions.assertTrue((ugi.getGroupNames().length >= 1 ? 1 : 0) != 0);
        TestUserGroupInformation.verifyGroupMetrics(1L);
        UserGroupInformation userGroupInfo = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        UserGroupInformation curUGI = (UserGroupInformation)userGroupInfo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws IOException {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assertions.assertEquals((Object)curUGI, (Object)userGroupInfo);
        Assertions.assertFalse((boolean)curUGI.equals((Object)UserGroupInformation.getLoginUser()));
    }

    @Test
    @Timeout(value=30L)
    public void testGetServerSideGroups() throws IOException, InterruptedException {
        String[] tokens;
        Process pp = Runtime.getRuntime().exec("whoami");
        BufferedReader br = new BufferedReader(new InputStreamReader(pp.getInputStream()));
        String userName = br.readLine().trim();
        if (Shell.WINDOWS) {
            int sp = userName.lastIndexOf(92);
            if (sp != -1) {
                userName = userName.substring(sp + 1);
            }
            userName = StringUtils.toLowerCase((String)userName);
        }
        pp = Runtime.getRuntime().exec(Shell.WINDOWS ? Shell.getWinUtilsPath() + " groups -F" : "id -Gn " + userName);
        br = new BufferedReader(new InputStreamReader(pp.getInputStream()));
        String line = br.readLine();
        System.out.println(userName + ":" + line);
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (String s : tokens = line.split(Shell.TOKEN_SEPARATOR_REGEX)) {
            groups.add(s);
        }
        final UserGroupInformation login = UserGroupInformation.getCurrentUser();
        String loginUserName = login.getShortUserName();
        if (Shell.WINDOWS) {
            loginUserName = StringUtils.toLowerCase((String)loginUserName);
        }
        Assertions.assertEquals((Object)userName, (Object)loginUserName);
        String[] gi = login.getGroupNames();
        Assertions.assertEquals((int)groups.size(), (int)gi.length);
        for (int i = 0; i < gi.length; ++i) {
            Assertions.assertTrue((boolean)groups.contains(gi[i]));
        }
        final UserGroupInformation fakeUser = UserGroupInformation.createRemoteUser((String)"foo.bar");
        fakeUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                UserGroupInformation current = UserGroupInformation.getCurrentUser();
                Assertions.assertFalse((boolean)current.equals((Object)login));
                Assertions.assertEquals((Object)current, (Object)fakeUser);
                Assertions.assertEquals((int)0, (int)current.getGroupNames().length);
                return null;
            }
        });
    }

    @Test
    @Timeout(value=30L)
    public void testConstructor() throws Exception {
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user2@DEFAULT.REALM", "user2");
        this.testConstructorSuccess("user3/cron@DEFAULT.REALM", "user3");
        this.testConstructorSuccess("user4@OTHER.REALM", "user4");
        this.testConstructorSuccess("user5/cron@OTHER.REALM", "user5");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
    }

    @Test
    @Timeout(value=30L)
    public void testConstructorWithRules() throws Exception {
        conf.set("hadoop.security.auth_to_local", "RULE:[1:$1@$0](.*@OTHER.REALM)s/(.*)@.*/other-$1/");
        conf.set("hadoop.security.auth_to_local.mechanism", "hadoop");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user4@OTHER.REALM", "other-user4");
        this.testConstructorFailures("user2@DEFAULT.REALM");
        this.testConstructorFailures("user3/cron@DEFAULT.REALM");
        this.testConstructorFailures("user5/cron@OTHER.REALM");
        conf.set("hadoop.security.auth_to_local.mechanism", "mit");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.testConstructorSuccess("user2@DEFAULT.REALM", "user2@DEFAULT.REALM");
        this.testConstructorSuccess("user3/cron@DEFAULT.REALM", "user3/cron@DEFAULT.REALM");
        this.testConstructorSuccess("user5/cron@OTHER.REALM", "user5/cron@OTHER.REALM");
        this.testConstructorFailures("user6@example.com@OTHER.REALM");
        this.testConstructorFailures("user7@example.com@DEFAULT.REALM");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
        conf.set("hadoop.security.auth_to_local.mechanism", "hadoop");
    }

    @Test
    @Timeout(value=30L)
    public void testConstructorWithKerberos() throws Exception {
        conf.set("hadoop.security.auth_to_local.mechanism", "hadoop");
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user2@DEFAULT.REALM", "user2");
        this.testConstructorSuccess("user3/cron@DEFAULT.REALM", "user3");
        this.testConstructorFailures("user4@OTHER.REALM");
        this.testConstructorFailures("user5/cron@OTHER.REALM");
        conf.set("hadoop.security.auth_to_local.mechanism", "mit");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.testConstructorSuccess("user4@OTHER.REALM", "user4@OTHER.REALM");
        this.testConstructorSuccess("user5/cron@OTHER.REALM", "user5/cron@OTHER.REALM");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
        conf.set("hadoop.security.auth_to_local.mechanism", "hadoop");
    }

    @Test
    @Timeout(value=30L)
    public void testConstructorWithKerberosRules() throws Exception {
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](.*@OTHER.REALM)s/(.*)@.*/other-$1/RULE:[1:$1@$0](.*@OTHER.REALM)s/(.*)@.*/other-$1/DEFAULT");
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.testConstructorSuccess("user1", "user1");
        this.testConstructorSuccess("user2@DEFAULT.REALM", "user2");
        this.testConstructorSuccess("user3/cron@DEFAULT.REALM", "user3");
        this.testConstructorSuccess("user4@OTHER.REALM", "other-user4");
        this.testConstructorSuccess("user5/cron@OTHER.REALM", "other-user5");
        this.testConstructorFailures(null);
        this.testConstructorFailures("");
    }

    private void testConstructorSuccess(String principal, String shortName) {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)principal, (String[])GROUP_NAMES);
        Assertions.assertEquals((Object)principal, (Object)ugi.getUserName());
        Assertions.assertEquals((Object)shortName, (Object)ugi.getShortUserName());
    }

    private void testConstructorFailures(String userName) {
        try {
            UserGroupInformation.createRemoteUser((String)userName);
            Assertions.fail((String)("user:" + userName + " wasn't invalid"));
        }
        catch (IllegalArgumentException e) {
            String expect = userName == null || userName.isEmpty() ? "Null user" : "Illegal principal name " + userName;
            String expect2 = "Malformed Kerberos name: " + userName;
            Assertions.assertTrue((e.toString().contains(expect) || e.toString().contains(expect2) ? 1 : 0) != 0, (String)("Did not find " + expect + " or " + expect2 + " in " + e));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSetConfigWithRules() {
        String[] rules = new String[]{"RULE:[1:TEST1]", "RULE:[1:TEST2]", "RULE:[1:TEST3]"};
        UserGroupInformation.reset();
        Assertions.assertFalse((boolean)KerberosName.hasRulesBeenSet());
        KerberosName.setRules((String)rules[0]);
        Assertions.assertTrue((boolean)KerberosName.hasRulesBeenSet());
        Assertions.assertEquals((Object)rules[0], (Object)KerberosName.getRules());
        UserGroupInformation.createUserForTesting((String)"someone", (String[])new String[0]);
        Assertions.assertEquals((Object)rules[0], (Object)KerberosName.getRules());
        conf.set("hadoop.security.auth_to_local", rules[1]);
        UserGroupInformation.setConfiguration((Configuration)conf);
        Assertions.assertEquals((Object)rules[1], (Object)KerberosName.getRules());
        conf.set("hadoop.security.auth_to_local", rules[2]);
        UserGroupInformation.setConfiguration((Configuration)conf);
        Assertions.assertEquals((Object)rules[2], (Object)KerberosName.getRules());
        UserGroupInformation.createUserForTesting((String)"someone", (String[])new String[0]);
        Assertions.assertEquals((Object)rules[2], (Object)KerberosName.getRules());
    }

    @Test
    @Timeout(value=30L)
    public void testEnsureInitWithRules() throws IOException {
        String rules = "RULE:[1:RULE1]";
        UserGroupInformation.reset();
        Assertions.assertFalse((boolean)KerberosName.hasRulesBeenSet());
        UserGroupInformation.createUserForTesting((String)"someone", (String[])new String[0]);
        Assertions.assertTrue((boolean)KerberosName.hasRulesBeenSet());
        UserGroupInformation.reset();
        KerberosName.setRules((String)rules);
        Assertions.assertTrue((boolean)KerberosName.hasRulesBeenSet());
        Assertions.assertEquals((Object)rules, (Object)KerberosName.getRules());
        UserGroupInformation.createUserForTesting((String)"someone", (String[])new String[0]);
        Assertions.assertEquals((Object)rules, (Object)KerberosName.getRules());
    }

    @Test
    @Timeout(value=30L)
    public void testEquals() throws Exception {
        UserGroupInformation uugi = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        Assertions.assertEquals((Object)uugi, (Object)uugi);
        UserGroupInformation ugi2 = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        Assertions.assertFalse((boolean)uugi.equals((Object)ugi2));
        Assertions.assertFalse((uugi.hashCode() == ugi2.hashCode() ? 1 : 0) != 0);
        UserGroupInformation ugi3 = new UserGroupInformation(uugi.getSubject());
        Assertions.assertEquals((Object)uugi, (Object)ugi3);
        Assertions.assertEquals((int)uugi.hashCode(), (int)ugi3.hashCode());
    }

    @Test
    @Timeout(value=30L)
    public void testEqualsWithRealUser() throws Exception {
        UserGroupInformation realUgi1 = UserGroupInformation.createUserForTesting((String)"RealUser", (String[])GROUP_NAMES);
        UserGroupInformation proxyUgi1 = UserGroupInformation.createProxyUser((String)USER_NAME, (UserGroupInformation)realUgi1);
        UserGroupInformation proxyUgi2 = new UserGroupInformation(proxyUgi1.getSubject());
        UserGroupInformation remoteUgi = UserGroupInformation.createRemoteUser((String)USER_NAME);
        Assertions.assertEquals((Object)proxyUgi1, (Object)proxyUgi2);
        Assertions.assertFalse((boolean)remoteUgi.equals((Object)proxyUgi1));
    }

    @Test
    @Timeout(value=30L)
    public void testGettingGroups() throws Exception {
        UserGroupInformation uugi = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        Assertions.assertEquals((Object)USER_NAME, (Object)uugi.getUserName());
        Object[] expected = new String[]{GROUP1_NAME, GROUP2_NAME, GROUP3_NAME};
        Assertions.assertArrayEquals((Object[])expected, (Object[])uugi.getGroupNames());
        Assertions.assertArrayEquals((Object[])expected, (Object[])uugi.getGroups().toArray(new String[0]));
        Assertions.assertEquals((Object)GROUP1_NAME, (Object)uugi.getPrimaryGroupName());
    }

    @Test
    @Timeout(value=30L)
    public <T extends TokenIdentifier> void testAddToken() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"someone");
        Token t1 = (Token)Mockito.mock(Token.class);
        Token t2 = (Token)Mockito.mock(Token.class);
        Token t3 = (Token)Mockito.mock(Token.class);
        ugi.addToken(t1);
        this.checkTokens(ugi, t1);
        ugi.addToken(t2);
        this.checkTokens(ugi, t2);
        Mockito.when((Object)t1.getService()).thenReturn((Object)new Text("t1"));
        ugi.addToken(t1);
        this.checkTokens(ugi, t1, t2);
        Mockito.when((Object)t3.getService()).thenReturn((Object)new Text("t1"));
        ugi.addToken(t3);
        this.checkTokens(ugi, t2, t3);
        Mockito.when((Object)t1.getService()).thenReturn((Object)new Text("t1.1"));
        ugi.addToken(t1);
        this.checkTokens(ugi, t1, t2, t3);
        ugi.addToken(t1);
        this.checkTokens(ugi, t1, t2, t3);
    }

    @Test
    @Timeout(value=30L)
    public <T extends TokenIdentifier> void testGetCreds() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"someone");
        Text service = new Text("service");
        Token t1 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t1.getService()).thenReturn((Object)service);
        Token t2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t2.getService()).thenReturn((Object)new Text("service2"));
        Token t3 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t3.getService()).thenReturn((Object)service);
        ugi.addToken(t1);
        ugi.addToken(t2);
        this.checkTokens(ugi, t1, t2);
        Credentials creds = ugi.getCredentials();
        creds.addToken(t3.getService(), t3);
        Assertions.assertSame((Object)t3, (Object)creds.getToken(service));
        this.checkTokens(ugi, t1, t2);
    }

    @Test
    @Timeout(value=30L)
    public <T extends TokenIdentifier> void testAddCreds() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"someone");
        Text service = new Text("service");
        Token t1 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t1.getService()).thenReturn((Object)service);
        Token t2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t2.getService()).thenReturn((Object)new Text("service2"));
        byte[] secret = new byte[]{};
        Text secretKey = new Text("sshhh");
        Credentials creds = new Credentials();
        creds.addToken(t1.getService(), t1);
        creds.addToken(t2.getService(), t2);
        creds.addSecretKey(secretKey, secret);
        ugi.addCredentials(creds);
        this.checkTokens(ugi, t1, t2);
        Assertions.assertSame((Object)secret, (Object)ugi.getCredentials().getSecretKey(secretKey));
    }

    @Test
    @Timeout(value=30L)
    public <T extends TokenIdentifier> void testGetCredsNotSame() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"someone");
        Credentials creds = ugi.getCredentials();
        Assertions.assertNotSame((Object)creds, (Object)ugi.getCredentials());
    }

    private void checkTokens(UserGroupInformation ugi, Token<?> ... tokens) {
        Collection ugiTokens = ugi.getTokens();
        for (Token<?> t : tokens) {
            Assertions.assertTrue((boolean)ugiTokens.contains(t));
        }
        Assertions.assertEquals((int)tokens.length, (int)ugiTokens.size());
        Credentials ugiCreds = ugi.getCredentials();
        for (Token<?> t : tokens) {
            Assertions.assertSame(t, (Object)ugiCreds.getToken(t.getService()));
        }
        Assertions.assertEquals((int)tokens.length, (int)ugiCreds.numberOfTokens());
    }

    @Test
    @Timeout(value=30L)
    public <T extends TokenIdentifier> void testAddNamedToken() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"someone");
        Token t1 = (Token)Mockito.mock(Token.class);
        Text service1 = new Text("t1");
        Text service2 = new Text("t2");
        Mockito.when((Object)t1.getService()).thenReturn((Object)service1);
        ugi.addToken(service1, t1);
        Assertions.assertSame((Object)t1, (Object)ugi.getCredentials().getToken(service1));
        ugi.addToken(service2, t1);
        Assertions.assertSame((Object)t1, (Object)ugi.getCredentials().getToken(service1));
        Assertions.assertSame((Object)t1, (Object)ugi.getCredentials().getToken(service2));
    }

    @Test
    @Timeout(value=30L)
    public <T extends TokenIdentifier> void testUGITokens() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"TheDoctor", (String[])new String[]{"TheTARDIS"});
        Token t1 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t1.getService()).thenReturn((Object)new Text("t1"));
        Token t2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)t2.getService()).thenReturn((Object)new Text("t2"));
        Credentials creds = new Credentials();
        byte[] secretKey = new byte[]{};
        Text secretName = new Text("shhh");
        creds.addSecretKey(secretName, secretKey);
        ugi.addToken(t1);
        ugi.addToken(t2);
        ugi.addCredentials(creds);
        Collection z = ugi.getTokens();
        Assertions.assertTrue((boolean)z.contains(t1));
        Assertions.assertTrue((boolean)z.contains(t2));
        Assertions.assertEquals((int)2, (int)z.size());
        Credentials ugiCreds = ugi.getCredentials();
        Assertions.assertSame((Object)secretKey, (Object)ugiCreds.getSecretKey(secretName));
        Assertions.assertEquals((int)1, (int)ugiCreds.numberOfSecretKeys());
        try {
            z.remove(t1);
            Assertions.fail((String)"Shouldn't be able to modify token collection from UGI");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Collection otherSet = (Collection)ugi.doAs(new PrivilegedExceptionAction<Collection<Token<?>>>(){

            @Override
            public Collection<Token<?>> run() throws IOException {
                return UserGroupInformation.getCurrentUser().getTokens();
            }
        });
        Assertions.assertTrue((boolean)otherSet.contains(t1));
        Assertions.assertTrue((boolean)otherSet.contains(t2));
    }

    @Test
    @Timeout(value=30L)
    public void testTokenIdentifiers() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"TheDoctor", (String[])new String[]{"TheTARDIS"});
        TokenIdentifier t1 = (TokenIdentifier)Mockito.mock(TokenIdentifier.class);
        TokenIdentifier t2 = (TokenIdentifier)Mockito.mock(TokenIdentifier.class);
        ugi.addTokenIdentifier(t1);
        ugi.addTokenIdentifier(t2);
        Set z = ugi.getTokenIdentifiers();
        Assertions.assertTrue((boolean)z.contains(t1));
        Assertions.assertTrue((boolean)z.contains(t2));
        Assertions.assertEquals((int)2, (int)z.size());
        Collection otherSet = (Collection)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Collection<TokenIdentifier>>(){

            @Override
            public Collection<TokenIdentifier> run() throws IOException {
                return UserGroupInformation.getCurrentUser().getTokenIdentifiers();
            }
        });
        Assertions.assertTrue((boolean)otherSet.contains(t1));
        Assertions.assertTrue((boolean)otherSet.contains(t2));
        Assertions.assertEquals((int)2, (int)otherSet.size());
    }

    @Test
    @Timeout(value=30L)
    public void testTestAuthMethod() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        for (UserGroupInformation.AuthenticationMethod am : UserGroupInformation.AuthenticationMethod.values()) {
            if (am.getAuthMethod() == null) continue;
            ugi.setAuthenticationMethod(am.getAuthMethod());
            Assertions.assertEquals((Object)am, (Object)ugi.getAuthenticationMethod());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testUGIAuthMethod() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        final UserGroupInformation.AuthenticationMethod am = UserGroupInformation.AuthenticationMethod.KERBEROS;
        ugi.setAuthenticationMethod(am);
        Assertions.assertEquals((Object)am, (Object)ugi.getAuthenticationMethod());
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Assertions.assertEquals((Object)am, (Object)UserGroupInformation.getCurrentUser().getAuthenticationMethod());
                return null;
            }
        });
    }

    @Test
    @Timeout(value=30L)
    public void testUGIAuthMethodInRealUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUgi = UserGroupInformation.createProxyUser((String)"proxy", (UserGroupInformation)ugi);
        final UserGroupInformation.AuthenticationMethod am = UserGroupInformation.AuthenticationMethod.KERBEROS;
        ugi.setAuthenticationMethod(am);
        Assertions.assertEquals((Object)am, (Object)ugi.getAuthenticationMethod());
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)proxyUgi.getAuthenticationMethod());
        Assertions.assertEquals((Object)am, (Object)UserGroupInformation.getRealAuthenticationMethod((UserGroupInformation)proxyUgi));
        proxyUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.PROXY, (Object)UserGroupInformation.getCurrentUser().getAuthenticationMethod());
                Assertions.assertEquals((Object)am, (Object)UserGroupInformation.getCurrentUser().getRealUser().getAuthenticationMethod());
                return null;
            }
        });
        UserGroupInformation proxyUgi2 = new UserGroupInformation(proxyUgi.getSubject());
        proxyUgi2.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
        Assertions.assertEquals((Object)proxyUgi, (Object)proxyUgi2);
        UserGroupInformation realugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation proxyUgi3 = UserGroupInformation.createProxyUser((String)"proxyAnother", (UserGroupInformation)realugi);
        UserGroupInformation proxyUgi4 = new UserGroupInformation(proxyUgi3.getSubject());
        Assertions.assertEquals((Object)proxyUgi3, (Object)proxyUgi4);
    }

    @Test
    @Timeout(value=30L)
    public void testLoginObjectInSubject() throws Exception {
        LoginContext login2;
        UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        UserGroupInformation anotherUgi = new UserGroupInformation(loginUgi.getSubject());
        LoginContext login1 = loginUgi.getSubject().getPrincipals(User.class).iterator().next().getLogin();
        Assertions.assertTrue((login1 == (login2 = anotherUgi.getSubject().getPrincipals(User.class).iterator().next().getLogin()) ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=30L)
    public void testLoginModuleCommit() throws Exception {
        UserGroupInformation loginUgi = UserGroupInformation.getLoginUser();
        User user1 = loginUgi.getSubject().getPrincipals(User.class).iterator().next();
        LoginContext login = user1.getLogin();
        login.logout();
        login.login();
        User user2 = loginUgi.getSubject().getPrincipals(User.class).iterator().next();
        Assertions.assertTrue((user1 == user2 ? 1 : 0) != 0);
    }

    public static void verifyLoginMetrics(long success, int failure) throws IOException {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics("UgiMetrics");
        if (success > 0L) {
            MetricsAsserts.assertCounter("LoginSuccessNumOps", success, rb);
            MetricsAsserts.assertGaugeGt("LoginSuccessAvgTime", 0.0, rb);
        }
        if (failure > 0) {
            MetricsAsserts.assertCounter("LoginFailureNumPos", failure, rb);
            MetricsAsserts.assertGaugeGt("LoginFailureAvgTime", 0.0, rb);
        }
    }

    private static void verifyGroupMetrics(long groups) throws InterruptedException {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics("UgiMetrics");
        if (groups > 0L) {
            MetricsAsserts.assertCounterGt("GetGroupsNumOps", groups - 1L, rb);
            double avg = MetricsAsserts.getDoubleGauge("GetGroupsAvgTime", rb);
            Assertions.assertTrue((avg >= 0.0 ? 1 : 0) != 0);
            Thread.sleep(2000L);
            MetricsAsserts.assertQuantileGauges("GetGroups1s", rb);
        }
    }

    @Test
    @Timeout(value=30L)
    public void testUGIUnderNonHadoopContext() throws Exception {
        Subject nonHadoopSubject = new Subject();
        Subject.doAs(nonHadoopSubject, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                Assertions.assertNotNull((Object)ugi);
                return null;
            }
        });
    }

    @Test
    @Timeout(value=30L)
    public void testGetUGIFromSubject() throws Exception {
        KerberosPrincipal p = new KerberosPrincipal("guest");
        Subject subject = new Subject();
        subject.getPrincipals().add(p);
        UserGroupInformation ugi = UserGroupInformation.getUGIFromSubject((Subject)subject);
        Assertions.assertNotNull((Object)ugi);
        Assertions.assertEquals((Object)"guest@DEFAULT.REALM", (Object)ugi.getUserName());
    }

    @Test
    @Timeout(value=30L)
    public void testHasSufficientTimeElapsed() throws Exception {
        Method method = UserGroupInformation.class.getDeclaredMethod("hasSufficientTimeElapsed", Long.TYPE);
        method.setAccessible(true);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        User user = ugi.getSubject().getPrincipals(User.class).iterator().next();
        long now = System.currentTimeMillis();
        user.setLastLogin(now - 120000L);
        Assertions.assertTrue((boolean)((Boolean)method.invoke((Object)ugi, now)));
        user.setLastLogin(now - 30000L);
        Assertions.assertFalse((boolean)((Boolean)method.invoke((Object)ugi, now)));
        Configuration conf2 = new Configuration(conf);
        conf2.setLong("hadoop.kerberos.min.seconds.before.relogin", 600L);
        UserGroupInformation.setConfiguration((Configuration)conf2);
        user.setLastLogin(now - 900000L);
        Assertions.assertTrue((boolean)((Boolean)method.invoke((Object)ugi, now)));
        user.setLastLogin(now - 360000L);
        Assertions.assertFalse((boolean)((Boolean)method.invoke((Object)ugi, now)));
        UserGroupInformation.setConfiguration((Configuration)conf);
        method.setAccessible(false);
    }

    @Test
    @Timeout(value=10L)
    public void testSetLoginUser() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test-user");
        UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
        Assertions.assertEquals((Object)ugi, (Object)UserGroupInformation.getLoginUser());
    }

    @Test
    public void testPrivateTokenExclusion() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"privateUser", (String[])new String[]{"PRIVATEUSERS"});
        TestRpcBase.TestTokenIdentifier tokenId = new TestRpcBase.TestTokenIdentifier();
        Token token = new Token(tokenId.getBytes(), "password".getBytes(), tokenId.getKind(), null);
        ugi.addToken(new Text("regular-token"), token);
        Text service = new Text("private-token");
        ugi.addToken(service, token.privateClone(service));
        Text service1 = new Text("private-token1");
        ugi.addToken(service1, token.privateClone(service1));
        Collection tokens = ugi.getCredentials().getAllTokens();
        Assertions.assertEquals((int)1, (int)tokens.size());
    }

    @Test
    public void testTokenRaceCondition() throws Exception {
        UserGroupInformation userGroupInfo = UserGroupInformation.createUserForTesting((String)USER_NAME, (String[])GROUP_NAMES);
        userGroupInfo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                Assertions.assertNotEquals((Object)UserGroupInformation.getLoginUser(), (Object)UserGroupInformation.getCurrentUser());
                GetTokenThread thread = new GetTokenThread();
                try {
                    thread.start();
                    for (int i = 0; i < 100; ++i) {
                        Token t = (Token)Mockito.mock(Token.class);
                        Mockito.when((Object)t.getService()).thenReturn((Object)new Text("t" + i));
                        UserGroupInformation.getCurrentUser().addToken(t);
                        Assertions.assertNull((Object)thread.cme, (String)"ConcurrentModificationException encountered");
                    }
                }
                catch (ConcurrentModificationException cme) {
                    cme.printStackTrace();
                    Assertions.fail((String)"ConcurrentModificationException encountered");
                }
                finally {
                    thread.runThread = false;
                    thread.join(5000L);
                }
                return null;
            }
        });
    }

    @Test
    public void testExternalTokenFiles() throws Exception {
        StringBuilder tokenFullPathnames = new StringBuilder();
        String tokenFilenames = "token1,token2";
        String[] tokenFiles = StringUtils.getTrimmedStrings((String)tokenFilenames);
        File testDir = new File("target", TestUserGroupInformation.class.getName() + "-tmpDir").getAbsoluteFile();
        String testDirPath = testDir.getAbsolutePath();
        for (String tokenFile : tokenFiles) {
            if (tokenFullPathnames.length() > 0) {
                tokenFullPathnames.append(",");
            }
            tokenFullPathnames.append(testDirPath).append("/").append(tokenFile);
        }
        TestRpcBase.TestTokenIdentifier tokenId = new TestRpcBase.TestTokenIdentifier();
        Credentials cred1 = new Credentials();
        Token token1 = new Token(tokenId.getBytes(), "password".getBytes(), tokenId.getKind(), new Text("token-service1"));
        cred1.addToken(token1.getService(), token1);
        cred1.writeTokenStorageFile(new Path(testDirPath, tokenFiles[0]), conf);
        Credentials cred2 = new Credentials();
        Token token2 = new Token(tokenId.getBytes(), "password".getBytes(), tokenId.getKind(), new Text("token-service2"));
        cred2.addToken(token2.getService(), token2);
        cred2.writeTokenStorageFile(new Path(testDirPath, tokenFiles[1]), conf);
        System.setProperty("hadoop.token.files", tokenFullPathnames.toString());
        UserGroupInformation.setLoginUser(null);
        UserGroupInformation tokenUgi = UserGroupInformation.getLoginUser();
        Collection credsugiTokens = tokenUgi.getTokens();
        Assertions.assertTrue((boolean)credsugiTokens.contains(token1));
        Assertions.assertTrue((boolean)credsugiTokens.contains(token2));
        System.clearProperty("hadoop.token.files");
    }

    @Test
    public void testCheckTGTAfterLoginFromSubject() throws Exception {
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        final Subject subject = new Subject();
        KeyTab keytab = KeyTab.getInstance();
        subject.getPrivateCredentials().add(keytab);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                UserGroupInformation.loginUserFromSubject((Subject)subject);
                UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                return null;
            }
        });
    }

    @Test
    public void testGetNextRetryTime() throws Exception {
        GenericTestUtils.setLogLevel(UserGroupInformation.LOG, Level.DEBUG);
        long reloginInterval = 1L;
        long reloginIntervalMs = 1000L;
        conf.setLong("hadoop.kerberos.min.seconds.before.relogin", 1L);
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        long now = Time.now();
        Date endDate = new Date(now + 20000L);
        long currentTime = now + 10000L;
        long endTime = endDate.getTime();
        Assertions.assertEquals((int)0, (int)UserGroupInformation.metrics.getRenewalFailures().value());
        RetryPolicy rp = RetryPolicies.exponentialBackoffRetry((int)62, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        long lastRetry = UserGroupInformation.getNextTgtRenewalTime((long)endTime, (long)currentTime, (RetryPolicy)rp);
        this.assertWithinBounds(UserGroupInformation.metrics.getRenewalFailures().value(), lastRetry, 1000L, currentTime);
        UserGroupInformation.metrics.getRenewalFailures().incr();
        lastRetry = UserGroupInformation.getNextTgtRenewalTime((long)endTime, (long)currentTime, (RetryPolicy)rp);
        this.assertWithinBounds(UserGroupInformation.metrics.getRenewalFailures().value(), lastRetry, 1000L, currentTime);
        UserGroupInformation.metrics.getRenewalFailures().incr();
        lastRetry = UserGroupInformation.getNextTgtRenewalTime((long)endTime, (long)currentTime, (RetryPolicy)rp);
        this.assertWithinBounds(UserGroupInformation.metrics.getRenewalFailures().value(), lastRetry, 1000L, currentTime);
        UserGroupInformation.metrics.getRenewalFailures().incr();
        lastRetry = UserGroupInformation.getNextTgtRenewalTime((long)endTime, (long)currentTime, (RetryPolicy)rp);
        this.assertWithinBounds(UserGroupInformation.metrics.getRenewalFailures().value(), lastRetry, 1000L, currentTime);
        UserGroupInformation.metrics.getRenewalFailures().incr();
        lastRetry = UserGroupInformation.getNextTgtRenewalTime((long)endTime, (long)currentTime, (RetryPolicy)rp);
        String str = "5th retry, now:" + currentTime + ", retry:" + lastRetry;
        LOG.info(str);
        Assertions.assertEquals((long)(endTime - 1000L), (long)lastRetry, (String)str);
        UserGroupInformation.metrics.getRenewalFailures().incr();
        lastRetry = UserGroupInformation.getNextTgtRenewalTime((long)endTime, (long)currentTime, (RetryPolicy)rp);
        str = "overflow retry, now:" + currentTime + ", retry:" + lastRetry;
        LOG.info(str);
        Assertions.assertEquals((long)(endTime - 1000L), (long)lastRetry, (String)str);
    }

    private void assertWithinBounds(int numFailures, long lastRetry, long reloginIntervalMs, long now) {
        int shift = numFailures + 1;
        long lower = now + reloginIntervalMs * (long)((double)(1 << shift) * 0.5);
        long upper = now + reloginIntervalMs * (long)((double)(1 << shift) * 1.5);
        String str = new String("Retry#" + (numFailures + 1) + ", now:" + now + ", lower bound:" + lower + ", upper bound:" + upper + ", retry:" + lastRetry);
        LOG.info(str);
        Assertions.assertTrue((lower <= lastRetry && lastRetry < upper ? 1 : 0) != 0, (String)str);
    }

    @Test
    @Timeout(value=8L)
    public void testConcurrentGetCurrentUser() throws Exception {
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch latch = new CountDownLatch(1);
        final UserGroupInformation testUgi1 = UserGroupInformation.createRemoteUser((String)"testUgi1");
        UserGroupInformation testUgi2 = UserGroupInformation.createRemoteUser((String)"testUgi2");
        Set<Principal> principals = testUgi1.getSubject().getPrincipals();
        User user = testUgi1.getSubject().getPrincipals(User.class).iterator().next();
        User spyUser = (User)Mockito.spy((Object)user);
        principals.remove(user);
        principals.add((Principal)spyUser);
        Mockito.when((Object)spyUser.getName()).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                latch.countDown();
                barrier.await();
                return (String)invocation.callRealMethod();
            }
        });
        Future<UserGroupInformation> blockingLookup = Executors.newSingleThreadExecutor().submit(new Callable<UserGroupInformation>(){

            @Override
            public UserGroupInformation call() throws Exception {
                return (UserGroupInformation)testUgi1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

                    @Override
                    public UserGroupInformation run() throws Exception {
                        return UserGroupInformation.getCurrentUser();
                    }
                });
            }
        });
        latch.await();
        principals.remove(spyUser);
        principals.add((Principal)user);
        UserGroupInformation ugi = (UserGroupInformation)testUgi1.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws Exception {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assertions.assertSame((Object)testUgi1.getSubject(), (Object)ugi.getSubject());
        ugi = (UserGroupInformation)testUgi2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<UserGroupInformation>(){

            @Override
            public UserGroupInformation run() throws Exception {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Assertions.assertSame((Object)testUgi2.getSubject(), (Object)ugi.getSubject());
        barrier.await();
        Assertions.assertSame((Object)testUgi1.getSubject(), (Object)blockingLookup.get().getSubject());
    }

    @Test
    public void testKerberosTicketIsDestroyedChecked() throws Exception {
        GenericTestUtils.setLogLevel(UserGroupInformation.LOG, Level.DEBUG);
        HashSet<User> users = new HashSet<User>();
        users.add(new User("Foo"));
        Subject subject = new Subject(true, users, new HashSet(), new HashSet());
        UserGroupInformation ugi = (UserGroupInformation)Mockito.spy((Object)new UserGroupInformation(subject));
        ((UserGroupInformation)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)ugi)).reloginFromTicketCache();
        Date d = new Date();
        KerberosPrincipal kp = new KerberosPrincipal("Foo");
        KerberosTicket tgt = (KerberosTicket)Mockito.spy((Object)new KerberosTicket(new byte[0], kp, kp, new byte[0], 0, null, d, d, d, d, null));
        tgt.destroy();
        UserGroupInformation userGroupInformation = ugi;
        userGroupInformation.getClass();
        UserGroupInformation.TicketCacheRenewalRunnable userCredsRunnable = new UserGroupInformation.TicketCacheRenewalRunnable(userGroupInformation, tgt, Boolean.toString(Boolean.TRUE), 100L);
        userCredsRunnable.setRunRenewalLoop(false);
        userCredsRunnable.run();
        ((KerberosTicket)Mockito.verify((Object)tgt, (VerificationMode)Mockito.atLeastOnce())).isDestroyed();
    }

    @Test
    public void testImportTokensFromConfig() throws IOException {
        Configuration config = new Configuration();
        String service0 = "testTokenImportService0";
        byte[] identity = "identityImportConfig".getBytes();
        byte[] password = "passwordImportConfig".getBytes();
        Token expectedToken0 = new Token(identity, password, new Text("testTokenKind0"), new Text(service0));
        String tokenBase64 = expectedToken0.encodeToUrlString();
        config.set("hadoop.tokens", tokenBase64 + ",badtoken");
        String service1 = "testTokenImportService1";
        Credentials cred0 = new Credentials();
        Token expectedToken1 = expectedToken0.copyToken();
        expectedToken1.setKind(new Text("testTokenKind1"));
        expectedToken1.setService(new Text(service1));
        cred0.addToken(expectedToken1.getService(), expectedToken1);
        Path workDir = new Path(GenericTestUtils.getRandomizedTestDir().getAbsolutePath());
        Path tokenPath1 = new Path(workDir, "dt.token");
        cred0.writeTokenStorageFile(tokenPath1, config);
        config.set("hadoop.token.files", tokenPath1 + "," + new Path(workDir, "badfile"));
        UserGroupInformation.reset();
        UserGroupInformation.setConfiguration((Configuration)config);
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Credentials outCred = ugi.getCredentials();
        Assertions.assertEquals((int)2, (int)outCred.getAllTokens().size(), (String)("Tokens: " + outCred.getAllTokens()));
        boolean found0 = false;
        boolean found1 = false;
        for (Token token : outCred.getAllTokens()) {
            Assertions.assertArrayEquals((byte[])identity, (byte[])token.getIdentifier());
            if (token.getService().toString().equals(service0)) {
                Assertions.assertEquals((Object)expectedToken0.encodeToUrlString(), (Object)token.encodeToUrlString());
                found0 = true;
            }
            if (!token.getService().toString().equals(service1)) continue;
            found1 = true;
        }
        Assertions.assertTrue((boolean)found0, (String)("Expected token testTokenService0 not found: " + outCred));
        Assertions.assertTrue((boolean)found1, (String)("Expected token testTokenService1 not found: " + outCred));
        Credentials cred1 = new Credentials();
        cred1.addToken(expectedToken0.getService(), expectedToken0);
        cred1.writeTokenStorageFile(tokenPath1, config);
        UserGroupInformation.reset();
        UserGroupInformation.setConfiguration((Configuration)config);
        UserGroupInformation ugi1 = UserGroupInformation.getLoginUser();
        Credentials outCred1 = ugi1.getCredentials();
        Assertions.assertEquals((int)1, (int)outCred1.getAllTokens().size(), (String)("Tokens: " + outCred1.getAllTokens()));
    }

    @Test
    public void testImportTokensFromProperty() throws IOException {
        Text service = new Text("testTokenProperty");
        byte[] identity = "identityImportProperty".getBytes();
        byte[] password = "passwordImportProperty".getBytes();
        Token expectedToken0 = new Token(identity, password, new Text("testTokenKind0"), service);
        String tokenBase64 = expectedToken0.encodeToUrlString();
        System.setProperty("hadoop.tokens", tokenBase64);
        UserGroupInformation.reset();
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        Credentials creds = ugi.getCredentials();
        Assertions.assertEquals((int)1, (int)creds.getAllTokens().size(), (String)("Tokens: " + creds.getAllTokens()));
        Assertions.assertArrayEquals((byte[])creds.getToken(service).getIdentifier(), (byte[])identity);
        System.clearProperty("hadoop.tokens");
    }

    static {
        System.setProperty("java.security.krb5.kdc", "");
        System.setProperty("java.security.krb5.realm", "DEFAULT.REALM");
    }

    static class GetTokenThread
    extends Thread {
        boolean runThread = true;
        volatile ConcurrentModificationException cme = null;

        GetTokenThread() {
        }

        @Override
        public void run() {
            while (this.runThread) {
                try {
                    UserGroupInformation.getCurrentUser().getCredentials();
                }
                catch (ConcurrentModificationException cme) {
                    this.cme = cme;
                    cme.printStackTrace();
                    this.runThread = false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static class DummyLoginConfiguration
    extends javax.security.auth.login.Configuration {
        private DummyLoginConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            throw new RuntimeException("UGI is not using its own security conf!");
        }
    }
}

