/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestUGIWithExternalKdc {
    @BeforeEach
    public void testExternalKdcRunning() {
        Assumptions.assumeTrue((boolean)SecurityUtilTestHelper.isExternalKdcRunning());
    }

    @Test
    public void testLogin() throws IOException {
        String userPrincipal = System.getProperty("user.principal");
        String userKeyTab = System.getProperty("user.keytab");
        Assertions.assertNotNull((Object)userPrincipal, (String)"User principal was not specified");
        Assertions.assertNotNull((Object)userKeyTab, (String)"User keytab was not specified");
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)userPrincipal, (String)userKeyTab);
        Assertions.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugi.getAuthenticationMethod());
        try {
            UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"bogus@EXAMPLE.COM", (String)userKeyTab);
            Assertions.fail((String)"Login should have failed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

