/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.spi.InitialContextFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

public class TestLdapGroupsMappingBase {
    @Mock
    private DirContext context;
    @Mock
    private NamingEnumeration<SearchResult> userNames;
    @Mock
    private NamingEnumeration<SearchResult> groupNames;
    @Mock
    private NamingEnumeration<SearchResult> parentGroupNames;
    @Mock
    private SearchResult userSearchResult;
    @Mock
    private Attributes attributes;
    @Spy
    private LdapGroupsMapping groupsMapping = new LdapGroupsMapping();
    private String[] testGroups = new String[]{"group1", "group2"};
    private String[] testParentGroups = new String[]{"group1", "group2", "group1_1"};

    @BeforeEach
    public void setupMocksBase() throws NamingException {
        DummyLdapCtxFactory.reset();
        MockitoAnnotations.initMocks((Object)this);
        DirContext ctx = this.getContext();
        Mockito.when(ctx.search(Mockito.anyString(), Mockito.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenReturn(this.userNames);
        Mockito.when((Object)this.userNames.hasMoreElements()).thenReturn((Object)true);
        SearchResult groupSearchResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)this.groupNames.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.groupNames.nextElement()).thenReturn((Object)groupSearchResult);
        BasicAttribute group1Attr = new BasicAttribute("cn");
        group1Attr.add(this.testGroups[0]);
        BasicAttributes group1Attrs = new BasicAttributes();
        group1Attrs.put(group1Attr);
        BasicAttribute group2Attr = new BasicAttribute("cn");
        group2Attr.add(this.testGroups[1]);
        BasicAttributes group2Attrs = new BasicAttributes();
        group2Attrs.put(group2Attr);
        Mockito.when((Object)groupSearchResult.getAttributes()).thenReturn((Object)group1Attrs, (Object[])new Attributes[]{group2Attrs});
        Mockito.when(this.getUserNames().nextElement()).thenReturn((Object)this.getUserSearchResult());
        Mockito.when((Object)this.getUserSearchResult().getAttributes()).thenReturn((Object)this.getAttributes());
        SearchResult parentGroupResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when((Object)this.parentGroupNames.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when(this.parentGroupNames.nextElement()).thenReturn((Object)parentGroupResult);
        BasicAttribute parentGroup1Attr = new BasicAttribute("cn");
        parentGroup1Attr.add(this.testParentGroups[2]);
        BasicAttributes parentGroup1Attrs = new BasicAttributes();
        parentGroup1Attrs.put(parentGroup1Attr);
        Mockito.when((Object)parentGroupResult.getAttributes()).thenReturn((Object)parentGroup1Attrs);
        Mockito.when((Object)parentGroupResult.getNameInNamespace()).thenReturn((Object)"CN=some_group,DC=test,DC=com");
    }

    protected Configuration getBaseConf() {
        return this.getBaseConf("ldap://test");
    }

    protected Configuration getBaseConf(String ldapUrl) {
        return this.getBaseConf(ldapUrl, this.getContext());
    }

    protected Configuration getBaseConf(String ldapUrl, DirContext contextToReturn) {
        DummyLdapCtxFactory.setContextToReturn(contextToReturn);
        DummyLdapCtxFactory.setExpectedLdapUrl(ldapUrl);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", ldapUrl);
        conf.setClass("hadoop.security.group.mapping.ldap.ctx.factory.class", DummyLdapCtxFactory.class, InitialContextFactory.class);
        return conf;
    }

    protected DirContext getContext() {
        return this.context;
    }

    protected NamingEnumeration<SearchResult> getUserNames() {
        return this.userNames;
    }

    protected NamingEnumeration<SearchResult> getGroupNames() {
        return this.groupNames;
    }

    protected SearchResult getUserSearchResult() {
        return this.userSearchResult;
    }

    protected Attributes getAttributes() {
        return this.attributes;
    }

    protected LdapGroupsMapping getGroupsMapping() {
        return this.groupsMapping;
    }

    protected String[] getTestGroups() {
        return this.testGroups;
    }

    protected NamingEnumeration getParentGroupNames() {
        return this.parentGroupNames;
    }

    protected String[] getTestParentGroups() {
        return this.testParentGroups;
    }

    public static class DummyLdapCtxFactory
    implements InitialContextFactory {
        private static DirContext contextToReturn;
        private static String expectedLdapUrl;
        private static String expectedBindUser;
        private static String expectedBindPassword;

        protected static void setContextToReturn(DirContext ctx) {
            contextToReturn = ctx;
        }

        protected static void setExpectedLdapUrl(String url) {
            expectedLdapUrl = url;
        }

        public static void setExpectedBindUser(String bindUser) {
            expectedBindUser = bindUser;
        }

        public static void setExpectedBindPassword(String bindPassword) {
            expectedBindPassword = bindPassword;
        }

        public static void reset() {
            expectedLdapUrl = null;
            expectedBindUser = null;
            expectedBindPassword = null;
        }

        @Override
        public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
            if (expectedLdapUrl != null) {
                String actualLdapUrl = (String)env.get("java.naming.provider.url");
                Assertions.assertEquals((Object)expectedLdapUrl, (Object)actualLdapUrl);
            }
            if (expectedBindUser != null) {
                String actualBindUser = (String)env.get("java.naming.security.principal");
                Assertions.assertEquals((Object)expectedBindUser, (Object)actualBindUser);
            }
            if (expectedBindPassword != null) {
                String actualBindPassword = (String)env.get("java.naming.security.credentials");
                Assertions.assertEquals((Object)expectedBindPassword, (Object)actualBindPassword);
            }
            if (contextToReturn == null) {
                Hashtable newEnv = new Hashtable(env);
                newEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                contextToReturn = new InitialLdapContext(newEnv, null);
            }
            return contextToReturn;
        }
    }
}

