/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestGroupFallback {
    public static final Logger LOG = LoggerFactory.getLogger(TestGroupFallback.class);

    @Test
    public void testGroupShell() throws Exception {
        GenericTestUtils.setRootLogLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.ShellBasedUnixGroupsMapping");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List groupList = groups.getGroups(username);
        LOG.info(username + " has GROUPS: " + groupList.toString());
        Assertions.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNetgroupShell() throws Exception {
        GenericTestUtils.setRootLogLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.ShellBasedUnixGroupsNetgroupMapping");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List groupList = groups.getGroups(username);
        LOG.info(username + " has GROUPS: " + groupList.toString());
        Assertions.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGroupWithFallback() throws Exception {
        LOG.info("running 'mvn -Pnative -DTestGroupFallback clear test' will test the normal path and 'mvn -DTestGroupFallback clear test' will test the fall back functionality");
        GenericTestUtils.setRootLogLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List groupList = groups.getGroups(username);
        LOG.info(username + " has GROUPS: " + groupList.toString());
        Assertions.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNetgroupWithFallback() throws Exception {
        LOG.info("running 'mvn -Pnative -DTestGroupFallback clear test' will test the normal path and 'mvn -DTestGroupFallback clear test' will test the fall back functionality");
        GenericTestUtils.setRootLogLevel(Level.DEBUG);
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsNetgroupMappingWithFallback");
        Groups groups = new Groups(conf);
        String username = System.getProperty("user.name");
        List groupList = groups.getGroups(username);
        LOG.info(username + " has GROUPS: " + groupList.toString());
        Assertions.assertTrue((groupList.size() > 0 ? 1 : 0) != 0);
    }
}

