/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCredentials {
    private static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA1";
    private static final File tmpDir = GenericTestUtils.getTestDir("mapred");
    static Text[] secret = new Text[]{new Text("secret1"), new Text("secret2"), new Text("secret3"), new Text("secret4")};
    static Text[] service = new Text[]{new Text("service1"), new Text("service2"), new Text("service3"), new Text("service4")};
    static Token<?>[] token = new Token[]{new Token(), new Token(), new Token(), new Token()};

    @BeforeEach
    public void setUp() {
        tmpDir.mkdir();
    }

    @AfterEach
    public void tearDown() {
        tmpDir.delete();
    }

    @Test
    public <T extends TokenIdentifier> void testReadWriteStorage() throws IOException, NoSuchAlgorithmException {
        Credentials ts = new Credentials();
        Token token1 = new Token();
        Token token2 = new Token();
        Text service1 = new Text("service1");
        Text service2 = new Text("service2");
        Text alias1 = new Text("sometoken1");
        Text alias2 = new Text("sometoken2");
        ArrayList<Text> services = new ArrayList<Text>();
        services.add(service1);
        services.add(service2);
        token1.setService(service1);
        token2.setService(service2);
        ts.addToken(alias1, token1);
        ts.addToken(alias2, token2);
        KeyGenerator kg = KeyGenerator.getInstance(DEFAULT_HMAC_ALGORITHM);
        String alias = "alias";
        HashMap<Text, byte[]> m = new HashMap<Text, byte[]>(10);
        for (int i = 0; i < 10; ++i) {
            SecretKey key = kg.generateKey();
            m.put(new Text(alias + i), key.getEncoded());
            ts.addSecretKey(new Text(alias + i), key.getEncoded());
        }
        File tmpFileName = new File(tmpDir, "tokenStorageTest");
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(tmpFileName));
        ts.write((DataOutput)dos);
        dos.close();
        DataInputStream dis = new DataInputStream(new FileInputStream(tmpFileName));
        ts = new Credentials();
        ts.readFields((DataInput)dis);
        dis.close();
        Map tokenMap = ts.getTokenMap();
        Assertions.assertEquals((int)2, (int)tokenMap.size(), (String)"getTokenMap should return collection of size 2");
        Assertions.assertTrue((boolean)tokenMap.containsKey(alias1), (String)("Token for alias " + alias1 + " must be present"));
        Assertions.assertTrue((boolean)tokenMap.containsKey(alias2), (String)("Token for alias " + alias2 + " must be present"));
        Assertions.assertEquals((Object)service1, (Object)((Token)tokenMap.get(alias1)).getService(), (String)("Token for service " + service1 + " must be present"));
        Assertions.assertEquals((Object)service2, (Object)((Token)tokenMap.get(alias2)).getService(), (String)("Token for service " + service2 + " must be present"));
        Map secretKeyMap = ts.getSecretKeyMap();
        Assertions.assertEquals((int)m.size(), (int)ts.numberOfSecretKeys(), (String)"wrong number of keys in the Storage");
        for (Map.Entry entry : m.entrySet()) {
            byte[] key = (byte[])secretKeyMap.get(entry.getKey());
            Assertions.assertNotNull((Object)key, (String)("Secret key for alias " + entry.getKey() + " not found"));
            Assertions.assertTrue((boolean)Arrays.equals(key, (byte[])entry.getValue()), (String)("Keys don't match for alias " + entry.getKey()));
        }
        tmpFileName.delete();
    }

    @Test
    public void testBasicReadWriteProtoEmpty() throws IOException, NoSuchAlgorithmException {
        String testname = "testBasicReadWriteProtoEmpty";
        Credentials ts = new Credentials();
        this.writeCredentialsProto(ts, testname);
        Credentials ts2 = this.readCredentialsProto(testname);
        Assertions.assertEquals((int)0, (int)ts2.numberOfTokens(), (String)"test empty tokens");
        Assertions.assertEquals((int)0, (int)ts2.numberOfSecretKeys(), (String)"test empty keys");
    }

    @Test
    public void testBasicReadWriteProto() throws IOException, NoSuchAlgorithmException {
        String testname = "testBasicReadWriteProto";
        Text tok1 = new Text("token1");
        Text tok2 = new Text("token2");
        Text key1 = new Text("key1");
        Credentials ts = this.generateCredentials(tok1, tok2, key1);
        this.writeCredentialsProto(ts, testname);
        Credentials ts2 = this.readCredentialsProto(testname);
        this.assertCredentials(testname, tok1, key1, ts, ts2);
        this.assertCredentials(testname, tok2, key1, ts, ts2);
    }

    @Test
    public void testBasicReadWriteStreamEmpty() throws IOException, NoSuchAlgorithmException {
        String testname = "testBasicReadWriteStreamEmpty";
        Credentials ts = new Credentials();
        this.writeCredentialsStream(ts, testname);
        Credentials ts2 = this.readCredentialsStream(testname);
        Assertions.assertEquals((int)0, (int)ts2.numberOfTokens(), (String)"test empty tokens");
        Assertions.assertEquals((int)0, (int)ts2.numberOfSecretKeys(), (String)"test empty keys");
    }

    @Test
    public void testBasicReadWriteStream() throws IOException, NoSuchAlgorithmException {
        String testname = "testBasicReadWriteStream";
        Text tok1 = new Text("token1");
        Text tok2 = new Text("token2");
        Text key1 = new Text("key1");
        Credentials ts = this.generateCredentials(tok1, tok2, key1);
        this.writeCredentialsStream(ts, testname);
        Credentials ts2 = this.readCredentialsStream(testname);
        this.assertCredentials(testname, tok1, key1, ts, ts2);
        this.assertCredentials(testname, tok2, key1, ts, ts2);
    }

    @Test
    public void testWritablePropertiesEmpty() throws IOException, NoSuchAlgorithmException {
        String testname = "testWritablePropertiesEmpty";
        Credentials ts = new Credentials();
        Credentials ts2 = new Credentials();
        this.writeCredentialsProtos(ts, ts2, testname);
        List<Credentials> clist = this.readCredentialsProtos(testname);
        Assertions.assertEquals((int)0, (int)clist.get(0).numberOfTokens(), (String)"test empty tokens 0");
        Assertions.assertEquals((int)0, (int)clist.get(0).numberOfSecretKeys(), (String)"test empty keys 0");
        Assertions.assertEquals((int)0, (int)clist.get(1).numberOfTokens(), (String)"test empty tokens 1");
        Assertions.assertEquals((int)0, (int)clist.get(1).numberOfSecretKeys(), (String)"test empty keys 1");
    }

    @Test
    public void testWritableProperties() throws IOException, NoSuchAlgorithmException {
        String testname = "testWritableProperties";
        Text tok1 = new Text("token1");
        Text tok2 = new Text("token2");
        Text key1 = new Text("key1");
        Credentials ts = this.generateCredentials(tok1, tok2, key1);
        Text tok3 = new Text("token3");
        Text key2 = new Text("key2");
        Credentials ts2 = this.generateCredentials(tok1, tok3, key2);
        this.writeCredentialsProtos(ts, ts2, testname);
        List<Credentials> clist = this.readCredentialsProtos(testname);
        this.assertCredentials(testname, tok1, key1, ts, clist.get(0));
        this.assertCredentials(testname, tok2, key1, ts, clist.get(0));
        this.assertCredentials(testname, tok1, key2, ts2, clist.get(1));
        this.assertCredentials(testname, tok3, key2, ts2, clist.get(1));
    }

    private Credentials generateCredentials(Text t1, Text t2, Text t3) throws NoSuchAlgorithmException {
        Text kind = new Text("TESTTOK");
        byte[] id1 = new byte[]{105, 100, 101, 110, 116, 105, 102, 105, 101, 114};
        byte[] pass1 = new byte[]{112, 97, 115, 115, 119, 111, 114, 100};
        byte[] id2 = new byte[]{104, 99, 100, 109, 115, 104, 101, 104, 100, 113};
        byte[] pass2 = new byte[]{111, 96, 114, 114, 118, 110, 113, 99};
        Credentials ts = new Credentials();
        this.generateToken(ts, id1, pass1, kind, t1);
        this.generateToken(ts, id2, pass2, kind, t2);
        this.generateKey(ts, t3);
        return ts;
    }

    private void assertCredentials(String tag, Text alias, Text keykey, Credentials a, Credentials b) {
        Assertions.assertEquals((int)a.numberOfTokens(), (int)b.numberOfTokens(), (String)(tag + ": test token count"));
        Assertions.assertEquals((Object)a.getToken(alias).getService(), (Object)b.getToken(alias).getService(), (String)(tag + ": test service"));
        Assertions.assertEquals((Object)a.getToken(alias).getKind(), (Object)b.getToken(alias).getKind(), (String)(tag + ": test kind"));
        Assertions.assertTrue((boolean)Arrays.equals(a.getToken(alias).getPassword(), b.getToken(alias).getPassword()), (String)(tag + ": test password"));
        Assertions.assertTrue((boolean)Arrays.equals(a.getToken(alias).getIdentifier(), b.getToken(alias).getIdentifier()), (String)(tag + ": test identifier"));
        Assertions.assertEquals((int)a.numberOfSecretKeys(), (int)b.numberOfSecretKeys(), (String)(tag + ": test number of keys"));
        Assertions.assertTrue((boolean)Arrays.equals(a.getSecretKey(keykey), b.getSecretKey(keykey)), (String)(tag + ":test key values"));
    }

    private void writeCredentialsStream(Credentials creds, String filename) throws IOException, FileNotFoundException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(tmpDir, filename)));
        creds.writeTokenStorageToStream(dos);
    }

    private Credentials readCredentialsStream(String filename) throws IOException, FileNotFoundException {
        Credentials creds = new Credentials();
        DataInputStream dis = new DataInputStream(new FileInputStream(new File(tmpDir, filename)));
        creds.readTokenStorageStream(dis);
        return creds;
    }

    private void writeCredentialsProto(Credentials creds, String filename) throws IOException, FileNotFoundException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(tmpDir, filename)));
        creds.writeProto((DataOutput)dos);
    }

    private Credentials readCredentialsProto(String filename) throws IOException, FileNotFoundException {
        Credentials creds = new Credentials();
        DataInputStream dis = new DataInputStream(new FileInputStream(new File(tmpDir, filename)));
        creds.readProto((DataInput)dis);
        return creds;
    }

    private void writeCredentialsProtos(Credentials c1, Credentials c2, String filename) throws IOException, FileNotFoundException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(new File(tmpDir, filename)));
        c1.writeProto((DataOutput)dos);
        c2.writeProto((DataOutput)dos);
    }

    private List<Credentials> readCredentialsProtos(String filename) throws IOException, FileNotFoundException {
        Credentials c1 = new Credentials();
        Credentials c2 = new Credentials();
        DataInputStream dis = new DataInputStream(new FileInputStream(new File(tmpDir, filename)));
        c1.readProto((DataInput)dis);
        c2.readProto((DataInput)dis);
        ArrayList<Credentials> r = new ArrayList<Credentials>(2);
        r.add(0, c1);
        r.add(1, c2);
        return r;
    }

    private <T extends TokenIdentifier> void generateToken(Credentials creds, byte[] ident, byte[] pass, Text kind, Text service) {
        Token token = new Token(ident, pass, kind, service);
        creds.addToken(service, token);
    }

    private void generateKey(Credentials creds, Text alias) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance(DEFAULT_HMAC_ALGORITHM);
        SecretKey key = kg.generateKey();
        creds.addSecretKey(alias, key.getEncoded());
    }

    @Test
    public void addAll() {
        Credentials creds = new Credentials();
        creds.addToken(service[0], token[0]);
        creds.addToken(service[1], token[1]);
        creds.addSecretKey(secret[0], secret[0].getBytes());
        creds.addSecretKey(secret[1], secret[1].getBytes());
        Credentials credsToAdd = new Credentials();
        credsToAdd.addToken(service[0], token[3]);
        credsToAdd.addToken(service[2], token[2]);
        credsToAdd.addSecretKey(secret[0], secret[3].getBytes());
        credsToAdd.addSecretKey(secret[2], secret[2].getBytes());
        creds.addAll(credsToAdd);
        Assertions.assertEquals((int)3, (int)creds.numberOfTokens());
        Assertions.assertEquals((int)3, (int)creds.numberOfSecretKeys());
        Assertions.assertEquals(token[3], (Object)creds.getToken(service[0]));
        Assertions.assertEquals((Object)secret[3], (Object)new Text(creds.getSecretKey(secret[0])));
        Assertions.assertEquals(token[1], (Object)creds.getToken(service[1]));
        Assertions.assertEquals((Object)secret[1], (Object)new Text(creds.getSecretKey(secret[1])));
        Assertions.assertEquals(token[2], (Object)creds.getToken(service[2]));
        Assertions.assertEquals((Object)secret[2], (Object)new Text(creds.getSecretKey(secret[2])));
    }

    @Test
    public void mergeAll() {
        Credentials creds = new Credentials();
        creds.addToken(service[0], token[0]);
        creds.addToken(service[1], token[1]);
        creds.addSecretKey(secret[0], secret[0].getBytes());
        creds.addSecretKey(secret[1], secret[1].getBytes());
        Credentials credsToAdd = new Credentials();
        credsToAdd.addToken(service[0], token[3]);
        credsToAdd.addToken(service[2], token[2]);
        credsToAdd.addSecretKey(secret[0], secret[3].getBytes());
        credsToAdd.addSecretKey(secret[2], secret[2].getBytes());
        creds.mergeAll(credsToAdd);
        Assertions.assertEquals((int)3, (int)creds.numberOfTokens());
        Assertions.assertEquals((int)3, (int)creds.numberOfSecretKeys());
        Assertions.assertEquals(token[0], (Object)creds.getToken(service[0]));
        Assertions.assertEquals((Object)secret[0], (Object)new Text(creds.getSecretKey(secret[0])));
        Assertions.assertEquals(token[1], (Object)creds.getToken(service[1]));
        Assertions.assertEquals((Object)secret[1], (Object)new Text(creds.getSecretKey(secret[1])));
        Assertions.assertEquals(token[2], (Object)creds.getToken(service[2]));
        Assertions.assertEquals((Object)secret[2], (Object)new Text(creds.getSecretKey(secret[2])));
    }

    @Test
    public void testAddTokensToUGI() {
        int i;
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"someone");
        Credentials creds = new Credentials();
        for (i = 0; i < service.length; ++i) {
            creds.addToken(service[i], token[i]);
        }
        ugi.addCredentials(creds);
        creds = ugi.getCredentials();
        for (i = 0; i < service.length; ++i) {
            Assertions.assertSame(token[i], (Object)creds.getToken(service[i]));
        }
        Assertions.assertEquals((int)service.length, (int)creds.numberOfTokens());
    }
}

